/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.event;

import architectspalette.content.blocks.VerticalSlabBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architects_palette", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CreativeModeTabEventHandler {
    private static final List<Supplier<? extends ItemLike>> items = new ArrayList<Supplier<? extends ItemLike>>();
    private static final List<ResourceKey<CreativeModeTab>> tabs = new ArrayList<ResourceKey<CreativeModeTab>>();

    @SafeVarargs
    public static void assignItemToTab(Supplier<? extends ItemLike> item, ResourceKey<CreativeModeTab> ... in_tabs) {
        for (ResourceKey<CreativeModeTab> tab : in_tabs) {
            items.add(item);
            tabs.add(tab);
        }
    }

    @SubscribeEvent
    public static void onCreativeTabRegister(BuildCreativeModeTabContentsEvent event) {
        int i = 0;
        for (Supplier<? extends ItemLike> item : items) {
            if (event.getTabKey() == tabs.get(i) && (!(item.get() instanceof VerticalSlabBlock) || VerticalSlabBlock.isQuarkEnabled())) {
                event.accept(item);
            }
            ++i;
        }
    }
}

