/*
 * Decompiled with CFR 0.152.
 */
package architectspalette.core.datagen;

import architectspalette.core.registry.APBlocks;
import architectspalette.core.registry.util.BlockNode;
import architectspalette.core.registry.util.StoneBlockSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class APLootTables
extends LootTableProvider {
    public APLootTables(PackOutput pack) {
        super(pack, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(APBlockLoot::new, LootContextParamSets.f_81421_)));
    }

    private static class APBlockLoot
    extends BlockLootSubProvider {
        protected APBlockLoot() {
            super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            BlockNode.forAllBaseNodes(this::processBlockNode);
            this.m_246481_((Block)APBlocks.TWISTED_LEAVES.get(), leaves -> this.m_246047_((Block)leaves, (Block)APBlocks.TWISTED_SAPLING.get(), f_244509_));
        }

        protected Iterable<Block> getKnownBlocks() {
            LinkedList<Block> blocks = new LinkedList<Block>();
            BlockNode.forAllBaseNodes(node -> node.forEach(n -> blocks.add(n.get())));
            blocks.add((Block)APBlocks.TWISTED_LEAVES.get());
            return blocks;
        }

        private void slab(Block block) {
            this.m_247577_(block, this.m_247233_(block));
        }

        private void processStoneBlockSet(StoneBlockSet set) {
            set.forEachPart((part, block) -> {
                if (part == StoneBlockSet.SetComponent.SLAB) {
                    this.slab((Block)block);
                } else if (part == StoneBlockSet.SetComponent.VERTICAL_SLAB) {
                    this.slab((Block)block);
                } else {
                    this.m_245724_((Block)block);
                }
            });
        }

        private void processBlockNode(BlockNode node) {
            node.forEach(n -> {
                Block block = n.get();
                switch (n.type) {
                    case SLAB: 
                    case VERTICAL_SLAB: {
                        this.slab(block);
                        break;
                    }
                    default: {
                        this.m_245724_(block);
                    }
                }
            });
        }
    }
}

