/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import reliquary.crafting.MobCharmRecipe;
import reliquary.init.ModItems;
import reliquary.items.MobCharmFragmentItem;
import reliquary.items.MobCharmItem;
import reliquary.items.MobCharmRegistry;

public class MobCharmRecipeMaker {
    private MobCharmRecipeMaker() {
    }

    public static List<CraftingRecipe> getRecipes() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        MobCharmRecipe.REGISTERED_RECIPES.forEach(baseRecipe -> MobCharmRecipeMaker.addMobCharmRecipes(recipes, baseRecipe));
        return recipes;
    }

    private static void addMobCharmRecipes(List<CraftingRecipe> recipes, MobCharmRecipe baseRecipe) {
        for (String regName : MobCharmRegistry.getRegisteredNames()) {
            NonNullList inputs = NonNullList.m_122779_();
            baseRecipe.m_7527_().forEach(i -> {
                if (Arrays.stream(i.m_43908_()).anyMatch(stack -> stack.m_41720_() instanceof MobCharmFragmentItem)) {
                    ItemStack[] items = new ItemStack[i.m_43908_().length];
                    for (int j = 0; j < i.m_43908_().length; ++j) {
                        ItemStack item = i.m_43908_()[j];
                        items[j] = item.m_41720_() instanceof MobCharmFragmentItem ? ((MobCharmFragmentItem)ModItems.MOB_CHARM_FRAGMENT.get()).getStackFor(regName) : item;
                    }
                    inputs.add((Object)Ingredient.m_43927_((ItemStack[])items));
                } else {
                    inputs.add(i);
                }
            });
            ItemStack output = ((MobCharmItem)ModItems.MOB_CHARM.get()).getStackFor(regName);
            ResourceLocation id = new ResourceLocation("reliquary", "mob_charm_" + regName.replace(':', '_'));
            recipes.add((CraftingRecipe)new ShapedRecipe(id, "reliquary.mob_charm", CraftingBookCategory.MISC, 3, 3, inputs, output));
        }
    }
}

