/*
 * Decompiled with CFR 0.152.
 */
package reliquary.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import reliquary.client.gui.GuiBase;
import reliquary.common.gui.MobCharmBeltMenu;
import reliquary.init.ModItems;
import reliquary.items.MobCharmBeltItem;
import reliquary.items.MobCharmRegistry;
import reliquary.util.LogHelper;

public class MobCharmBeltGui
extends GuiBase<MobCharmBeltMenu> {
    private static final ResourceLocation BELT_TEX = new ResourceLocation("reliquary", "textures/gui/mob_charm_belt.png");
    private static final ResourceLocation BELT_ITEM_TEX = new ResourceLocation("reliquary", "textures/item/mob_charm_belt.png");
    private static final int WIDTH = 175;
    private static final int HEIGHT = 221;
    private final ItemStack belt;
    private static final Field SLOT_X_POS = ObfuscationReflectionHelper.findField(Slot.class, (String)"f_40220_");
    private static final Field SLOT_Y_POS = ObfuscationReflectionHelper.findField(Slot.class, (String)"f_40221_");

    public MobCharmBeltGui(MobCharmBeltMenu container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        this.belt = container.getBelt();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        guiGraphics.m_280218_(BELT_TEX, i, j - 27, 0, 0, 175, 221);
        int centerX = i + 88;
        int centerY = j + 40;
        this.updateMobCharmSlots(guiGraphics, centerX, centerY);
        GlStateManager._enableBlend();
        guiGraphics.m_280163_(BELT_ITEM_TEX, centerX - 26, centerY - 26, 0.0f, 0.0f, 48, 48, 48, 48);
        GlStateManager._disableBlend();
    }

    protected void m_280003_(GuiGraphics guiGraphics, int x, int y) {
    }

    private void updateMobCharmSlots(GuiGraphics guiGraphics, int centerX, int centerY) {
        int i;
        int slots = ((MobCharmBeltItem)ModItems.MOB_CHARM_BELT.get()).getCharmCount(this.belt);
        slots = Math.min(slots, MobCharmRegistry.getRegisteredNames().size());
        double radius = 44.0;
        double increment = Math.PI * 2 / (double)(slots + 1);
        double start = 1.5707963267948966;
        for (i = 1; i <= slots; ++i) {
            double angle = start + (double)i * increment;
            int offsetX = (int)Math.round(Math.cos(angle) * radius);
            int offsetY = (int)Math.round(Math.sin(angle) * radius);
            int x = centerX - offsetX - 8;
            int y = centerY - offsetY - 8;
            RenderSystem.enableBlend();
            guiGraphics.m_280218_(BELT_TEX, x, y, 176, 0, 16, 16);
            RenderSystem.disableBlend();
            MobCharmBeltGui.setSlotXPos((Slot)((MobCharmBeltMenu)this.f_97732_).f_38839_.get(i - 1), x - centerX + 88);
            MobCharmBeltGui.setSlotYPos((Slot)((MobCharmBeltMenu)this.f_97732_).f_38839_.get(i - 1), y - centerY + 40);
        }
        MobCharmBeltGui.setSlotXPos((Slot)((MobCharmBeltMenu)this.f_97732_).f_38839_.get(slots), 80);
        MobCharmBeltGui.setSlotYPos((Slot)((MobCharmBeltMenu)this.f_97732_).f_38839_.get(slots), -12);
        for (i = slots + 1; i < MobCharmRegistry.getRegisteredNames().size() + 1; ++i) {
            MobCharmBeltGui.setSlotXPos((Slot)((MobCharmBeltMenu)this.f_97732_).f_38839_.get(i), -999);
        }
    }

    private static void setSlotXPos(Slot slot, int xPos) {
        try {
            SLOT_X_POS.set(slot, xPos);
        }
        catch (IllegalAccessException e) {
            LogHelper.error("Error setting xPos of Slot: ", e);
        }
    }

    private static void setSlotYPos(Slot slot, int yPos) {
        try {
            SLOT_Y_POS.set(slot, yPos);
        }
        catch (IllegalAccessException e) {
            LogHelper.error("Error setting yPos of Slot: ", e);
        }
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }
}

