/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketNetworkItems;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ItemTerminalBlockEntity
extends BlockEntity
implements IPipeConnectable,
MenuProvider {
    public final ItemStackHandler items = new ItemStackHandler(12){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    };
    protected Map<EquatableItemStack, NetworkItem> networkItems;
    private final Queue<NetworkLock> existingRequests = new LinkedList<NetworkLock>();
    private final LazyOptional<IPipeConnectable> lazyThis = LazyOptional.of(() -> this);

    public ItemTerminalBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemTerminalBlockEntity(BlockPos pos, BlockState state) {
        this(Registry.itemTerminalBlockEntity, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ItemTerminalBlockEntity terminal) {
        Player[] lookingPlayers;
        int interval;
        if (terminal.f_58857_.f_46443_) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(terminal.f_58857_);
        PipeBlockEntity pipe = terminal.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        boolean update = false;
        int n = interval = pipe.pressurizer != null ? 2 : 10;
        if (terminal.f_58857_.m_46467_() % (long)interval == 0L) {
            for (int i = 6; i < 12; ++i) {
                ItemStack remain;
                ItemStack extracted = terminal.items.extractItem(i, Integer.MAX_VALUE, true);
                if (extracted.m_41619_() || (remain = network.routeItem(pipe.m_58899_(), terminal.m_58899_(), extracted, true)).m_41613_() == extracted.m_41613_()) continue;
                terminal.items.extractItem(i, extracted.m_41613_() - remain.m_41613_(), false);
                break;
            }
            if (!terminal.existingRequests.isEmpty()) {
                NetworkLock request = terminal.existingRequests.remove();
                network.resolveNetworkLock(request);
                network.requestExistingItem(request.location, pipe.m_58899_(), terminal.m_58899_(), request, request.stack, ItemEquality.NBT);
                update = true;
            }
        }
        if ((terminal.f_58857_.m_46467_() % 100L == 0L || update) && (lookingPlayers = terminal.getLookingPlayers()).length > 0) {
            terminal.updateItems(lookingPlayers);
        }
    }

    public void m_7651_() {
        super.m_7651_();
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        for (NetworkLock lock : this.existingRequests) {
            network.resolveNetworkLock(lock);
        }
        this.lazyThis.invalidate();
    }

    public String getInvalidTerminalReason() {
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        long pipes = Arrays.stream(Direction.values()).map(d -> network.getPipe(this.f_58858_.m_121945_(d))).filter(Objects::nonNull).count();
        if (pipes <= 0L) {
            return "info.prettypipes.no_pipe_connected";
        }
        if (pipes > 1L) {
            return "info.prettypipes.too_many_pipes_connected";
        }
        return null;
    }

    public PipeBlockEntity getConnectedPipe() {
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        for (Direction dir : Direction.values()) {
            PipeBlockEntity pipe = network.getPipe(this.f_58858_.m_121945_(dir));
            if (pipe == null) continue;
            return pipe;
        }
        return null;
    }

    public void updateItems(Player ... playersToSync) {
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        this.networkItems = this.collectItems(ItemEquality.NBT);
        if (playersToSync.length > 0) {
            List<ItemStack> clientItems = this.networkItems.values().stream().map(NetworkItem::asStack).collect(Collectors.toList());
            List<ItemStack> clientCraftables = PipeNetwork.get(this.f_58857_).getAllCraftables(pipe.m_58899_()).stream().map(Pair::getRight).collect(Collectors.toList());
            List<ItemStack> currentlyCrafting = this.getCurrentlyCrafting().stream().sorted(Comparator.comparingInt(ItemStack::m_41613_).reversed()).collect(Collectors.toList());
            for (Player player : playersToSync) {
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (!(abstractContainerMenu instanceof ItemTerminalContainer)) continue;
                ItemTerminalContainer container = (ItemTerminalContainer)abstractContainerMenu;
                if (container.tile != this) continue;
                PacketHandler.sendTo(player, new PacketNetworkItems(clientItems, clientCraftables, currentlyCrafting));
            }
        }
    }

    public void requestItem(Player player, ItemStack stack, int nbtHash) {
        int requested;
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        network.startProfile("terminal_request_item");
        this.updateItems(new Player[0]);
        if (nbtHash != 0) {
            ItemStack filter = stack;
            stack = this.networkItems.values().stream().map(NetworkItem::asStack).filter(s -> ItemEquality.compareItems(s, filter, new ItemEquality[0]) && s.m_41782_() && s.m_41783_().hashCode() == nbtHash).findFirst().orElse(filter);
            stack.m_41764_(filter.m_41613_());
        }
        if ((requested = this.requestItemImpl(stack, ItemTerminalBlockEntity.onItemUnavailable(player, false))) > 0) {
            player.m_213846_((Component)Component.m_237110_((String)"info.prettypipes.sending", (Object[])new Object[]{requested, stack.m_41786_()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GREEN)));
        } else {
            ItemTerminalBlockEntity.onItemUnavailable(player, false).accept(stack);
        }
        network.endProfile();
    }

    public int requestItemImpl(ItemStack stack, Consumer<ItemStack> unavailableConsumer) {
        NetworkItem item = this.networkItems.get(new EquatableItemStack(stack, ItemEquality.NBT));
        List<NetworkLocation> locations = item == null ? Collections.emptyList() : item.getLocations();
        Pair<List<NetworkLock>, ItemStack> ret = ItemTerminalBlockEntity.requestItemLater(this.f_58857_, this.getConnectedPipe().m_58899_(), locations, unavailableConsumer, stack, new Stack<ItemStack>(), ItemEquality.NBT);
        this.existingRequests.addAll((Collection)ret.getLeft());
        return stack.m_41613_() - ((ItemStack)ret.getRight()).m_41613_();
    }

    public Player[] getLookingPlayers() {
        return (Player[])this.f_58857_.m_6907_().stream().filter(p -> {
            AbstractContainerMenu patt8621$temp = p.f_36096_;
            if (!(patt8621$temp instanceof ItemTerminalContainer)) return false;
            ItemTerminalContainer container = (ItemTerminalContainer)patt8621$temp;
            if (container.tile != this) return false;
            return true;
        }).toArray(Player[]::new);
    }

    private Map<EquatableItemStack, NetworkItem> collectItems(ItemEquality ... equalityTypes) {
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        network.startProfile("terminal_collect_items");
        PipeBlockEntity pipe = this.getConnectedPipe();
        HashMap<EquatableItemStack, NetworkItem> items = new HashMap<EquatableItemStack, NetworkItem>();
        for (NetworkLocation location : network.getOrderedNetworkItems(pipe.m_58899_())) {
            for (Map.Entry<Integer, ItemStack> entry : location.getItems(this.f_58857_).entrySet()) {
                if (!location.canExtract(this.f_58857_, entry.getKey())) continue;
                EquatableItemStack equatable = new EquatableItemStack(entry.getValue(), equalityTypes);
                NetworkItem item = items.computeIfAbsent(equatable, NetworkItem::new);
                item.add(location, entry.getValue());
            }
        }
        network.endProfile();
        return items;
    }

    private List<ItemStack> getCurrentlyCrafting() {
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return Collections.emptyList();
        }
        List<Pair<BlockPos, ItemStack>> crafting = network.getCurrentlyCrafting(pipe.m_58899_(), new ItemEquality[0]);
        return crafting.stream().map(Pair::getRight).collect(Collectors.toList());
    }

    public void cancelCrafting() {
        PipeNetwork network = PipeNetwork.get(this.f_58857_);
        PipeBlockEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        for (Pair<BlockPos, ItemStack> craftable : network.getAllCraftables(pipe.m_58899_())) {
            PipeBlockEntity otherPipe = network.getPipe((BlockPos)craftable.getLeft());
            if (otherPipe == null) continue;
            for (NetworkLock lock : otherPipe.craftIngredientRequests) {
                network.resolveNetworkLock(lock);
            }
            otherPipe.craftIngredientRequests.clear();
            otherPipe.craftResultRequests.clear();
        }
        Player[] lookingPlayers = this.getLookingPlayers();
        if (lookingPlayers.length > 0) {
            this.updateItems(lookingPlayers);
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("items", (Tag)this.items.serializeNBT());
        compound.m_128365_("requests", (Tag)Utility.serializeAll(this.existingRequests));
    }

    public void m_142466_(CompoundTag compound) {
        this.items.deserializeNBT(compound.m_128469_("items"));
        this.existingRequests.clear();
        this.existingRequests.addAll(Utility.deserializeAll(compound.m_128437_("requests", 10), NetworkLock::new));
        super.m_142466_(compound);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.prettypipes.item_terminal");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int window, Inventory inv, Player player) {
        return new ItemTerminalContainer(Registry.itemTerminalContainer, window, player, this.f_58858_);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Registry.pipeConnectableCapability) {
            return this.lazyThis.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public ConnectionType getConnectionType(BlockPos pipePos, Direction direction) {
        return ConnectionType.CONNECTED;
    }

    @Override
    public ItemStack insertItem(BlockPos pipePos, Direction direction, ItemStack stack, boolean simulate) {
        BlockPos pos = pipePos.m_121945_(direction);
        ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)this.f_58857_, pos);
        if (tile != null) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)tile.items, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    @Override
    public boolean allowsModules(BlockPos pipePos, Direction direction) {
        return true;
    }

    public static Pair<List<NetworkLock>, ItemStack> requestItemLater(Level world, BlockPos destPipe, Collection<NetworkLocation> locations, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        ArrayList<NetworkLock> requests = new ArrayList<NetworkLock>();
        ItemStack remain = stack.m_41777_();
        PipeNetwork network = PipeNetwork.get(world);
        for (NetworkLocation location : locations) {
            int amount = location.getItemAmount(world, stack, equalityTypes);
            if (amount <= 0 || (amount -= network.getLockedAmount(location.getPos(), stack, null, equalityTypes)) <= 0) continue;
            if (remain.m_41613_() < amount) {
                amount = remain.m_41613_();
            }
            remain.m_41774_(amount);
            while (amount > 0) {
                ItemStack copy = stack.m_41777_();
                copy.m_41764_(Math.min(stack.m_41741_(), amount));
                NetworkLock lock = new NetworkLock(location, copy);
                network.createNetworkLock(lock);
                requests.add(lock);
                amount -= copy.m_41613_();
            }
            if (!remain.m_41619_()) continue;
            break;
        }
        if (!remain.m_41619_()) {
            remain = network.requestCraftedItem(destPipe, unavailableConsumer, remain, dependencyChain, equalityTypes);
        }
        return Pair.of(requests, (Object)remain);
    }

    public static Consumer<ItemStack> onItemUnavailable(Player player, boolean ignore) {
        return s -> {
            if (ignore) {
                return;
            }
            player.m_213846_((Component)Component.m_237110_((String)"info.prettypipes.not_found", (Object[])new Object[]{s.m_41786_()}).m_6270_(Style.f_131099_.m_131157_(ChatFormatting.RED)));
        };
    }
}

