/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe;

import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.INBTSerializable;
import org.jgrapht.GraphPath;

public interface IPipeItem
extends INBTSerializable<CompoundTag> {
    public static final Map<ResourceLocation, BiFunction<ResourceLocation, CompoundTag, IPipeItem>> TYPES = new HashMap<ResourceLocation, BiFunction<ResourceLocation, CompoundTag, IPipeItem>>(Collections.singletonMap(PipeItem.TYPE, PipeItem::new));

    public ItemStack getContent();

    public void setDestination(BlockPos var1, BlockPos var2, GraphPath<BlockPos, NetworkEdge> var3);

    public void updateInPipe(PipeBlockEntity var1);

    public void drop(Level var1, ItemStack var2);

    public BlockPos getDestPipe();

    public BlockPos getCurrentPipe();

    public BlockPos getDestInventory();

    public int getItemsOnTheWay(BlockPos var1);

    @OnlyIn(value=Dist.CLIENT)
    public void render(PipeBlockEntity var1, PoseStack var2, Random var3, float var4, int var5, int var6, MultiBufferSource var7);

    public static IPipeItem load(CompoundTag nbt) {
        ResourceLocation type = new ResourceLocation(nbt.m_128461_("type"));
        BiFunction<ResourceLocation, CompoundTag, IPipeItem> func = TYPES.get(type);
        return func != null ? func.apply(type, nbt) : null;
    }
}

