/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.forge;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.networking.carbon.ConfigAnswerPacket;
import io.netty.buffer.Unpooled;
import java.nio.file.Files;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class RequestConfigPacket
implements ICarbonPacket {
    ModConfig.Type type;
    UUID requestId;
    String modId;

    public RequestConfigPacket() {
    }

    public RequestConfigPacket(ModConfig.Type type, UUID requestId, String modId) {
        this.type = type;
        this.requestId = requestId;
        this.modId = modId;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        buffer.m_130077_(this.requestId);
        buffer.m_130072_(this.modId, Short.MAX_VALUE);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.type = (ModConfig.Type)buffer.m_130066_(ModConfig.Type.class);
        this.requestId = buffer.m_130259_();
        this.modId = buffer.m_130136_(Short.MAX_VALUE);
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        ModConfig config = this.findConfig();
        if (config == null) {
            return;
        }
        byte[] result = this.getData(config);
        if (result == null) {
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130087_(result);
        byte[] data = new byte[buf.writerIndex()];
        buf.readBytes(data);
        CarbonConfig.NETWORK.sendToPlayer(new ConfigAnswerPacket(this.requestId, data), player);
    }

    private byte[] getData(ModConfig config) {
        try {
            return Files.readAllBytes(config.getFullPath());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ModConfig findConfig() {
        for (ModConfig config : (Set)ConfigTracker.INSTANCE.configSets().get(this.type)) {
            if (!this.modId.equalsIgnoreCase(config.getModId())) continue;
            return config;
        }
        return null;
    }
}

