/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.api;

import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.BooleanElement;
import carbonconfiglib.gui.config.ConfigElement;
import carbonconfiglib.gui.config.EnumElement;
import carbonconfiglib.gui.config.NumberElement;
import carbonconfiglib.gui.config.StringElement;
import carbonconfiglib.utils.structure.IStructuredData;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import speiger.src.collections.objects.utils.ObjectIterables;
import speiger.src.collections.objects.utils.ObjectLists;

public class DataType {
    public static final DataType BOOLEAN = new DataType(false, "false", BooleanElement::new, BooleanElement::new, BooleanElement::new);
    public static final DataType INTEGER = new DataType(false, "0", NumberElement::new, NumberElement::new, NumberElement::new);
    public static final DataType DOUBLE = new DataType(false, "0.0", NumberElement::new, NumberElement::new, NumberElement::new);
    public static final DataType STRING = new DataType(true, " ", StringElement::new, StringElement::new, StringElement::new);
    public static final DataType ENUM = new DataType(true, " ", EnumElement::new, EnumElement::new, EnumElement::new);
    private static final Map<Class<?>, DataType> AUTO_DATA_TYPES = Object2ObjectMaps.synchronize((Object2ObjectMap)new Object2ObjectOpenHashMap());
    boolean allowsEmptyValue;
    String defaultValue;
    Function<IValueNode, ConfigElement> creator;
    BiFunction<IArrayNode, IValueNode, ConfigElement> arrayCreator;
    BiFunction<ICompoundNode, IValueNode, ConfigElement> compoundCreator;

    public DataType(boolean allowsEmptyValue, String defaultValue, Function<IValueNode, ConfigElement> creator, BiFunction<IArrayNode, IValueNode, ConfigElement> arrayCreator, BiFunction<ICompoundNode, IValueNode, ConfigElement> compoundCreator) {
        this.allowsEmptyValue = allowsEmptyValue;
        this.defaultValue = defaultValue;
        this.creator = creator;
        this.arrayCreator = arrayCreator;
        this.compoundCreator = compoundCreator;
    }

    public ConfigElement create(IValueNode node) {
        return this.creator.apply(node);
    }

    public ConfigElement create(IArrayNode array, IValueNode node) {
        return this.arrayCreator.apply(array, node);
    }

    public ConfigElement create(ICompoundNode compound, IValueNode node) {
        return this.compoundCreator.apply(compound, node);
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isAllowEmptyValue() {
        return this.allowsEmptyValue;
    }

    public static List<DataType> resolve(IStructuredData data) {
        switch (data.getDataType()) {
            case COMPOUND: {
                return ObjectIterables.flatMap(data.asCompound().getFormat().values(), DataType::resolve).pourAsList();
            }
            case LIST: {
                return DataType.resolve(data.asList().getType());
            }
            case SIMPLE: {
                return ObjectLists.singleton((Object)DataType.bySimple(data.asSimple()));
            }
        }
        return ObjectLists.empty();
    }

    public static DataType bySimple(IStructuredData.SimpleData type) {
        return DataType.byConfig(type.isVariant() ? IStructuredData.EntryDataType.CUSTOM : type.getType(), type.getVariant());
    }

    public static DataType byConfig(IStructuredData.EntryDataType type, Class<?> variant) {
        switch (type) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case INTEGER: {
                return INTEGER;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case STRING: {
                return STRING;
            }
            case ENUM: {
                return ENUM;
            }
            case CUSTOM: {
                return DataType.byClass(variant);
            }
        }
        throw new IllegalStateException("Undefined DataType shouldn't be used");
    }

    public static DataType byClass(Class<?> clz) {
        return AUTO_DATA_TYPES.getOrDefault(clz, STRING);
    }

    public static void registerType(Class<?> clz, DataType type) {
        AUTO_DATA_TYPES.putIfAbsent(clz, type);
    }

    public static interface IArrayFunction {
        public ConfigElement create(IConfigNode var1, IArrayNode var2, int var3);
    }
}

