/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.config;

import carbonconfiglib.api.ConfigType;
import carbonconfiglib.api.IConfigProxy;
import carbonconfiglib.api.ILogger;
import carbonconfiglib.config.Config;
import carbonconfiglib.config.ConfigEntry;
import carbonconfiglib.config.ConfigSection;
import carbonconfiglib.config.ConfigSettings;
import carbonconfiglib.config.FileSystemWatcher;
import carbonconfiglib.utils.AutomationType;
import carbonconfiglib.utils.Helpers;
import carbonconfiglib.utils.MultilinePolicy;
import carbonconfiglib.utils.ParseExpection;
import carbonconfiglib.utils.ParseResult;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.List;
import speiger.src.collections.chars.maps.impl.hash.Char2ObjectOpenHashMap;
import speiger.src.collections.chars.maps.interfaces.Char2ObjectMap;
import speiger.src.collections.objects.lists.ObjectArrayList;

public final class ConfigHandler {
    private Path cfgDir;
    private Path configFile;
    private boolean isLoaded;
    private boolean registered;
    private int wasSaving = 0;
    private final String subFolder;
    private final Config config;
    private final EnumSet<AutomationType> setting;
    private final MultilinePolicy policy;
    public final ConfigType type;
    private final List<ConfigError> errors = new ObjectArrayList();
    private final IConfigProxy proxy;
    private final ILogger logger;
    private FileSystemWatcher owner;
    private List<Runnable> loadedListeners = new ObjectArrayList();
    private Char2ObjectMap<IConfigParser> parsers = new Char2ObjectOpenHashMap();

    ConfigHandler(Config config, ConfigSettings settings) {
        this(settings.getSubFolder(), settings.getProxy(), settings.getLogger(), config, settings.getAutomationType(), settings.getMultilinePolicy(), settings.getType());
    }

    ConfigHandler(String subFolder, IConfigProxy proxy, ILogger logger, Config config, EnumSet<AutomationType> setting, MultilinePolicy policy, ConfigType type) {
        this.config = config;
        String tmp = subFolder.trim().replace("\\\\", "/").replace("\\", "/");
        if (tmp.endsWith("/")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        this.subFolder = tmp;
        this.logger = logger;
        this.policy = policy;
        this.setting = setting;
        this.proxy = proxy;
        this.type = type;
        this.parsers.put('I', ConfigEntry.IntValue::parse);
        this.parsers.put('D', ConfigEntry.DoubleValue::parse);
        this.parsers.put('B', ConfigEntry.BoolValue::parse);
        this.parsers.put('S', ConfigEntry.StringValue::parse);
        this.parsers.put('A', ConfigEntry.ArrayValue::parse);
        this.parsers.put('E', ConfigEntry.TempValue::parseTemp);
        this.parsers.put('e', ConfigEntry.TempValue::parseTemp);
        this.parsers.put('p', ConfigEntry.TempValue::parseTemp);
        this.parsers.put('P', ConfigEntry.TempValue::parseTemp);
    }

    ConfigHandler setOwner(FileSystemWatcher owner) {
        this.owner = owner;
        if (owner != null) {
            owner.onConfigCreated(this);
        }
        return this;
    }

    public void addTempParser(char id) {
        this.addParser(id, ConfigEntry.TempValue::parseTemp);
    }

    public void addParser(char id, IConfigParser parser) {
        if (!(id >= 'A' && id <= 'Z' || id >= 'a' && id <= 'z')) {
            throw new IllegalArgumentException("Character must be [a-zA-Z]");
        }
        this.parsers.putIfAbsent(id, (Object)parser);
    }

    public IConfigProxy getProxy() {
        return this.proxy;
    }

    public ConfigType getConfigType() {
        return this.type;
    }

    public MultilinePolicy getMultilinePolicy() {
        return this.policy;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getSubFolder() {
        return this.subFolder;
    }

    public Path createConfigFile(Path baseFolder) {
        return (!this.subFolder.isEmpty() ? baseFolder.resolve(this.subFolder) : baseFolder).resolve(this.config.getName().concat(".cfg"));
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public Path getCfgDir() {
        return this.cfgDir;
    }

    public Path getConfigFile() {
        return this.configFile;
    }

    public String getConfigIdentifer() {
        return this.subFolder + "/" + this.config.getName();
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public List<ConfigError> getErrors() {
        return this.errors;
    }

    public void register() {
        if (this.owner != null) {
            this.owner.registerConfigHandler(this);
            this.registered = true;
            if (!this.proxy.isDynamicProxy() && this.setting.contains((Object)AutomationType.AUTO_LOAD)) {
                this.load();
            }
        }
    }

    public void createDefaultConfig() {
        Path baseFolder;
        Path file;
        if (!this.registered) {
            return;
        }
        if (this.proxy.isDynamicProxy() && this.setting.contains((Object)AutomationType.AUTO_LOAD) && Files.notExists(file = this.createConfigFile(baseFolder = this.proxy.getBasePaths(this.createConfigFile(Paths.get("", new String[0])))), new LinkOption[0])) {
            Helpers.ensureFolder(file.getParent());
            this.save(file);
            --this.wasSaving;
        }
    }

    public void load() {
        this.findConfigFile();
        if (this.owner != null) {
            if (this.setting.contains((Object)AutomationType.AUTO_SYNC)) {
                this.owner.registerSyncHandler(this);
            }
            if (this.setting.contains((Object)AutomationType.AUTO_RELOAD)) {
                this.owner.registerReloadHandler(this.configFile, this);
            }
        }
        if (this.loadInternally()) {
            this.save();
        }
        this.isLoaded = true;
    }

    public boolean reload() {
        if (!this.isLoaded) {
            return false;
        }
        if (this.wasSaving > 0) {
            --this.wasSaving;
            return false;
        }
        this.loadInternally();
        return true;
    }

    public void unload() {
        this.isLoaded = false;
        if (this.owner != null && this.setting.contains((Object)AutomationType.AUTO_RELOAD)) {
            this.owner.unregisterReloadHandler(this.configFile);
        }
    }

    private void findConfigFile() {
        Path baseFolder = this.proxy.getBasePaths(this.createConfigFile(Paths.get("", new String[0])));
        if (baseFolder == null) {
            throw new IllegalStateException("Proxy has no Folder");
        }
        this.configFile = this.createConfigFile(baseFolder);
        this.cfgDir = this.configFile.getParent();
        Helpers.ensureFolder(this.cfgDir);
    }

    public void addLoadedListener(Runnable listener) {
        this.loadedListeners.add(listener);
    }

    public void onSynced() {
        for (Runnable r : this.loadedListeners) {
            r.run();
        }
    }

    private int handleEntry(ConfigSection currentSection, List<String> lines, int index, String line, String[] comment, boolean logErrors) {
        if (currentSection == null) {
            this.logger.error("config entry not in section: {}", line);
            return 0;
        }
        String[] entryData = Helpers.trimArray(line.split("[:=]", 3));
        if (entryData.length != 3) {
            this.logger.error("invalid config entry: {}", line);
            return 0;
        }
        int extra = 0;
        if (entryData[2].startsWith("<<<")) {
            if (entryData[2].endsWith(">>>")) {
                entryData[2] = entryData[2].substring(3, entryData[2].length() - 3);
            } else {
                builder = new StringBuilder();
                extra += this.findString(entryData[2], lines, index, ">>>", builder);
                entryData[2] = builder.toString();
            }
        } else if (entryData[2].startsWith("<")) {
            if (entryData[2].endsWith(">")) {
                entryData[2] = entryData[2].substring(1, entryData[2].length() - 1);
            } else {
                builder = new StringBuilder();
                extra += this.findString(entryData[2], lines, index, ">", builder);
                entryData[2] = builder.toString();
            }
        }
        try {
            ConfigEntry<?> entry = currentSection.getEntry(entryData[1]);
            if (entry == null) {
                IConfigParser parser = (IConfigParser)this.parsers.get(line.charAt(0));
                if (parser == null) {
                    this.logger.warn("config entry is not registered and no parser found: {}", line);
                    return extra;
                }
                ParseResult<ConfigEntry<?>> result = parser.parse(entryData[1], entryData[2], comment);
                entry = result.getValue();
                currentSection.addParsed(entry);
                if (result.hasError() && logErrors) {
                    this.logger.warn("couldn't parse value: {}", result.getValue());
                    this.errors.add(new ConfigError(entry, result.getError()));
                }
                return extra;
            }
            entry.parseComment(comment);
            if (line.charAt(0) == entry.getPrefix()) {
                ParseResult<String> result = entry.deserializeValue(entryData[2]);
                if (result.hasError() && logErrors) {
                    this.logger.warn("couldn't parse value: {}", result.getValue());
                    this.logger.warn("Parsing Error: {}", result.getError().getMessage());
                    this.errors.add(new ConfigError(entry, result.getError()));
                }
            } else {
                this.logger.warn("config entry has wrong type: {}", line);
            }
        }
        catch (Throwable e) {
            this.logger.error("Crash during parsing. THIS SHOULD NEVER HAPPEN! {}", e);
        }
        return extra;
    }

    private int findString(String base, List<String> lines, int index, String ending, StringBuilder builder) {
        builder.append(base.substring(ending.length()));
        int stepsDone = 0;
        while (index + 1 < lines.size()) {
            String data;
            ++stepsDone;
            if ((data = lines.get(++index).trim()).endsWith(ending)) {
                builder.append(data, 0, data.length() - ending.length());
                break;
            }
            if (data.length() > 1 && data.charAt(1) == ':' && this.parsers.containsKey(data.charAt(0))) {
                --stepsDone;
                break;
            }
            if (data.isEmpty()) continue;
            builder.append(data);
        }
        return stepsDone;
    }

    private boolean loadInternally() {
        if (Files.notExists(this.configFile, new LinkOption[0])) {
            return true;
        }
        try {
            this.errors.clear();
            ConfigHandler.load(this, this.config, Files.readAllLines(this.configFile), true);
            for (Runnable r : this.loadedListeners) {
                r.run();
            }
            if (this.errors.size() > 0 && this.owner != null) {
                this.owner.onConfigErrored(this);
            }
            return true;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean load(ConfigHandler handler, Config output, List<String> linesToParse, boolean logErrors) {
        ConfigSection currentSection = null;
        ObjectArrayList comments = new ObjectArrayList();
        int m = linesToParse.size();
        block4: for (int i = 0; i < m; ++i) {
            String line = linesToParse.get(i).trim();
            if (line.length() == 0) continue;
            switch (line.charAt(0)) {
                case '[': {
                    currentSection = output.getSectionRecursive(line.substring(1, line.length() - 1).split("\\."));
                    currentSection.parseComment(comments.toArray(new String[comments.size()]));
                    comments.clear();
                    continue block4;
                }
                case '#': {
                    if (line.charAt(1) == '\u200b') continue block4;
                    comments.add(line.substring(1).trim());
                    continue block4;
                }
                default: {
                    i += handler.handleEntry(currentSection, linesToParse, i, line, comments.toArray(new String[comments.size()]), logErrors);
                    comments.clear();
                }
            }
        }
        return true;
    }

    public void save() {
        this.save(this.configFile);
        if (this.owner != null) {
            this.owner.onConfigChanged(this);
        }
        this.onSynced();
    }

    public void saveQuietly() {
        this.save(this.configFile);
    }

    private void save(Path file) {
        ++this.wasSaving;
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            writer.write(this.config.serialize(this.policy));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface IConfigParser {
        public ParseResult<? extends ConfigEntry<?>> parse(String var1, String var2, String[] var3);
    }

    public class ConfigError {
        ConfigEntry<?> entry;
        ParseExpection error;

        public ConfigError(ConfigEntry<?> entry, ParseExpection error) {
            this.entry = entry;
            this.error = error;
        }

        public ConfigEntry<?> getEntry() {
            return this.entry;
        }

        public ParseExpection getError() {
            return this.error;
        }
    }
}

