/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.textures;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import earth.terrarium.adastra.common.blockentities.flag.FlagColor;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class FlagImageTexture
extends SimpleTexture {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation DEFAULT_FLAG = new ResourceLocation("ad_astra", "textures/block/flag/warning_flag.png");
    private final FlagColor[] colors;
    private boolean loaded;

    public FlagImageTexture(byte[] data) {
        super(DEFAULT_FLAG);
        this.colors = FlagColor.fromBytes(data);
    }

    private void upload(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
    }

    public void m_6704_(ResourceManager manager) {
        Minecraft.m_91087_().execute(() -> {
            if (!this.loaded) {
                try {
                    super.m_6704_(manager);
                }
                catch (IOException var3x) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.f_118129_, (Object)var3x);
                }
                this.loaded = true;
            }
        });
        Minecraft.m_91087_().execute(() -> {
            NativeImage image = this.loadTexture(this.colors);
            if (image != null) {
                this.loaded = true;
                if (!RenderSystem.isOnRenderThread()) {
                    RenderSystem.recordRenderCall(() -> this.upload(image));
                } else {
                    this.upload(image);
                }
            }
        });
    }

    private NativeImage loadTexture(FlagColor[] colors) {
        try {
            NativeImage nativeImage = new NativeImage(22, 16, false);
            for (int x = 0; x < 22; ++x) {
                for (int y = 0; y < 16; ++y) {
                    FlagColor color = colors[x + y * 22];
                    if (color == FlagColor.NONE) {
                        nativeImage.m_84988_(x, y, 0);
                        continue;
                    }
                    nativeImage.m_84988_(x, y, color.color() | 0xFF000000);
                }
            }
            return nativeImage;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load texture: {}", (Object)this.f_118129_, (Object)e);
            return null;
        }
    }
}

