/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.adastra.client.ClientPlatformUtils;
import earth.terrarium.adastra.common.blockentities.machines.OxygenDistributorBlockEntity;
import earth.terrarium.adastra.common.blocks.base.SidedMachineBlock;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;

public class OxygenDistributorBlockEntityRenderer
implements BlockEntityRenderer<OxygenDistributorBlockEntity> {
    public static final ResourceLocation TOP = new ResourceLocation("ad_astra", "block/oxygen_distributor_top");

    public void render(OxygenDistributorBlockEntity entity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        AttachFace face = (AttachFace)entity.m_58900_().m_61143_(SidedMachineBlock.FACE);
        Direction direction = (Direction)entity.m_58900_().m_61143_((Property)SidedMachineBlock.FACING);
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            if (face == AttachFace.CEILING) {
                pose.m_252880_(0.0f, 1.0f, 1.0f);
                pose.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            } else if (face == AttachFace.FLOOR) {
                pose.m_252781_(Axis.f_252529_.m_252977_(0.0f));
            } else {
                if (direction == Direction.NORTH) {
                    pose.m_252880_(0.0f, 0.0f, 1.0f);
                } else if (direction == Direction.SOUTH) {
                    pose.m_252880_(1.0f, 0.0f, 0.0f);
                } else if (direction == Direction.WEST) {
                    pose.m_252880_(1.0f, 0.0f, 1.0f);
                }
                this.rotateBlock(direction, (PoseStack)pose);
                pose.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            }
            float yRot = Mth.m_14179_((float)partialTick, (float)entity.lastYRot(), (float)entity.yRot());
            OxygenDistributorBlockEntityRenderer.render(entity.m_58900_(), yRot, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    private static void render(BlockState state, float yRot, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BakedModel blockModel = ClientPlatformUtils.getModel(Minecraft.m_91087_().m_91304_(), TOP);
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85837_(0.5, 0.0, 0.5);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-yRot));
            poseStack.m_85837_(-0.5, 0.0, -0.5);
            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), state, blockModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
        }
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            }
        }
    }

    public static class ItemRenderer
    extends BlockEntityWithoutLevelRenderer {
        public ItemRenderer() {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
            BlockState state = ((Block)BuiltInRegistries.f_256975_.m_7745_(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()))).m_49966_();
            Minecraft minecraft = Minecraft.m_91087_();
            float yRot = (float)Util.m_137550_() / 5.0f % 360.0f;
            try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
                BakedModel model = minecraft.m_91289_().m_110910_(state);
                minecraft.m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), state, model, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
                OxygenDistributorBlockEntityRenderer.render(state, yRot, poseStack, buffer, packedLight, packedOverlay);
            }
        }
    }
}

