/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container.modular;

import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ModularSlot
extends SlotItemHandler {
    private boolean canPlace = true;
    private boolean checkContainer = true;
    private Supplier<Boolean> enabled = () -> true;
    private Predicate<ItemStack> validator = stack -> true;
    private Function<ItemStack, Integer> stackLimit = stack -> Integer.MAX_VALUE;
    private BiPredicate<Player, ItemStack> canRemove = (player, stack) -> true;
    private BiConsumer<ItemStack, ItemStack> onSet;

    public ModularSlot(Container container, int index) {
        this((IItemHandler)new InvWrapper(container), index, 0, 0);
    }

    public ModularSlot(IItemHandler itemHandler, int index) {
        this(itemHandler, index, 0, 0);
    }

    public ModularSlot(Container container, int index, int xPos, int yPos) {
        super((IItemHandler)new InvWrapper(container), index, xPos, yPos);
        this.onSet = (oldStack, newStack) -> {};
    }

    public ModularSlot(IItemHandler itemHandler, int index, int xPos, int yPos) {
        super(itemHandler, index, xPos, yPos);
        this.onSet = (oldStack, newStack) -> {};
    }

    public ModularSlot output() {
        this.canPlace = false;
        return this;
    }

    public ModularSlot noCheck() {
        this.checkContainer = false;
        return this;
    }

    public ModularSlot setValidator(Predicate<ItemStack> validator) {
        this.validator = validator;
        return this;
    }

    public ModularSlot onSet(BiConsumer<ItemStack, ItemStack> onSet) {
        this.onSet = onSet;
        return this;
    }

    public ModularSlot setStackLimit(Function<ItemStack, Integer> stackLimit) {
        this.stackLimit = stackLimit;
        return this;
    }

    public ModularSlot setCanRemove(BiPredicate<Player, ItemStack> canRemove) {
        this.canRemove = canRemove;
        return this;
    }

    public ModularSlot setEnabled(Supplier<Boolean> enabled) {
        this.enabled = enabled;
        return this;
    }

    public ModularSlot setEnabled(boolean enabled) {
        this.enabled = () -> enabled;
        return this;
    }

    public boolean m_5857_(ItemStack itemStack) {
        return this.canPlace && this.validator.test(itemStack) && (!this.checkContainer || this.getItemHandler().isItemValid(this.m_150661_(), itemStack));
    }

    public boolean m_8010_(Player player) {
        return this.canRemove.test(player, this.m_7993_());
    }

    public void m_5852_(ItemStack itemStack) {
        this.onSet.accept(this.m_7993_(), itemStack);
        super.m_5852_(itemStack);
    }

    public boolean m_6659_() {
        return this.enabled.get();
    }

    public int m_5866_(ItemStack itemStack) {
        return Math.min(super.m_5866_(itemStack), this.stackLimit.apply(itemStack));
    }
}

