/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.common.entity.projectile;

import cofh.archersparadox.init.registries.ModEffects;
import cofh.archersparadox.init.registries.ModEntities;
import cofh.archersparadox.init.registries.ModItems;
import cofh.lib.common.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class TrainingArrow
extends AbstractArrow {
    private static final float defaultDamage = 0.0f;
    private static final int DISTANCE_FACTOR = 4;
    private static final int MAX_DISTANCE = 10;
    private static final int DURATION = 200;
    private static final int MIN_DURATION = 40;
    private Vec3 origin;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new TrainingArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new TrainingArrow(world, posX, posY, posZ);
        }
    };

    public TrainingArrow(EntityType<? extends TrainingArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = 0.0;
    }

    public TrainingArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)ModEntities.TRAINING_ARROW.get(), shooter, worldIn);
        this.f_36698_ = 0.0;
        this.origin = shooter.m_20182_();
    }

    public TrainingArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.TRAINING_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = 0.0;
        this.origin = new Vec3(x, y, z);
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.TRAINING_ARROW_ITEM.get());
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        Entity entity;
        if (raytraceResultIn.m_6662_() == HitResult.Type.BLOCK && (entity = this.m_19749_()) instanceof Player) {
            Player shooter = (Player)entity;
            if (!Utils.isFakePlayer((Entity)this.m_19749_()) && shooter.m_21023_((MobEffect)ModEffects.TRAINING_STREAK.get())) {
                MobEffectInstance effect = shooter.m_21124_((MobEffect)ModEffects.TRAINING_STREAK.get());
                shooter.m_7285_(effect);
                shooter.m_6234_((MobEffect)ModEffects.TRAINING_STREAK.get());
                Vec3 originVec = this.origin == null ? shooter.m_20182_() : this.origin;
                double distance = originVec.m_82554_(this.m_20182_());
                int distanceBonus = (int)(4.0 * distance);
                shooter.m_7292_(new MobEffectInstance((MobEffect)ModEffects.TRAINING_MISS.get(), Math.max(40, 200 - distanceBonus), 0, false, false));
                shooter.f_19853_.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11983_, shooter.m_5720_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            }
        }
        super.m_6532_(raytraceResultIn);
    }

    protected void m_5790_(EntityHitResult raytraceResultIn) {
        Entity entity = raytraceResultIn.m_82443_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            Entity entity2 = this.m_19749_();
            if (entity2 instanceof Player) {
                Player shooter = (Player)entity2;
                if (!Utils.isFakePlayer((Entity)this.m_19749_()) && shooter != target && !shooter.m_21023_((MobEffect)ModEffects.TRAINING_MISS.get())) {
                    Vec3 originVec;
                    double distance;
                    int trainingCount = 0;
                    if (shooter.m_21023_((MobEffect)ModEffects.TRAINING_STREAK.get())) {
                        trainingCount = shooter.m_21124_((MobEffect)ModEffects.TRAINING_STREAK.get()).m_19564_() + 1;
                    }
                    if ((distance = (originVec = this.origin == null ? shooter.m_20182_() : this.origin).m_82554_(this.m_20182_())) >= (double)Math.min(10, trainingCount)) {
                        int distanceBonus = (int)(4.0 * distance);
                        shooter.m_7292_(new MobEffectInstance((MobEffect)ModEffects.TRAINING_STREAK.get(), 200 + distanceBonus, trainingCount, false, false));
                        shooter.m_5496_((SoundEvent)SoundEvents.f_12211_.get(), 1.0f, Math.min(0.6f + 0.05f * (float)trainingCount, 1.1f));
                        shooter.f_19853_.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), (SoundEvent)SoundEvents.f_12211_.get(), shooter.m_5720_(), 1.0f, Math.min(0.6f + 0.05f * (float)trainingCount, 1.1f));
                    }
                }
            }
        }
        if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
            this.m_5552_(this.m_7941_(), 0.1f);
        }
        this.m_146870_();
        this.m_5496_(SoundEvents.f_12333_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
    }

    public void m_20254_(int seconds) {
    }

    public void m_36735_(int knockbackStrengthIn) {
    }

    public void m_36767_(byte level) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

