/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.common.entity.projectile;

import cofh.archersparadox.init.registries.ModEntities;
import cofh.archersparadox.init.registries.ModItems;
import cofh.core.common.config.IBaseConfig;
import cofh.lib.common.item.ArrowItemCoFH;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class PrismarineArrow
extends AbstractArrow {
    public static float defaultDamage = 2.0f;
    public static int defaultKnockback = 0;
    public static byte defaultPierce = 0;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new PrismarineArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new PrismarineArrow(world, posX, posY, posZ);
        }
    };
    public static final IBaseConfig CONFIG = new IBaseConfig(){
        private Supplier<Double> cfgDamage;
        private Supplier<Integer> cfgKnockback;
        private Supplier<Integer> cfgPierce;

        public void apply(ForgeConfigSpec.Builder builder) {
            String name = "Prismarine Arrow";
            builder.push(name);
            this.cfgDamage = builder.comment("Adjust this to set the damage for the " + name + ". Vanilla Arrow value is 2.0.").defineInRange("Damage", (double)defaultDamage, 0.0, 16.0);
            this.cfgKnockback = builder.comment("Adjust this to set the inherent knockback strength of the " + name + ". Vanilla Arrow value is 0.").defineInRange("Knockback", defaultKnockback, 0, 16);
            this.cfgPierce = builder.comment("Adjust this to set the inherent pierce of the " + name + ". Vanilla Arrow value is 0.").defineInRange("Piercing", (int)defaultPierce, 0, 16);
            builder.pop();
        }

        public void refresh() {
            defaultDamage = this.cfgDamage.get().floatValue();
            defaultKnockback = this.cfgKnockback.get();
            defaultPierce = this.cfgPierce.get().byteValue();
        }
    };

    public PrismarineArrow(EntityType<PrismarineArrow> type, Level worldIn) {
        super(type, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
        this.m_36767_((byte)0);
    }

    public PrismarineArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)ModEntities.PRISMARINE_ARROW.get(), shooter, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
        this.m_36767_((byte)0);
    }

    public PrismarineArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.PRISMARINE_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = defaultDamage;
        this.m_36735_(0);
        this.m_36767_((byte)0);
    }

    public ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.PRISMARINE_ARROW_ITEM.get());
    }

    public void m_36735_(int knockbackStrengthIn) {
        super.m_36735_(defaultKnockback + knockbackStrengthIn);
    }

    public void m_36767_(byte level) {
        super.m_36767_((byte)(defaultPierce + level));
    }

    public float m_6882_() {
        return 0.99f;
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        BlockPos blockpos;
        BlockState blockstate;
        if (!this.f_150164_) {
            this.m_146852_(GameEvent.f_157778_, this.m_19749_());
            this.f_150164_ = true;
        }
        if (!this.f_37246_) {
            this.f_37246_ = this.m_37276_();
        }
        this.m_6075_();
        boolean flag = this.m_36797_();
        Vec3 vec3 = this.m_20184_();
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            double d0 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
        if (!((blockstate = this.f_19853_.m_8055_(blockpos = this.m_20183_())).m_60795_() || flag || (voxelshape = blockstate.m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_())) {
            Vec3 vec31 = this.m_20182_();
            for (AABB aabb : voxelshape.m_83299_()) {
                if (!aabb.m_82338_(blockpos).m_82390_(vec31)) continue;
                this.f_36703_ = true;
                break;
            }
        }
        if (this.f_36706_ > 0) {
            --this.f_36706_;
        }
        if (this.m_20070_() || blockstate.m_60713_(Blocks.f_152499_)) {
            this.m_20095_();
        }
        if (this.f_36703_ && !flag) {
            if (this.f_36696_ != blockstate && this.m_36798_()) {
                this.m_36799_();
            } else if (!this.f_19853_.f_46443_) {
                this.m_6901_();
            }
            ++this.f_36704_;
        } else {
            Vec3 vec33;
            this.f_36704_ = 0;
            Vec3 vec32 = this.m_20182_();
            BlockHitResult hitresult = this.f_19853_.m_45547_(new ClipContext(vec32, vec33 = vec32.m_82549_(vec3), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitresult.m_6662_() != HitResult.Type.MISS) {
                vec33 = hitresult.m_82450_();
            }
            while (!this.m_213877_()) {
                EntityHitResult entityhitresult = this.m_6351_(vec32, vec33);
                if (entityhitresult != null) {
                    hitresult = entityhitresult;
                }
                if (hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY) {
                    Player owner;
                    Entity entity = ((EntityHitResult)hitresult).m_82443_();
                    Entity entity1 = this.m_19749_();
                    if (entity instanceof Player && entity1 instanceof Player && !(owner = (Player)entity1).m_7099_((Player)entity)) {
                        hitresult = null;
                        entityhitresult = null;
                    }
                }
                if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                    this.m_6532_((HitResult)hitresult);
                    this.f_19812_ = true;
                }
                if (entityhitresult == null || this.m_36796_() <= 0) break;
                hitresult = null;
            }
            vec3 = this.m_20184_();
            double d5 = vec3.f_82479_;
            double d6 = vec3.f_82480_;
            double d1 = vec3.f_82481_;
            if (this.m_36792_()) {
                for (int i = 0; i < 4; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + d5 * (double)i / 4.0, this.m_20186_() + d6 * (double)i / 4.0, this.m_20189_() + d1 * (double)i / 4.0, -d5, -d6 + 0.2, -d1);
                }
            }
            double d7 = this.m_20185_() + d5;
            double d2 = this.m_20186_() + d6;
            double d3 = this.m_20189_() + d1;
            double d4 = vec3.m_165924_();
            if (flag) {
                this.m_146922_((float)(Mth.m_14136_((double)(-d5), (double)(-d1)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(PrismarineArrow.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(PrismarineArrow.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            float f = 0.99f;
            this.m_20256_(vec3.m_82490_((double)f));
            if (!this.m_20068_() && !flag) {
                Vec3 vec34 = this.m_20184_();
                this.m_20334_(vec34.f_82479_, vec34.f_82480_ - (this.m_20069_() ? 0.01 : 0.05), vec34.f_82481_);
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

