/*
 * Decompiled with CFR 0.152.
 */
package cofh.archersparadox.common.entity.projectile;

import cofh.archersparadox.init.registries.ModEntities;
import cofh.archersparadox.init.registries.ModItems;
import cofh.core.common.config.IBaseConfig;
import cofh.lib.common.item.ArrowItemCoFH;
import cofh.lib.util.Utils;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.network.NetworkHooks;

public class ExplosiveArrow
extends AbstractArrow {
    public static float defaultDamage = 0.5f;
    public static double explosionStrength = 1.9;
    public static boolean explosionsBreakBlocks = true;
    public static boolean explosionsCauseFire = true;
    public static boolean knockbackBoost = true;
    public static final ArrowItemCoFH.IArrowFactory<AbstractArrow> FACTORY = new ArrowItemCoFH.IArrowFactory<AbstractArrow>(){

        public AbstractArrow createArrow(Level world, LivingEntity living) {
            return new ExplosiveArrow(world, living);
        }

        public AbstractArrow createArrow(Level world, double posX, double posY, double posZ) {
            return new ExplosiveArrow(world, posX, posY, posZ);
        }
    };
    public static final IBaseConfig CONFIG = new IBaseConfig(){
        private Supplier<Double> cfgDamage;
        private Supplier<Double> cfgExplosiveStrength;
        private Supplier<Boolean> cfgBreakBlocks;
        private Supplier<Boolean> cfgCauseFire;
        private Supplier<Boolean> cfgKnockbackBoost;

        public void apply(ForgeConfigSpec.Builder builder) {
            String name = "Explosive Arrow";
            builder.push(name);
            this.cfgDamage = builder.comment("Adjust this to set the damage for the " + name + ". Vanilla Arrow value is 2.0.").defineInRange("Damage", (double)defaultDamage, 0.0, 16.0);
            this.cfgExplosiveStrength = builder.comment("Adjust this to set the explosion strength for the " + name + ".").defineInRange("Strength", explosionStrength, 0.5, 16.0);
            this.cfgBreakBlocks = builder.comment("If TRUE, explosions break blocks.").define("Break Blocks", explosionsBreakBlocks);
            this.cfgCauseFire = builder.comment("If TRUE, explosions cause fires if the arrow is on fire.").define("Cause Fires", explosionsCauseFire);
            this.cfgKnockbackBoost = builder.comment("If TRUE, bounces are modified by knockback bonuses, such as the Punch Enchantment.").define("Knockback Boost", knockbackBoost);
            builder.pop();
        }

        public void refresh() {
            defaultDamage = this.cfgDamage.get().floatValue();
            explosionStrength = this.cfgExplosiveStrength.get();
            explosionsBreakBlocks = this.cfgBreakBlocks.get();
            explosionsCauseFire = this.cfgCauseFire.get();
            knockbackBoost = this.cfgKnockbackBoost.get();
        }
    };

    public ExplosiveArrow(EntityType<? extends ExplosiveArrow> entityIn, Level worldIn) {
        super(entityIn, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public ExplosiveArrow(Level worldIn, LivingEntity shooter) {
        super((EntityType)ModEntities.EXPLOSIVE_ARROW.get(), shooter, worldIn);
        this.f_36698_ = defaultDamage;
    }

    public ExplosiveArrow(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.EXPLOSIVE_ARROW.get(), x, y, z, worldIn);
        this.f_36698_ = defaultDamage;
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ModItems.EXPLOSIVE_ARROW_ITEM.get());
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        super.m_6532_(raytraceResultIn);
        if (Utils.isServerWorld((Level)this.f_19853_)) {
            this.f_19853_.m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)(explosionStrength + (double)(knockbackBoost ? this.f_36699_ : 0)), explosionsCauseFire && this.m_6060_(), explosionsBreakBlocks ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult raytraceResultIn) {
        super.m_5790_(raytraceResultIn);
        Entity entity = raytraceResultIn.m_82443_();
        entity.f_19802_ = 0;
    }

    public void m_36762_(boolean critical) {
    }

    public void m_36767_(byte level) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

