/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.trait;

import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.EdgePart;
import codechicken.multipart.api.part.FacePart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.trait.extern.RedstoneTile;
import codechicken.multipart.util.PartMap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class TRedstoneTile
extends TileMultipart
implements RedstoneTile {
    public TRedstoneTile(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public int getDirectSignal(int side) {
        int max = 0;
        for (MultiPart part : this.getPartList()) {
            int l;
            if (!(part instanceof RedstonePart) || (l = ((RedstonePart)part).strongPowerLevel(side)) <= max) continue;
            max = l;
        }
        return max;
    }

    @Override
    public int getSignal(int side) {
        return this.weakPowerLevel(side, RedstoneInteractions.otherConnectionMask((LevelReader)this.m_58904_(), this.m_58899_(), side, true));
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return (this.getConnectionMask(side) & RedstoneInteractions.otherConnectionMask((LevelReader)this.m_58904_(), this.m_58899_(), side, true)) > 0;
    }

    @Override
    public int getConnectionMask(int side) {
        int mask = this.openConnections(side);
        int res = 0;
        for (MultiPart part : this.getPartList()) {
            res |= RedstoneInteractions.connectionMask(part, side) & mask;
        }
        return res;
    }

    @Override
    public int weakPowerLevel(int side, int mask) {
        int tMask = this.openConnections(side) & mask;
        int max = 0;
        for (MultiPart part : this.getPartList()) {
            int l;
            if ((RedstoneInteractions.connectionMask(part, side) & tMask) <= 0 || (l = ((RedstonePart)part).weakPowerLevel(side)) <= max) continue;
            max = l;
        }
        return max;
    }

    @Override
    public int openConnections(int side) {
        int m = 16;
        for (int i = 0; i < 4; ++i) {
            if (!this.redstoneConductionE(PartMap.edgeBetween(side, Rotation.rotateSide((int)(side & 6), (int)i)))) continue;
            m |= 1 << i;
        }
        return m &= this.redstoneConductionF(side);
    }

    private int redstoneConductionF(int i) {
        MultiPart part = this.getSlottedPart(i);
        if (part instanceof FacePart) {
            return ((FacePart)part).redstoneConductionMap();
        }
        return 31;
    }

    private boolean redstoneConductionE(int i) {
        MultiPart part = this.getSlottedPart(i);
        if (part instanceof EdgePart) {
            return ((EdgePart)part).conductsRedstone();
        }
        return true;
    }
}

