/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.util.ArrayUtils;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.PartConverter;
import codechicken.multipart.api.SimpleMultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.minecraft.ButtonPart;
import codechicken.multipart.minecraft.LeverPart;
import codechicken.multipart.minecraft.McStatePart;
import codechicken.multipart.minecraft.RedstoneTorchPart;
import codechicken.multipart.minecraft.SoulTorchPart;
import codechicken.multipart.minecraft.TorchPart;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class MinecraftMultipartModContent {
    private static final DeferredRegister<MultipartType<?>> MULTIPART_TYPES = DeferredRegister.create((ResourceLocation)MultipartType.MULTIPART_TYPES, (String)"minecraft");
    private static final DeferredRegister<PartConverter> PART_CONVERTERS = DeferredRegister.create((ResourceLocation)PartConverter.PART_CONVERTERS, (String)"minecraft");
    public static final RegistryObject<MultipartType<TorchPart>> TORCH_PART = MULTIPART_TYPES.register("torch", () -> new SimpleMultipartType<TorchPart>(e -> new TorchPart()));
    public static final RegistryObject<MultipartType<SoulTorchPart>> SOUL_TORCH_PART = MULTIPART_TYPES.register("soul_torch", () -> new SimpleMultipartType<SoulTorchPart>(e -> new SoulTorchPart()));
    public static final RegistryObject<MultipartType<RedstoneTorchPart>> REDSTONE_TORCH_PART = MULTIPART_TYPES.register("redstone_torch", () -> new SimpleMultipartType<RedstoneTorchPart>(e -> new RedstoneTorchPart()));
    public static final RegistryObject<MultipartType<LeverPart>> LEVER_PART = MULTIPART_TYPES.register("lever", () -> new SimpleMultipartType<LeverPart>(e -> new LeverPart()));
    public static final RegistryObject<MultipartType<ButtonPart.StoneButtonPart>> STONE_BUTTON_PART = MULTIPART_TYPES.register("stone_button", () -> new SimpleMultipartType<ButtonPart.StoneButtonPart>(e -> new ButtonPart.StoneButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.PolishedBlackstoneButtonPart>> POLISHED_BLACKSTONE_BUTTON_PART = MULTIPART_TYPES.register("polished_blackstone_button", () -> new SimpleMultipartType<ButtonPart.PolishedBlackstoneButtonPart>(e -> new ButtonPart.PolishedBlackstoneButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.OakButtonPart>> OAK_BUTTON_PART = MULTIPART_TYPES.register("oak_button", () -> new SimpleMultipartType<ButtonPart.OakButtonPart>(e -> new ButtonPart.OakButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.SpruceButtonPart>> SPRUCE_BUTTON_PART = MULTIPART_TYPES.register("spruce_button", () -> new SimpleMultipartType<ButtonPart.SpruceButtonPart>(e -> new ButtonPart.SpruceButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.BirchButtonPart>> BIRCH_BUTTON_PART = MULTIPART_TYPES.register("birch_button", () -> new SimpleMultipartType<ButtonPart.BirchButtonPart>(e -> new ButtonPart.BirchButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.JungleButtonPart>> JUNGLE_BUTTON_PART = MULTIPART_TYPES.register("jungle_button", () -> new SimpleMultipartType<ButtonPart.JungleButtonPart>(e -> new ButtonPart.JungleButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.AcaciaButtonPart>> ACACIA_BUTTON_PART = MULTIPART_TYPES.register("acacia_button", () -> new SimpleMultipartType<ButtonPart.AcaciaButtonPart>(e -> new ButtonPart.AcaciaButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.DarkOakButtonPart>> DARK_OAK_BUTTON_PART = MULTIPART_TYPES.register("dark_oak_button", () -> new SimpleMultipartType<ButtonPart.DarkOakButtonPart>(e -> new ButtonPart.DarkOakButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.CrimsonButtonPart>> CRIMSON_BUTTON_PART = MULTIPART_TYPES.register("crimson_button", () -> new SimpleMultipartType<ButtonPart.CrimsonButtonPart>(e -> new ButtonPart.CrimsonButtonPart()));
    public static final RegistryObject<MultipartType<ButtonPart.WarpedButtonPart>> WARPED_BUTTON_PART = MULTIPART_TYPES.register("warped_button", () -> new SimpleMultipartType<ButtonPart.WarpedButtonPart>(e -> new ButtonPart.WarpedButtonPart()));
    private static final RegistryObject<PartConverter> TORCH_CONVERTER = PART_CONVERTERS.register("torch", () -> new Converter<TorchPart>(TorchPart::new, TorchPart::new, Items.f_42000_, Blocks.f_50081_, Blocks.f_50082_));
    private static final RegistryObject<PartConverter> SOUL_TORCH_CONVERTER = PART_CONVERTERS.register("soul_torch", () -> new Converter<SoulTorchPart>(SoulTorchPart::new, SoulTorchPart::new, Items.f_42053_, Blocks.f_50139_, Blocks.f_50140_));
    private static final RegistryObject<PartConverter> REDSTONE_TORCH_CONVERTER = PART_CONVERTERS.register("redstone_torch", () -> new Converter<RedstoneTorchPart>(RedstoneTorchPart::new, RedstoneTorchPart::new, Items.f_41978_, Blocks.f_50174_, Blocks.f_50123_));
    private static final RegistryObject<PartConverter> LEVER_CONVERTER = PART_CONVERTERS.register("lever", () -> new Converter<LeverPart>(LeverPart::new, LeverPart::new, Items.f_41966_, Blocks.f_50164_));
    private static final RegistryObject<PartConverter> STONE_BUTTON_CONVERTER = PART_CONVERTERS.register("stone_button", () -> new Converter<ButtonPart.StoneButtonPart>(ButtonPart.StoneButtonPart::new, ButtonPart.StoneButtonPart::new, Items.f_42083_, Blocks.f_50124_));
    private static final RegistryObject<PartConverter> POLISHED_BLACKSTONE_BUTTON_CONVERTER = PART_CONVERTERS.register("polished_blackstone_button", () -> new Converter<ButtonPart.PolishedBlackstoneButtonPart>(ButtonPart.PolishedBlackstoneButtonPart::new, ButtonPart.PolishedBlackstoneButtonPart::new, Items.f_42145_, Blocks.f_50710_));
    private static final RegistryObject<PartConverter> OAK_BUTTON_CONVERTER = PART_CONVERTERS.register("oak_button", () -> new Converter<ButtonPart.OakButtonPart>(ButtonPart.OakButtonPart::new, ButtonPart.OakButtonPart::new, Items.f_42084_, Blocks.f_50251_));
    private static final RegistryObject<PartConverter> SPRUCE_BUTTON_CONVERTER = PART_CONVERTERS.register("spruce_button", () -> new Converter<ButtonPart.SpruceButtonPart>(ButtonPart.SpruceButtonPart::new, ButtonPart.SpruceButtonPart::new, Items.f_42085_, Blocks.f_50252_));
    private static final RegistryObject<PartConverter> BIRCH_BUTTON_CONVERTER = PART_CONVERTERS.register("birch_button", () -> new Converter<ButtonPart.BirchButtonPart>(ButtonPart.BirchButtonPart::new, ButtonPart.BirchButtonPart::new, Items.f_42086_, Blocks.f_50253_));
    private static final RegistryObject<PartConverter> JUNGLE_BUTTON_CONVERTER = PART_CONVERTERS.register("jungle_button", () -> new Converter<ButtonPart.JungleButtonPart>(ButtonPart.JungleButtonPart::new, ButtonPart.JungleButtonPart::new, Items.f_42087_, Blocks.f_50254_));
    private static final RegistryObject<PartConverter> ACACIA_BUTTON_CONVERTER = PART_CONVERTERS.register("acacia_button", () -> new Converter<ButtonPart.AcaciaButtonPart>(ButtonPart.AcaciaButtonPart::new, ButtonPart.AcaciaButtonPart::new, Items.f_42088_, Blocks.f_50308_));
    private static final RegistryObject<PartConverter> DARK_OAK_BUTTON_CONVERTER = PART_CONVERTERS.register("dark_oak_button", () -> new Converter<ButtonPart.DarkOakButtonPart>(ButtonPart.DarkOakButtonPart::new, ButtonPart.DarkOakButtonPart::new, Items.f_42089_, Blocks.f_50309_));
    private static final RegistryObject<PartConverter> CRIMSON_BUTTON_CONVERTER = PART_CONVERTERS.register("crimson_button", () -> new Converter<ButtonPart.CrimsonButtonPart>(ButtonPart.CrimsonButtonPart::new, ButtonPart.CrimsonButtonPart::new, Items.f_42090_, Blocks.f_50669_));
    private static final RegistryObject<PartConverter> WARPED_BUTTON_CONVERTER = PART_CONVERTERS.register("warped_button", () -> new Converter<ButtonPart.WarpedButtonPart>(ButtonPart.WarpedButtonPart::new, ButtonPart.WarpedButtonPart::new, Items.f_42144_, Blocks.f_50670_));

    public static void init(IEventBus modBus) {
        MULTIPART_TYPES.register(modBus);
        PART_CONVERTERS.register(modBus);
    }

    private static class Converter<T extends McStatePart>
    extends PartConverter {
        private final Supplier<T> factory;
        private final Function<BlockState, T> blockFactory;
        private final Item item;
        private final Block[] blocks;

        private Converter(Supplier<T> factory, Function<BlockState, T> blockFactory, Item item, Block ... blocks) {
            this.factory = factory;
            this.blockFactory = blockFactory;
            this.item = item;
            this.blocks = blocks;
        }

        @Override
        public PartConverter.ConversionResult<Collection<MultiPart>> convert(LevelAccessor world, BlockPos pos, BlockState state) {
            if (this.blocks.length == 0) {
                return PartConverter.emptyResultList();
            }
            if (ArrayUtils.contains((Object[])this.blocks, (Object)state.m_60734_())) {
                return PartConverter.ConversionResult.success(Collections.singleton((MultiPart)this.blockFactory.apply(state)));
            }
            return super.convert(world, pos, state);
        }

        @Override
        public PartConverter.ConversionResult<MultiPart> convert(MultipartPlaceContext context) {
            if (context.m_43722_().m_41720_() != this.item) {
                return Converter.emptyResult();
            }
            MultiPart result = ((McStatePart)this.factory.get()).setStateOnPlacement(context);
            if (result != null) {
                return PartConverter.ConversionResult.success(result);
            }
            return super.convert(context);
        }
    }
}

