/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin.scala;

import codechicken.mixin.scala.ByteCodecs;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;

public class ScalaSignature {
    public final int major;
    public final int minor;
    public final SigEntry[] table;

    public ScalaSignature(String sig) {
        this(ScalaSignature.parseBytes(sig));
    }

    private ScalaSignature(Bytes bytes) {
        Reader reader = bytes.reader();
        this.major = reader.readByte();
        this.minor = reader.readByte();
        this.table = new SigEntry[reader.readNat()];
        int i = 0;
        while (i < this.table.length) {
            int index = i++;
            int start = reader.pos;
            byte tpe = reader.readByte();
            int len = reader.readNat();
            this.table[index] = reader.advance(len, () -> new SigEntry(index, start, new Bytes(bytes.arr, reader.pos, len)));
        }
    }

    private static Bytes parseBytes(String str) {
        byte[] bytes = str.getBytes();
        int len = ByteCodecs.decode(bytes);
        return new Bytes(bytes, 0, len);
    }

    @Nullable
    public static ScalaSignature parse(ClassNode cNode) {
        if (cNode.visibleAnnotations == null) {
            return null;
        }
        return (ScalaSignature)FastStream.of((Iterable)cNode.visibleAnnotations).filter(e -> e.desc.equals("Lscala/reflect/ScalaSignature;")).map(e -> e.values.get(1).toString()).map(ScalaSignature::new).firstOrDefault();
    }

    public <T> List<T> collect(int id) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.table.length; ++i) {
            if (this.table[i].id() != id) continue;
            list.add(this.evalT(i));
        }
        return list;
    }

    @Nullable
    public ObjectSymbol findObject(String name) {
        return (ObjectSymbol)FastStream.of(this.collect(7)).filter(e -> e.full().equals(name)).first();
    }

    @Nullable
    public ClassSymbol findClass(String name) {
        return (ClassSymbol)FastStream.of(this.collect(6)).filter(e -> !e.isModule() && e.full().equals(name)).first();
    }

    public String evalS(int i) {
        SigEntry e = this.table[i];
        Bytes bc = e.bytes;
        Reader bcr = bc.reader();
        return switch (e.id()) {
            case 1, 2 -> bcr.readString(bc.len);
            case 3 -> "<no symbol>";
            case 9, 10 -> {
                Object s = this.evalS(bcr.readNat());
                if (bc.pos + bc.len > bcr.pos) {
                    s = this.evalS(bcr.readNat()) + "." + (String)s;
                }
                yield s;
            }
            default -> throw new RuntimeException("Switch falloff");
        };
    }

    public <T> T evalT(int i) {
        return (T)SneakyUtils.unsafeCast((Object)this.eval(i));
    }

    private <T> List<T> evalList(Reader reader) {
        ArrayList<T> list = new ArrayList<T>();
        while (reader.more()) {
            list.add(this.evalT(reader.readNat()));
        }
        return list;
    }

    public Object eval(int i) {
        SigEntry e = this.table[i];
        Reader bcr = e.bytes.reader();
        return switch (e.id()) {
            case 1, 2 -> this.evalS(i);
            case 3 -> new NoSymbol();
            case 6 -> new ClassSymbol(this, this.evalS(bcr.readNat()), (SymbolRef)this.evalT(bcr.readNat()), bcr.readNat(), bcr.readNat());
            case 7 -> new ObjectSymbol(this, this.evalS(bcr.readNat()), (SymbolRef)this.evalT(bcr.readNat()), bcr.readNat(), bcr.readNat());
            case 8 -> new MethodSymbol(this, this.evalS(bcr.readNat()), (SymbolRef)this.evalT(bcr.readNat()), bcr.readNat(), bcr.readNat());
            case 9, 10 -> new ExternalSymbol(this.evalS(i));
            case 11, 12 -> new NoType();
            case 13 -> new ThisType((SymbolRef)this.evalT(bcr.readNat()));
            case 14 -> new SingleType((TypeRef)this.evalT(bcr.readNat()), (SymbolRef)this.evalT(bcr.readNat()));
            case 16 -> new TypeRefType((TypeRef)this.evalT(bcr.readNat()), (SymbolRef)this.evalT(bcr.readNat()), this.evalList(bcr));
            case 19 -> new ClassType((SymbolRef)this.evalT(bcr.readNat()), this.evalList(bcr));
            case 20 -> new MethodType((TypeRef)this.evalT(bcr.readNat()), this.evalList(bcr));
            case 21, 48 -> new ParameterlessType((TypeRef)this.evalT(bcr.readNat()));
            case 25 -> new BooleanLiteral(bcr.readLong() != 0L);
            case 26 -> new ByteLiteral((byte)bcr.readLong());
            case 27 -> new ShortLiteral((short)bcr.readLong());
            case 28 -> new CharLiteral(Character.valueOf((char)bcr.readLong()));
            case 29 -> new IntLiteral((int)bcr.readLong());
            case 30 -> new LongLiteral(bcr.readLong());
            case 31 -> new FloatLiteral(Float.valueOf(Float.intBitsToFloat((int)bcr.readLong())));
            case 32 -> new DoubleLiteral(Double.longBitsToDouble(bcr.readLong()));
            case 33 -> new StringLiteral(this.evalS(bcr.readNat()));
            case 34 -> new NullLiteral();
            case 35 -> new TypeLiteral((TypeRef)this.evalT(bcr.readNat()));
            case 36 -> new EnumLiteral((ExternalSymbol)this.evalT(bcr.readNat()));
            case 40 -> new AnnotationInfo((SymbolRef)this.evalT(bcr.readNat()), (TypeRef)this.evalT(bcr.readNat()), ScalaSignature.arrayElements(this.evalList(bcr)));
            case 44 -> new ArrayLiteral(this.evalList(bcr));
            default -> e;
        };
    }

    private static Map<String, Literal> arrayElements(List<Object> list) {
        HashMap<String, Literal> elements = new HashMap<String, Literal>();
        for (int i = 0; i < list.size(); i += 2) {
            elements.put((String)list.get(i), (Literal)list.get(i + 1));
        }
        return elements;
    }

    private record Bytes(byte[] arr, int pos, int len) {
        public Reader reader() {
            return new Reader(this);
        }
    }

    private static final class Reader {
        private final Bytes bc;
        public int pos;

        private Reader(Bytes bc) {
            this.bc = bc;
            this.pos = bc.pos;
        }

        public boolean more() {
            return this.pos < this.bc.pos + this.bc.len;
        }

        public String readString(int len) {
            return this.advance(len, () -> new String(Arrays.copyOfRange(this.bc.arr, this.pos, this.pos + len)));
        }

        public byte readByte() {
            this.readCheck(1);
            return this.bc.arr[this.pos++];
        }

        public int readNat() {
            int r = 0;
            byte b = 0;
            do {
                b = this.readByte();
                r = r << 7 | b & 0x7F;
            } while ((b & 0x80) != 0);
            return r;
        }

        public long readLong() {
            long l = 0L;
            while (this.more()) {
                l <<= 8;
                l |= (long)(this.readByte() & 0xFF);
            }
            return l;
        }

        public <T> T advance(int len, Supplier<T> f) {
            this.readCheck(len);
            T t = f.get();
            this.pos += len;
            return t;
        }

        private void readCheck(int len) {
            if (this.pos + len > this.bc.pos + this.bc.len) {
                throw new IllegalArgumentException("Ran off the end of bytecode");
            }
        }
    }

    public record SigEntry(int index, int start, Bytes bytes) {
        public byte id() {
            return this.bytes.arr[this.start];
        }

        @Override
        public String toString() {
            return "SigEntry(" + this.index + ", " + this.id() + ", " + this.bytes.len + " bytes)";
        }
    }

    public record ObjectSymbol(ScalaSignature sig, String name, SymbolRef owner, int flags, int infoId) implements ClassSymbolRef
    {
        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public ClassType info() {
            return ((ClassSymbol)((TypeRefType)this.sig.evalT((int)this.infoId)).sym).info();
        }

        @Override
        public String toString() {
            return "ObjectSymbol(" + this.name + ", " + this.owner + ", 0x" + Integer.toHexString(this.flags) + ", " + this.infoId + ")";
        }
    }

    public record ClassSymbol(ScalaSignature sig, String name, SymbolRef owner, int flags, int infoId) implements ClassSymbolRef
    {
        @Override
        public String toString() {
            return "ClassSymbol(" + this.name + ", " + this.owner + ", 0x" + Integer.toHexString(this.flags) + ", " + this.infoId + ")";
        }
    }

    private record NoSymbol() implements SymbolRef
    {
        @Override
        public String full() {
            return "<no symbol>";
        }

        @Override
        public int flags() {
            return 0;
        }
    }

    public static interface SymbolRef
    extends Flags {
        public String full();

        public int flags();

        @Override
        default public boolean hasFlag(int flag) {
            return (this.flags() & flag) != 0;
        }
    }

    public record MethodSymbol(ScalaSignature sig, String name, SymbolRef owner, int flags, int infoId) implements SymbolRef
    {
        @Override
        public String full() {
            return this.owner.full() + "." + this.name;
        }

        public TMethodType info() {
            return (TMethodType)this.sig.evalT(this.infoId);
        }

        public String jDesc() {
            return this.info().jDesc();
        }

        @Override
        public String toString() {
            return "MethodSymbol(" + this.name + ", " + this.owner + ", 0x" + Integer.toHexString(this.flags) + ", " + this.infoId + ")";
        }
    }

    public record ExternalSymbol(String name) implements SymbolRef
    {
        @Override
        public String full() {
            return this.name;
        }

        @Override
        public int flags() {
            return 0;
        }
    }

    public record NoType() implements TypeRef
    {
        @Override
        public SymbolRef sym() {
            return null;
        }

        @Override
        public String name() {
            return "<no type>";
        }
    }

    public record ThisType(SymbolRef sym) implements TypeRef
    {
    }

    public record SingleType(TypeRef owner, SymbolRef sym) implements TypeRef
    {
        @Override
        public String jName() {
            return TypeRef.super.jName() + "$";
        }
    }

    public static interface TypeRef {
        public SymbolRef sym();

        default public String name() {
            return this.sym().full();
        }

        default public String jName() {
            String e;
            return switch (e = this.name().replace('.', '/')) {
                case "scala/AnyRef", "scala/Any" -> "java/lang/Object";
                case "scala/Predef/String" -> "java/lang/String";
                default -> e;
            };
        }

        default public String jDesc() {
            return switch (this.name()) {
                case "scala.Array" -> null;
                case "scala.Long" -> "J";
                case "scala.Int" -> "I";
                case "scala.Short" -> "S";
                case "scala.Byte" -> "B";
                case "scala.Double" -> "D";
                case "scala.Float" -> "F";
                case "scala.Boolean" -> "Z";
                case "scala.Unit" -> "V";
                default -> "L" + this.jName() + ";";
            };
        }
    }

    public record TypeRefType(TypeRef owner, SymbolRef sym, List<TypeRef> typArgs) implements TMethodType,
    TypeRef
    {
        @Override
        public List<MethodSymbol> params() {
            return List.of();
        }

        @Override
        public TypeRef returnType() {
            return this;
        }

        @Override
        public String jDesc() {
            if (this.name().equals("scala.Array")) {
                return "[" + this.typArgs.get(0).jDesc();
            }
            return TypeRef.super.jDesc();
        }
    }

    public record ClassType(SymbolRef owner, List<TypeRef> parents) {
        public TypeRef parent() {
            return this.parents.get(0);
        }

        public List<TypeRef> interfaces() {
            return this.parents.subList(1, this.parents.size());
        }
    }

    public record MethodType(TypeRef returnType, List<MethodSymbol> params) implements TMethodType
    {
    }

    public record ParameterlessType(TypeRef returnType) implements TMethodType
    {
        @Override
        public List<MethodSymbol> params() {
            return List.of();
        }
    }

    public static final class BooleanLiteral
    extends Record
    implements Literal {
        private final Boolean value;

        public BooleanLiteral(Boolean value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BooleanLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BooleanLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BooleanLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Boolean value() {
            return this.value;
        }
    }

    public static final class ByteLiteral
    extends Record
    implements Literal {
        private final Byte value;

        public ByteLiteral(Byte value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ByteLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ByteLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ByteLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Byte value() {
            return this.value;
        }
    }

    public static final class ShortLiteral
    extends Record
    implements Literal {
        private final Short value;

        public ShortLiteral(Short value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ShortLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ShortLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ShortLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Short value() {
            return this.value;
        }
    }

    public static final class CharLiteral
    extends Record
    implements Literal {
        private final Character value;

        public CharLiteral(Character value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CharLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CharLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CharLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Character value() {
            return this.value;
        }
    }

    public static final class IntLiteral
    extends Record
    implements Literal {
        private final Integer value;

        public IntLiteral(Integer value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IntLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IntLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IntLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Integer value() {
            return this.value;
        }
    }

    public static final class LongLiteral
    extends Record
    implements Literal {
        private final Long value;

        public LongLiteral(Long value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{LongLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{LongLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{LongLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Long value() {
            return this.value;
        }
    }

    public static final class FloatLiteral
    extends Record
    implements Literal {
        private final Float value;

        public FloatLiteral(Float value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FloatLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FloatLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FloatLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Float value() {
            return this.value;
        }
    }

    public static final class DoubleLiteral
    extends Record
    implements Literal {
        private final Double value;

        public DoubleLiteral(Double value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DoubleLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DoubleLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DoubleLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public Double value() {
            return this.value;
        }
    }

    public static final class StringLiteral
    extends Record
    implements Literal {
        private final String value;

        public StringLiteral(String value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StringLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StringLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StringLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public String value() {
            return this.value;
        }
    }

    public record NullLiteral() implements Literal
    {
        @Override
        public Object value() {
            return null;
        }
    }

    public static final class TypeLiteral
    extends Record
    implements Literal {
        private final TypeRef value;

        public TypeLiteral(TypeRef value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TypeLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TypeLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TypeLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public TypeRef value() {
            return this.value;
        }
    }

    public static final class EnumLiteral
    extends Record
    implements Literal {
        private final ExternalSymbol value;

        public EnumLiteral(ExternalSymbol value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{EnumLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{EnumLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{EnumLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public ExternalSymbol value() {
            return this.value;
        }
    }

    public record AnnotationInfo(SymbolRef owner, TypeRef annType, Map<String, Literal> values) {
        public <T> T getValue(String name) {
            return (T)SneakyUtils.unsafeCast((Object)this.values.get(name));
        }
    }

    public static final class ArrayLiteral
    extends Record
    implements Literal {
        private final List<?> value;

        public ArrayLiteral(List<?> value) {
            this.value = value;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ArrayLiteral.class, "value", "value"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ArrayLiteral.class, "value", "value"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ArrayLiteral.class, "value", "value"}, this, o);
        }

        @Override
        public List<?> value() {
            return this.value;
        }
    }

    public static interface Literal {
        public Object value();
    }

    public static interface TMethodType {
        default public String jDesc() {
            return "(" + FastStream.of(this.params()).map(e -> e.info().returnType().jDesc()).join("") + ")" + this.returnType().jDesc();
        }

        public TypeRef returnType();

        public List<MethodSymbol> params();
    }

    public static interface ClassSymbolRef
    extends SymbolRef {
        public ScalaSignature sig();

        public String name();

        public SymbolRef owner();

        @Override
        public int flags();

        public int infoId();

        @Override
        default public String full() {
            return this.owner().full() + "." + this.name();
        }

        default public boolean isObject() {
            return false;
        }

        default public ClassType info() {
            return (ClassType)this.sig().evalT(this.infoId());
        }

        default public String jParent() {
            return this.info().parent().jName();
        }

        default public List<String> jInterfaces() {
            return FastStream.of(this.info().interfaces()).map(TypeRef::jName).toList();
        }
    }

    public static interface Flags {
        public boolean hasFlag(int var1);

        default public boolean isPrivate() {
            return this.hasFlag(4);
        }

        default public boolean isProtected() {
            return this.hasFlag(8);
        }

        default public boolean isAbstract() {
            return this.hasFlag(128);
        }

        default public boolean isDeferred() {
            return this.hasFlag(256);
        }

        default public boolean isMethod() {
            return this.hasFlag(512);
        }

        default public boolean isModule() {
            return this.hasFlag(1024);
        }

        default public boolean isInterface() {
            return this.hasFlag(2048);
        }

        default public boolean isParam() {
            return this.hasFlag(8192);
        }

        default public boolean isStatic() {
            return this.hasFlag(0x800000);
        }

        default public boolean isTrait() {
            return this.hasFlag(0x2000000);
        }

        default public boolean isAccessor() {
            return this.hasFlag(0x8000000);
        }
    }
}

