/*
 * Decompiled with CFR 0.152.
 */
package codechicken.mixin;

import codechicken.mixin.api.MixinCompiler;
import codechicken.mixin.api.MixinFactory;
import codechicken.mixin.util.ClassInfo;
import codechicken.mixin.util.FactoryGenerator;
import codechicken.mixin.util.Utils;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.objectweb.asm.tree.ClassNode;

public class MixinFactoryImpl<B, F>
implements MixinFactory<B, F> {
    protected final AtomicInteger counter = new AtomicInteger();
    protected final Map<ImmutableSet<MixinFactory.TraitKey>, Class<? extends B>> classCache = new HashMap<ImmutableSet<MixinFactory.TraitKey>, Class<? extends B>>();
    protected final Map<ImmutableSet<MixinFactory.TraitKey>, F> factoryCache = new HashMap<ImmutableSet<MixinFactory.TraitKey>, F>();
    protected final Map<Class<?>, ImmutableSet<MixinFactory.TraitKey>> traitLookup = new HashMap();
    protected final Map<String, MixinFactory.TraitKey> registeredTraits = new HashMap<String, MixinFactory.TraitKey>();
    protected final MixinCompiler mixinCompiler;
    protected final Class<B> baseType;
    protected final Class<F> factoryClass;
    protected final String classSuffix;
    protected final FactoryGenerator factoryGenerator;

    public MixinFactoryImpl(MixinCompiler mixinCompiler, Class<B> baseType, Class<F> factoryClass, String classSuffix) {
        this.mixinCompiler = mixinCompiler;
        this.baseType = baseType;
        this.factoryClass = factoryClass;
        this.classSuffix = classSuffix;
        this.factoryGenerator = new FactoryGenerator(mixinCompiler);
        this.factoryGenerator.findMethod(factoryClass);
    }

    @Override
    public MixinCompiler getMixinCompiler() {
        return this.mixinCompiler;
    }

    @Override
    public synchronized MixinFactory.TraitKey registerTrait(Class<?> tClass) {
        String tName = Utils.asmName(tClass);
        MixinFactory.TraitKey trait = this.registeredTraits.get(tName);
        if (trait != null) {
            return trait;
        }
        ClassNode cNode = this.mixinCompiler.getClassNode(tName);
        if (cNode == null) {
            SneakyUtils.throwUnchecked((Throwable)new ClassNotFoundException(tName));
            return null;
        }
        return this.registerTrait(cNode);
    }

    @Override
    public synchronized MixinFactory.TraitKey registerTrait(ClassNode cNode) {
        ClassInfo baseInfo;
        String tName = cNode.name;
        MixinFactory.TraitKey key = this.registeredTraits.get(tName);
        if (key != null) {
            return key;
        }
        ClassInfo info = this.mixinCompiler.getClassInfo(cNode);
        String parentName = info.concreteParent().getName();
        if (!this.checkParent(parentName, baseInfo = this.mixinCompiler.getClassInfo(this.baseType))) {
            throw new IllegalArgumentException("Trait '" + tName + "' with resolved parent '" + parentName + "' does not extend base type '" + Utils.asmName(this.baseType) + "'");
        }
        this.mixinCompiler.registerTrait(cNode);
        key = new MixinFactory.TraitKey(tName);
        this.registeredTraits.put(tName, key);
        return key;
    }

    @Override
    public F construct(ImmutableSet<MixinFactory.TraitKey> traits) {
        return (F)this.factoryCache.computeIfAbsent(traits, this::compile);
    }

    @Override
    public ImmutableSet<MixinFactory.TraitKey> getTraitsForClass(Class<?> clazz) {
        return this.traitLookup.get(clazz);
    }

    private boolean checkParent(String parentName, ClassInfo info) {
        if (info.getName().equals(parentName)) {
            return true;
        }
        ClassInfo sClass = info.getSuperClass();
        if (sClass == null) {
            return false;
        }
        return this.checkParent(parentName, sClass);
    }

    private synchronized F compile(ImmutableSet<MixinFactory.TraitKey> traits) {
        Class clazz = this.classCache.computeIfAbsent(traits, e -> {
            ImmutableSet traitNames = FastStream.of((Iterable)traits).map(MixinFactory.TraitKey::tName).toImmutableSet();
            Class compiled = this.mixinCompiler.compileMixinClass(this.nextName(), Utils.asmName(this.baseType), (Set<String>)traitNames);
            this.traitLookup.put(compiled, traits);
            return compiled;
        });
        return this.factoryGenerator.generateFactory(clazz, this.factoryClass);
    }

    private String nextName() {
        return this.baseType.getSimpleName() + "_" + this.classSuffix + "$$" + this.counter.getAndIncrement();
    }
}

