/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.ClickableIngredient;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.FluidActionResult;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.utils.CycleFluidTransfer;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TagOrCycleFluidTransfer;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.EmiStackInteraction;
import dev.emi.emi.screen.EmiScreenManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import mezz.jei.api.fabric.ingredients.fluids.IJeiFluidIngredient;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="fluid_slot", group="widget.container")
public class TankWidget
extends Widget
implements IRecipeIngredientSlot,
IConfigurableWidget {
    public static final ResourceBorderTexture FLUID_SLOT_TEXTURE = new ResourceBorderTexture("ldlib:textures/gui/fluid_slot.png", 18, 18, 1, 1);
    @Nullable
    protected IFluidTransfer fluidTank;
    protected int tank;
    @Configurable(name="ldlib.gui.editor.name.showAmount")
    protected boolean showAmount;
    @Configurable(name="ldlib.gui.editor.name.allowClickFilled")
    protected boolean allowClickFilled;
    @Configurable(name="ldlib.gui.editor.name.allowClickDrained")
    protected boolean allowClickDrained;
    @Configurable(name="ldlib.gui.editor.name.drawHoverOverlay")
    public boolean drawHoverOverlay = true;
    @Configurable(name="ldlib.gui.editor.name.drawHoverTips")
    protected boolean drawHoverTips;
    @Configurable(name="ldlib.gui.editor.name.fillDirection")
    protected ProgressTexture.FillDirection fillDirection = ProgressTexture.FillDirection.ALWAYS_FULL;
    protected BiConsumer<TankWidget, List<Component>> onAddedTooltips;
    protected IngredientIO ingredientIO = IngredientIO.RENDER_ONLY;
    protected float XEIChance = 1.0f;
    protected FluidStack lastFluidInTank;
    protected long lastTankCapacity;
    protected Runnable changeListener;

    public TankWidget() {
        this(null, 0, 0, 18, 18, true, true);
    }

    @Override
    public void initTemplate() {
        this.setBackground((IGuiTexture)FLUID_SLOT_TEXTURE);
        this.setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP);
    }

    public TankWidget(IFluidStorage fluidTank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(fluidTank, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public TankWidget(@Nullable IFluidStorage fluidTank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        super(new Position(x, y), new Size(width, height));
        this.setBackground((IGuiTexture)FLUID_SLOT_TEXTURE);
        this.fluidTank = fluidTank;
        this.tank = 0;
        this.showAmount = true;
        this.allowClickFilled = allowClickContainerFilling;
        this.allowClickDrained = allowClickContainerEmptying;
        this.drawHoverTips = true;
    }

    public TankWidget(IFluidTransfer fluidTank, int tank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(fluidTank, tank, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public TankWidget(@Nullable IFluidTransfer fluidTank, int tank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        super(new Position(x, y), new Size(width, height));
        this.setBackground((IGuiTexture)FLUID_SLOT_TEXTURE);
        this.fluidTank = fluidTank;
        this.tank = tank;
        this.showAmount = true;
        this.allowClickFilled = allowClickContainerFilling;
        this.allowClickDrained = allowClickContainerEmptying;
        this.drawHoverTips = true;
    }

    public TankWidget setFluidTank(IFluidStorage fluidTank) {
        this.fluidTank = fluidTank;
        this.tank = 0;
        if (this.isClientSideWidget) {
            this.setClientSideWidget();
        }
        return this;
    }

    public TankWidget setFluidTank(IFluidTransfer fluidTank, int tank) {
        this.fluidTank = fluidTank;
        this.tank = tank;
        if (this.isClientSideWidget) {
            this.setClientSideWidget();
        }
        return this;
    }

    public FluidStack getFluid() {
        if (this.isClientSideWidget || this.isRemote()) {
            return this.lastFluidInTank == null ? FluidStack.empty() : this.lastFluidInTank;
        }
        return this.fluidTank != null ? this.fluidTank.getFluidInTank(this.tank) : FluidStack.empty();
    }

    public TankWidget setFluid(FluidStack fluidStack) {
        return this.setFluid(fluidStack, true);
    }

    public TankWidget setFluid(FluidStack fluidStack, boolean notify) {
        if (this.fluidTank != null) {
            this.fluidTank.setFluidInTank(this.tank, fluidStack);
            if (notify) {
                this.detectAndSendChanges();
            }
        }
        return this;
    }

    @Override
    public TankWidget setClientSideWidget() {
        super.setClientSideWidget();
        this.lastFluidInTank = this.fluidTank != null ? this.fluidTank.getFluidInTank(this.tank).copy() : null;
        this.lastTankCapacity = this.fluidTank != null ? this.fluidTank.getTankCapacity(this.tank) : 0L;
        return this;
    }

    public TankWidget setBackground(IGuiTexture background) {
        super.setBackground(background);
        return this;
    }

    @Override
    @Nullable
    public Object getXEIIngredientOverMouse(double mouseX, double mouseY) {
        if (this.self().isMouseOverElement(mouseX, mouseY)) {
            if (this.lastFluidInTank == null || this.lastFluidInTank.isEmpty()) {
                return null;
            }
            IFluidTransfer iFluidTransfer = this.fluidTank;
            if (iFluidTransfer instanceof CycleFluidTransfer) {
                CycleFluidTransfer cycleItemStackHandler = (CycleFluidTransfer)iFluidTransfer;
                return this.getXEIIngredientsFromCycleTransferClickable(cycleItemStackHandler, this.tank).get(0);
            }
            iFluidTransfer = this.fluidTank;
            if (iFluidTransfer instanceof TagOrCycleFluidTransfer) {
                TagOrCycleFluidTransfer transfer = (TagOrCycleFluidTransfer)iFluidTransfer;
                return this.getXEIIngredientsFromTagOrCycleTransferClickable(transfer, this.tank).get(0);
            }
            if (LDLib.isJeiLoaded()) {
                return JEICallWrapper.getPlatformFluidTypeForJEIClickable(this.lastFluidInTank, this.getPosition(), this.getSize());
            }
            if (LDLib.isReiLoaded()) {
                return EntryStacks.of((dev.architectury.fluid.FluidStack)dev.architectury.fluid.FluidStack.create((Fluid)this.lastFluidInTank.getFluid(), (long)this.lastFluidInTank.getAmount(), (CompoundTag)this.lastFluidInTank.getTag()));
            }
            if (LDLib.isEmiLoaded()) {
                return EMICallWrapper.getEmiIngredient(this.lastFluidInTank, this.getXEIChance());
            }
        }
        return null;
    }

    @Override
    public List<Object> getXEIIngredients() {
        if (this.lastFluidInTank == null || this.lastFluidInTank.isEmpty()) {
            return Collections.emptyList();
        }
        IFluidTransfer iFluidTransfer = this.fluidTank;
        if (iFluidTransfer instanceof CycleFluidTransfer) {
            CycleFluidTransfer cycleItemStackHandler = (CycleFluidTransfer)iFluidTransfer;
            return this.getXEIIngredientsFromCycleTransferClickable(cycleItemStackHandler, this.tank);
        }
        iFluidTransfer = this.fluidTank;
        if (iFluidTransfer instanceof TagOrCycleFluidTransfer) {
            TagOrCycleFluidTransfer transfer = (TagOrCycleFluidTransfer)iFluidTransfer;
            return this.getXEIIngredientsFromTagOrCycleTransferClickable(transfer, this.tank);
        }
        if (LDLib.isJeiLoaded()) {
            return List.of(JEICallWrapper.getPlatformFluidTypeForJEIClickable(FluidStack.create(this.lastFluidInTank.getFluid(), this.lastFluidInTank.getAmount()), this.getPosition(), this.getSize()));
        }
        if (LDLib.isReiLoaded()) {
            return List.of(EntryStacks.of((dev.architectury.fluid.FluidStack)dev.architectury.fluid.FluidStack.create((Fluid)this.lastFluidInTank.getFluid(), (long)this.lastFluidInTank.getAmount(), (CompoundTag)this.lastFluidInTank.getTag())));
        }
        if (LDLib.isEmiLoaded()) {
            return List.of(EMICallWrapper.getEmiIngredient(this.lastFluidInTank, this.XEIChance));
        }
        return List.of(FluidHelper.toRealFluidStack(this.lastFluidInTank));
    }

    @Override
    public Object getXEICurrentIngredient() {
        if (this.lastFluidInTank == null || this.lastFluidInTank.isEmpty()) {
            return null;
        }
        if (LDLib.isJeiLoaded()) {
            return JEICallWrapper.getPlatformFluidTypeForJEIClickable(FluidStack.create(this.lastFluidInTank.getFluid(), this.lastFluidInTank.getAmount()), this.getPosition(), this.getSize());
        }
        if (LDLib.isEmiLoaded()) {
            return EMICallWrapper.getEmiIngredient(this.lastFluidInTank, this.XEIChance);
        }
        return null;
    }

    private List<Object> getXEIIngredientsFromCycleTransfer(CycleFluidTransfer transfer, int index) {
        Stream<FluidStack> stream = transfer.getStackList(index).stream();
        if (LDLib.isJeiLoaded()) {
            return stream.filter(fluid -> !fluid.isEmpty()).map(JEICallWrapper::getPlatformFluidTypeForJEI).toList();
        }
        if (LDLib.isReiLoaded()) {
            return REICallWrapper.getReiIngredients(stream);
        }
        if (LDLib.isEmiLoaded()) {
            return EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsFromCycleTransferClickable(CycleFluidTransfer transfer, int index) {
        Stream<FluidStack> stream = transfer.getStackList(index).stream();
        if (LDLib.isJeiLoaded()) {
            return stream.filter(fluid -> !fluid.isEmpty()).map(fluid -> JEICallWrapper.getPlatformFluidTypeForJEIClickable(fluid, this.getPosition(), this.getSize())).toList();
        }
        if (LDLib.isReiLoaded()) {
            return REICallWrapper.getReiIngredients(stream);
        }
        if (LDLib.isEmiLoaded()) {
            return EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
        }
        return Collections.emptyList();
    }

    private List<Object> getXEIIngredientsFromTagOrCycleTransfer(TagOrCycleFluidTransfer transfer, int index) {
        Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>> either = transfer.getStacks().get(index);
        var ref = new Object(){
            List<Object> returnValue = Collections.emptyList();
        };
        either.ifLeft(list -> {
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = list.stream().flatMap(pair -> BuiltInRegistries.f_257020_.m_203431_((TagKey)pair.getFirst()).stream().flatMap(HolderSet.ListBacked::m_203614_).map(fluid -> JEICallWrapper.getPlatformFluidTypeForJEI(FluidStack.create((Fluid)fluid.m_203334_(), (long)((Long)pair.getSecond()))))).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(list);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(list, this.getXEIChance());
            }
        }).ifRight(fluids -> {
            Stream<FluidStack> stream = fluids.stream();
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = stream.filter(fluid -> !fluid.isEmpty()).map(JEICallWrapper::getPlatformFluidTypeForJEI).toList();
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(stream);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
            }
        });
        return ref.returnValue;
    }

    private List<Object> getXEIIngredientsFromTagOrCycleTransferClickable(TagOrCycleFluidTransfer transfer, int index) {
        Either<List<Pair<TagKey<Fluid>, Long>>, List<FluidStack>> either = transfer.getStacks().get(index);
        var ref = new Object(){
            List<Object> returnValue = Collections.emptyList();
        };
        either.ifLeft(list -> {
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = list.stream().flatMap(pair -> BuiltInRegistries.f_257020_.m_203431_((TagKey)pair.getFirst()).stream().flatMap(HolderSet.ListBacked::m_203614_).map(fluid -> JEICallWrapper.getPlatformFluidTypeForJEIClickable(FluidStack.create((Fluid)fluid.m_203334_(), (long)((Long)pair.getSecond())), this.getPosition(), this.getSize()))).collect(Collectors.toList());
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(list);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(list, this.getXEIChance());
            }
        }).ifRight(fluids -> {
            Stream<FluidStack> stream = fluids.stream();
            if (LDLib.isJeiLoaded()) {
                ref.returnValue = stream.filter(fluid -> !fluid.isEmpty()).map(fluid -> JEICallWrapper.getPlatformFluidTypeForJEIClickable(fluid, this.getPosition(), this.getSize())).toList();
            } else if (LDLib.isReiLoaded()) {
                ref.returnValue = REICallWrapper.getReiIngredients(stream);
            } else if (LDLib.isEmiLoaded()) {
                ref.returnValue = EMICallWrapper.getEmiIngredients(stream, this.getXEIChance());
            }
        });
        return ref.returnValue;
    }

    @Override
    public List<Component> getTooltipTexts() {
        List<Component> tooltips = this.getAdditionalToolTips(new ArrayList<Component>());
        tooltips.addAll(this.tooltipTexts);
        return tooltips;
    }

    public List<Component> getAdditionalToolTips(List<Component> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    @Override
    public List<Component> getFullTooltipTexts() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        FluidStack fluidStack = this.lastFluidInTank;
        if (fluidStack != null && !fluidStack.isEmpty()) {
            tooltips.add(FluidHelper.getDisplayName(fluidStack));
            tooltips.add((Component)Component.m_237110_((String)"ldlib.fluid.amount", (Object[])new Object[]{fluidStack.getAmount(), this.lastTankCapacity}).m_130946_(" " + FluidHelper.getUnit()));
            if (!Platform.isForge()) {
                tooltips.add((Component)Component.m_237113_((String)"\u00a76mB:\u00a7r %d/%d".formatted(fluidStack.getAmount() * 1000L / FluidHelper.getBucket(), this.lastTankCapacity * 1000L / FluidHelper.getBucket())).m_130946_(" mB"));
            }
            tooltips.add((Component)Component.m_237110_((String)"ldlib.fluid.temperature", (Object[])new Object[]{FluidHelper.getTemperature(fluidStack)}));
            tooltips.add((Component)Component.m_237115_((String)(FluidHelper.isLighterThanAir(fluidStack) ? "ldlib.fluid.state_gas" : "ldlib.fluid.state_liquid")));
        } else {
            tooltips.add((Component)Component.m_237115_((String)"ldlib.fluid.empty"));
            tooltips.add((Component)Component.m_237110_((String)"ldlib.fluid.amount", (Object[])new Object[]{0, this.lastTankCapacity}).m_130946_(" " + FluidHelper.getUnit()));
            if (!Platform.isForge()) {
                tooltips.add((Component)Component.m_237113_((String)"\u00a76mB:\u00a7r %d/%d".formatted(0, this.lastTankCapacity * 1000L / FluidHelper.getBucket())).m_130946_(" mB"));
            }
        }
        tooltips.addAll(this.getTooltipTexts());
        return tooltips;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.isClientSideWidget && this.fluidTank != null) {
            FluidStack fluidStack = this.fluidTank.getFluidInTank(this.tank);
            long capacity = this.fluidTank.getTankCapacity(this.tank);
            if (capacity != this.lastTankCapacity) {
                this.lastTankCapacity = capacity;
            }
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
            } else if (fluidStack.getAmount() != this.lastFluidInTank.getAmount()) {
                this.lastFluidInTank.setAmount(fluidStack.getAmount());
            }
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        FluidStack renderedFluid = this.lastFluidInTank;
        if (renderedFluid != null) {
            RenderSystem.disableBlend();
            if (!renderedFluid.isEmpty()) {
                double progress = (double)renderedFluid.getAmount() * 1.0 / (double)Math.max(Math.max(renderedFluid.getAmount(), this.lastTankCapacity), 1L);
                float drawnU = (float)this.fillDirection.getDrawnU(progress);
                float drawnV = (float)this.fillDirection.getDrawnV(progress);
                float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
                float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
                int width = size.width - 2;
                int height = size.height - 2;
                int x = pos.x + 1;
                int y = pos.y + 1;
                DrawerHelper.drawFluidForGui(graphics, renderedFluid, (float)x + drawnU * (float)width, (float)y + drawnV * (float)height, (float)width * drawnWidth, (float)height * drawnHeight);
            }
            if (this.showAmount && !renderedFluid.isEmpty()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets(renderedFluid.getAmount(), 3) + "B";
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                graphics.m_280056_(fontRenderer, s, (int)(((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 21.0f), (int)(((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
                graphics.m_280168_().m_85849_();
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect(graphics, this.getPosition().x + 1, this.getPosition().y + 1, this.getSize().width - 2, this.getSize().height - 2, -2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            if (this.gui != null) {
                this.gui.getModularUIGui().setHoverTooltip(this.getFullTooltipTexts(), ItemStack.f_41583_, null, null);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void detectAndSendChanges() {
        if (this.fluidTank != null) {
            FluidStack fluidStack = this.fluidTank.getFluidInTank(this.tank);
            long capacity = this.fluidTank.getTankCapacity(this.tank);
            if (capacity != this.lastTankCapacity) {
                this.lastTankCapacity = capacity;
                this.writeUpdateInfo(0, buffer -> buffer.m_130103_(this.lastTankCapacity));
            }
            if (!fluidStack.isFluidEqual(this.lastFluidInTank)) {
                this.lastFluidInTank = fluidStack.copy();
                CompoundTag fluidStackTag = fluidStack.saveToTag(new CompoundTag());
                this.writeUpdateInfo(2, buffer -> buffer.m_130079_(fluidStackTag));
            } else if (fluidStack.getAmount() != this.lastFluidInTank.getAmount()) {
                this.lastFluidInTank.setAmount(fluidStack.getAmount());
                this.writeUpdateInfo(3, buffer -> buffer.m_130103_(this.lastFluidInTank.getAmount()));
            } else {
                super.detectAndSendChanges();
                return;
            }
            if (this.changeListener != null) {
                this.changeListener.run();
            }
        }
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.fluidTank != null);
        if (this.fluidTank != null) {
            this.lastTankCapacity = this.fluidTank.getTankCapacity(this.tank);
            buffer.m_130103_(this.lastTankCapacity);
            FluidStack fluidStack = this.fluidTank.getFluidInTank(this.tank);
            this.lastFluidInTank = fluidStack.copy();
            buffer.m_130079_(fluidStack.saveToTag(new CompoundTag()));
        }
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.lastTankCapacity = buffer.m_130258_();
            this.readUpdateInfo(2, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 0) {
            this.lastTankCapacity = buffer.m_130258_();
        } else if (id == 1) {
            this.lastFluidInTank = null;
        } else if (id == 2) {
            this.lastFluidInTank = FluidStack.loadFromTag(buffer.m_130260_());
        } else if (id == 3 && this.lastFluidInTank != null) {
            this.lastFluidInTank.setAmount(buffer.m_130258_());
        } else if (id == 4) {
            ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
            int newStackSize = buffer.m_130242_();
            currentStack.m_41764_(newStackSize);
            this.gui.getModularUIContainer().m_142503_(currentStack);
        } else {
            super.readUpdateInfo(id, buffer);
            return;
        }
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        boolean isShiftKeyDown;
        int clickResult;
        super.handleClientAction(id, buffer);
        if (id == 1 && (clickResult = this.tryClickContainer(isShiftKeyDown = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(4, buf -> buf.m_130130_(clickResult));
        }
    }

    private int tryClickContainer(boolean isShiftKeyDown) {
        ItemStack remainingStack;
        FluidActionResult result;
        int i;
        if (this.fluidTank == null) {
            return -1;
        }
        Player player = this.gui.entityPlayer;
        ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
        IFluidTransfer handler = FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer());
        if (handler == null) {
            return -1;
        }
        int maxAttempts = isShiftKeyDown ? currentStack.m_41613_() : 1;
        FluidStack initialFluid = this.fluidTank.getFluidInTank(this.tank);
        if (this.allowClickFilled && initialFluid.getAmount() > 0L) {
            boolean performedFill = false;
            for (i = 0; i < maxAttempts && (result = FluidTransferHelper.tryFillContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, false)).isSuccess(); ++i) {
                remainingStack = FluidTransferHelper.tryFillContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, true).getResult();
                currentStack.m_41774_(1);
                performedFill = true;
                if (remainingStack.m_41619_() || player.m_36356_(remainingStack)) continue;
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)player.m_20097_(), (ItemStack)remainingStack);
                break;
            }
            if (performedFill) {
                SoundEvent soundevent = FluidHelper.getFillSound(initialFluid);
                if (soundevent != null) {
                    player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().m_142503_(currentStack);
                return currentStack.m_41613_();
            }
        }
        if (this.allowClickDrained) {
            boolean performedEmptying = false;
            for (i = 0; i < maxAttempts && (result = FluidTransferHelper.tryEmptyContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, false)).isSuccess(); ++i) {
                remainingStack = FluidTransferHelper.tryEmptyContainer(currentStack, this.fluidTank, Integer.MAX_VALUE, null, true).getResult();
                currentStack.m_41774_(1);
                performedEmptying = true;
                if (remainingStack.m_41619_() || player.m_150109_().m_36054_(remainingStack)) continue;
                Block.m_49840_((Level)player.m_9236_(), (BlockPos)player.m_20097_(), (ItemStack)remainingStack);
                break;
            }
            FluidStack filledFluid = this.fluidTank.getFluidInTank(this.tank);
            if (performedEmptying) {
                SoundEvent soundevent = FluidHelper.getEmptySound(filledFluid);
                if (soundevent != null) {
                    player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().m_142503_(currentStack);
                return currentStack.m_41613_();
            }
        }
        return -1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if ((this.allowClickDrained || this.allowClickFilled) && button == 0 && FluidTransferHelper.getFluidTransfer(this.gui.entityPlayer, this.gui.getModularUIContainer()) != null) {
                boolean isShiftKeyDown = TankWidget.isShiftDown();
                this.writeClientAction(1, writer -> writer.writeBoolean(isShiftKeyDown));
                TankWidget.playButtonClickSound();
                return true;
            }
            if (LDLib.isEmiLoaded() && EMICallWrapper.mouseClick(this.getXEICurrentIngredient(), button)) {
                return true;
            }
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        double mouseY;
        Window window = Minecraft.m_91087_().m_91268_();
        double mouseX = Minecraft.m_91087_().f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
        if (this.isMouseOverElement(mouseX, mouseY = Minecraft.m_91087_().f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_()) && LDLib.isEmiLoaded() && EMICallWrapper.keyPressed(this.getXEICurrentIngredient(), keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        FluidStorage handler = new FluidStorage(5000L);
        handler.fill(FluidStack.create((Fluid)Fluids.f_76193_, 3000L), false);
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", new TankWidget(){

            @Override
            public void updateScreen() {
                super.updateScreen();
                this.setHoverTooltips(TankWidget.this.tooltipTexts);
                this.backgroundTexture = TankWidget.this.backgroundTexture;
                this.hoverTexture = TankWidget.this.hoverTexture;
                this.showAmount = TankWidget.this.showAmount;
                this.drawHoverTips = TankWidget.this.drawHoverTips;
                this.fillDirection = TankWidget.this.fillDirection;
                this.overlay = TankWidget.this.overlay;
            }
        }.setAllowClickDrained(false).setAllowClickFilled(false).setFluidTank(handler)));
        IConfigurableWidget.super.buildConfigurator(father);
    }

    @Nullable
    public IFluidTransfer getFluidTank() {
        return this.fluidTank;
    }

    public int getTank() {
        return this.tank;
    }

    public TankWidget setShowAmount(boolean showAmount) {
        this.showAmount = showAmount;
        return this;
    }

    public TankWidget setAllowClickFilled(boolean allowClickFilled) {
        this.allowClickFilled = allowClickFilled;
        return this;
    }

    public TankWidget setAllowClickDrained(boolean allowClickDrained) {
        this.allowClickDrained = allowClickDrained;
        return this;
    }

    public TankWidget setDrawHoverOverlay(boolean drawHoverOverlay) {
        this.drawHoverOverlay = drawHoverOverlay;
        return this;
    }

    public TankWidget setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    public TankWidget setFillDirection(ProgressTexture.FillDirection fillDirection) {
        this.fillDirection = fillDirection;
        return this;
    }

    public TankWidget setOnAddedTooltips(BiConsumer<TankWidget, List<Component>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public TankWidget setIngredientIO(IngredientIO ingredientIO) {
        this.ingredientIO = ingredientIO;
        return this;
    }

    @Override
    public IngredientIO getIngredientIO() {
        return this.ingredientIO;
    }

    public TankWidget setXEIChance(float XEIChance) {
        this.XEIChance = XEIChance;
        return this;
    }

    @Override
    public float getXEIChance() {
        return this.XEIChance;
    }

    public FluidStack getLastFluidInTank() {
        return this.lastFluidInTank;
    }

    public long getLastTankCapacity() {
        return this.lastTankCapacity;
    }

    public TankWidget setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    public static final class JEICallWrapper {
        public static Object getPlatformFluidTypeForJEI(FluidStack fluidStack) {
            return JEICallWrapper._getPlatformFluidTypeForJEI(JEIPlugin.jeiHelpers.getPlatformFluidHelper(), fluidStack);
        }

        private static <T> Object _getPlatformFluidTypeForJEI(IPlatformFluidHelper<T> helper, FluidStack fluidStack) {
            return helper.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
        }

        public static Object getPlatformFluidTypeForJEIClickable(FluidStack fluidStack, Position pos, Size size) {
            return JEICallWrapper._getPlatformFluidTypeForJEIClickable(JEIPlugin.jeiHelpers.getPlatformFluidHelper(), fluidStack, pos, size);
        }

        private static <T> Object _getPlatformFluidTypeForJEIClickable(IPlatformFluidHelper<T> helper, FluidStack fluidStack, Position pos, Size size) {
            Object ingredient = helper.create(fluidStack.getFluid(), fluidStack.getAmount(), fluidStack.getTag());
            return JEIPlugin.jeiHelpers.getIngredientManager().createTypedIngredient(ingredient).map(typedIngredient -> new ClickableIngredient(typedIngredient, pos.x, pos.y, size.width, size.height)).orElse(null);
        }

        @Nullable
        private static FluidStack getFabricPlatformFluidTypeForIngredient(Object ingredient) {
            if (ingredient instanceof IJeiFluidIngredient) {
                IJeiFluidIngredient jeiRenderedIngredient = (IJeiFluidIngredient)ingredient;
                FluidStack fluid = FluidStack.create(jeiRenderedIngredient.getFluid(), jeiRenderedIngredient.getAmount());
                jeiRenderedIngredient.getTag().ifPresent(fluid::setTag);
            }
            return null;
        }

        private static FluidStack getForgePlatformFluidTypeForIngredient(Object ingredient) {
            return FluidHelper.fromRealFluidStack(ingredient);
        }
    }

    public static final class EMICallWrapper {
        public static List<Object> getEmiIngredients(Stream<FluidStack> stream, float xeiChance) {
            return List.of(EmiIngredient.of(stream.map(fluidStack -> EmiStack.of((Fluid)fluidStack.getFluid(), (CompoundTag)fluidStack.getTag(), (long)fluidStack.getAmount())).toList()).setChance(xeiChance));
        }

        public static List<Object> getEmiIngredients(List<Pair<TagKey<Fluid>, Long>> list, float xeiChance) {
            return list.stream().map(pair -> EmiIngredient.of((TagKey)((TagKey)pair.getFirst())).setAmount(((Long)pair.getSecond()).longValue()).setChance(xeiChance)).collect(Collectors.toList());
        }

        public static Object getEmiIngredient(FluidStack fluidStack, float xeiChance) {
            return EmiStack.of((Fluid)fluidStack.getFluid(), (CompoundTag)fluidStack.getTag(), (long)fluidStack.getAmount()).setChance(xeiChance);
        }

        public static boolean mouseClick(Object ingredient, int button) {
            if (ingredient instanceof EmiStack) {
                EmiStack emiStack = (EmiStack)ingredient;
                return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)emiStack), bind -> bind.matchesMouse(button));
            }
            return false;
        }

        public static boolean keyPressed(Object ingredient, int keyCode, int scanCode, int modifiers) {
            if (ingredient instanceof EmiStack) {
                EmiStack emiStack = (EmiStack)ingredient;
                return EmiScreenManager.stackInteraction((EmiStackInteraction)new EmiStackInteraction((EmiIngredient)emiStack), bind -> bind.matchesKey(keyCode, scanCode));
            }
            return false;
        }
    }

    public static final class REICallWrapper {
        public static List<Object> getReiIngredients(Stream<FluidStack> stream) {
            return List.of(EntryIngredient.of(stream.map(fluidStack -> dev.architectury.fluid.FluidStack.create((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (CompoundTag)fluidStack.getTag())).map(EntryStacks::of).toList()));
        }

        public static List<Object> getReiIngredients(List<Pair<TagKey<Fluid>, Long>> list) {
            return list.stream().map(pair -> EntryIngredients.ofTag((TagKey)((TagKey)pair.getFirst()), holder -> EntryStacks.of((dev.architectury.fluid.FluidStack)dev.architectury.fluid.FluidStack.create((Fluid)((Fluid)holder.m_203334_()), (long)((Long)pair.getSecond()))))).collect(Collectors.toList());
        }
    }
}

