/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.part;

import codechicken.multipart.util.PartRayTraceResult;
import java.util.Random;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.part.IOrientableFacePart;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.part.RedstoneGatePart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LightLayer;

public abstract class SimpleGatePart
extends RedstoneGatePart {
    private static final int[] ADVANCE_DEAD = new int[]{1, 2, 4, 0, 5, 6, 3};

    public SimpleGatePart(GateType type) {
        super(type);
    }

    @Override
    protected boolean gateLogicCycleShape() {
        int oldShape = this.shape();
        int newShape = this.cycleShape(oldShape);
        if (newShape != oldShape) {
            this.setShape(newShape);
            return true;
        }
        return false;
    }

    protected int cycleShape(int shape) {
        if (this.deadSides() != 0) {
            int shape1 = this.shape();
            while (Integer.bitCount(shape1 = ADVANCE_DEAD[shape1]) > this.maxDeadSides() || 32 - Integer.numberOfLeadingZeros(shape1) > this.deadSides()) {
            }
            return shape1;
        }
        return shape;
    }

    protected int deadSides() {
        return 0;
    }

    protected int maxDeadSides() {
        return this.deadSides() - 1;
    }

    @Override
    protected void gateLogicOnChange() {
        int newOutput;
        int newInput;
        int iMask = this.inputMask(this.shape());
        int oMask = this.outputMask(this.shape());
        int fMask = this.feedbackMask(this.shape());
        int oldInput = this.getState() & 0xF;
        if (oldInput != (newInput = this.getInput(iMask | fMask))) {
            this.setState(this.getState() & 0xF0 | newInput);
            this.onInputChange();
        }
        if ((newOutput = this.calcOutput(this.state() & iMask) & oMask) != this.state() >> 4) {
            this.scheduleTick(this.getDelay(this.shape()));
        }
    }

    @Override
    protected void gateLogicOnScheduledTick() {
        int newOutput;
        int iMask = this.inputMask(this.shape());
        int oMask = this.outputMask(this.shape());
        int oldOutput = this.state() >> 4;
        if (oldOutput != (newOutput = this.calcOutput(this.state() & iMask) & oMask)) {
            this.setState(this.state() & 0xF | newOutput << 4);
            this.onOutputChange(oMask);
        }
        this.gateLogicOnChange();
    }

    @Override
    protected void gateLogicSetup() {
        int iMask = this.inputMask(this.shape());
        int oMask = this.outputMask(this.shape());
        int output = this.calcOutput(this.getInput(iMask)) & oMask;
        if (output != 0) {
            this.setState(output << 4);
            this.onOutputChange(output);
        }
    }

    int getDelay(int shape) {
        return 2;
    }

    int feedbackMask(int shape) {
        return 0;
    }

    int calcOutput(int input) {
        return 0;
    }

    public static class DecodingRandomizer
    extends SimpleGatePart {
        private static final Random RANDOM = new Random();
        private static final int[] OUTPUTS = new int[]{1, 8, 2};

        public DecodingRandomizer(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return shape == 0 ? 11 : 9;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        int feedbackMask(int shape) {
            return 2;
        }

        @Override
        protected int cycleShape(int shape) {
            return shape ^ 1;
        }

        @Override
        int calcOutput(int input) {
            if (input == 0) {
                return this.state() >> 4 == 0 ? 1 : this.state() >> 4;
            }
            int r = RANDOM.nextInt((~this.shape() | 2) & 3);
            return OUTPUTS[r];
        }

        @Override
        protected void gateLogicOnChange() {
            super.gateLogicOnChange();
            if ((this.state() & 4) != 0) {
                this.scheduleTick(2);
            }
        }
    }

    public static class RainSensor
    extends SimpleGatePart {
        public RainSensor(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 4;
        }

        @Override
        protected int inputMask(int shape) {
            return 0;
        }

        @Override
        int feedbackMask(int shape) {
            return 4;
        }

        @Override
        protected void gateLogicOnTick() {
            int oldOutput;
            if (this.level().f_46443_) {
                return;
            }
            int newOutput = this.level().m_46471_() && this.level().m_45527_(this.pos()) ? 4 : 0;
            if (newOutput != (oldOutput = this.state() >> 4)) {
                this.setState(newOutput << 4 | this.state() & 0xF);
                this.onOutputChange(4);
            }
        }

        @Override
        public int getLightEmission() {
            return 0;
        }
    }

    public static class LightSensor
    extends SimpleGatePart {
        public LightSensor(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 4;
        }

        @Override
        protected int inputMask(int shape) {
            return 0;
        }

        @Override
        int feedbackMask(int shape) {
            return 4;
        }

        @Override
        protected int cycleShape(int shape) {
            return (shape + 1) % 3;
        }

        @Override
        protected int getOutput(int r) {
            return r == 2 ? this.state() >> 4 : 0;
        }

        private int calcSkyLight() {
            return this.level().m_45517_(LightLayer.SKY, this.pos()) - this.level().m_7445_();
        }

        private int calcBlockLight() {
            return this.level().m_45517_(LightLayer.BLOCK, this.pos());
        }

        @Override
        protected void gateLogicOnTick() {
            int newOutput;
            if (this.level().f_46443_) {
                return;
            }
            int n = this.shape() == 1 ? this.calcSkyLight() : (newOutput = this.shape() == 2 ? this.calcBlockLight() : Math.max(this.calcSkyLight(), this.calcBlockLight()));
            if (newOutput != this.state() >> 4) {
                this.setState(newOutput << 4 | this.state() & 0xF);
                this.onOutputChange(4);
            }
        }

        @Override
        protected void gateLogicOnChange() {
            int newInput;
            int oldInput = this.state() & 0xF;
            if (oldInput != (newInput = this.getInput(4))) {
                this.setState(this.state() & 0xF0 | newInput);
                this.onInputChange();
            }
        }

        @Override
        public int getLightEmission() {
            return 0;
        }
    }

    public static class TransparentLatch
    extends SimpleGatePart {
        public TransparentLatch(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return shape == 0 ? 3 : 9;
        }

        @Override
        protected int inputMask(int shape) {
            return shape == 0 ? 12 : 6;
        }

        @Override
        protected int cycleShape(int shape) {
            return shape ^ 1;
        }

        @Override
        int calcOutput(int input) {
            return (input & 4) == 0 ? this.state() >> 4 : ((input & 0xA) == 0 ? 0 : 15);
        }
    }

    public static class Randomizer
    extends SimpleGatePart {
        private static final Random RANDOM = new Random();

        public Randomizer(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return ~((shape & 1) << 1 | (shape & 2) >> 1 | (shape & 4) << 1) & 0xB;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        int feedbackMask(int shape) {
            return this.outputMask(shape);
        }

        @Override
        protected int deadSides() {
            return 3;
        }

        @Override
        int calcOutput(int input) {
            if (input == 0) {
                return this.state() >> 4;
            }
            int r = IOrientableFacePart.shiftMask((int)RANDOM.nextInt(8), (int)3);
            return this.outputMask(this.shape()) & r;
        }

        @Override
        protected void gateLogicOnChange() {
            super.gateLogicOnChange();
            if ((this.state() & 4) != 0) {
                this.scheduleTick(2);
            }
        }
    }

    public static class Repeater
    extends SimpleGatePart {
        private static final int[] DELAYS = new int[]{2, 4, 6, 8, 16, 32, 64, 128, 256};

        public Repeater(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        int getDelay(int shape) {
            return DELAYS[shape];
        }

        @Override
        protected int cycleShape(int shape) {
            return (shape + 1) % DELAYS.length;
        }

        @Override
        int calcOutput(int input) {
            return input != 0 ? 1 : 0;
        }

        @Override
        protected void gateLogicOnChange() {
            if (!this.isTickScheduled()) {
                super.gateLogicOnChange();
            }
        }

        @Override
        protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
            if (held.m_41619_() || !(held.m_41720_() instanceof IScrewdriver)) {
                if (!this.level().f_46443_) {
                    this.configure();
                }
                return true;
            }
            return false;
        }
    }

    public static class Pulse
    extends SimpleGatePart {
        public Pulse(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        int calcOutput(int input) {
            return 0;
        }

        @Override
        protected void gateLogicOnChange() {
            int newInput;
            int oldInput = this.state() & 0xF;
            if (oldInput != (newInput = this.getInput(4))) {
                this.setState(this.state() & 0xF0 | newInput);
                this.onInputChange();
                if (newInput != 0 && (this.state() & 0xF0) == 0) {
                    this.setState(this.state() & 0xF | 0x10);
                    this.scheduleTick(2);
                    this.onOutputChange(1);
                }
            }
        }
    }

    public static class Multiplexer
    extends SimpleGatePart {
        public Multiplexer(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 14;
        }

        @Override
        int calcOutput(int input) {
            return (input & 4) != 0 ? input >> 3 & 1 : input >> 1 & 1;
        }
    }

    public static class Buffer
    extends SimpleGatePart {
        public Buffer(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return ~((shape & 1) << 1 | (shape & 2) << 2) & 0xB;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        int feedbackMask(int shape) {
            return this.outputMask(shape);
        }

        @Override
        protected int deadSides() {
            return 2;
        }

        @Override
        protected int maxDeadSides() {
            return 2;
        }

        @Override
        int calcOutput(int input) {
            return input != 0 ? 11 : 0;
        }
    }

    public static class XNOR
    extends SimpleGatePart {
        public XNOR(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 10;
        }

        @Override
        int calcOutput(int input) {
            boolean side1 = (input & 2) != 0;
            boolean side2 = (input & 8) != 0;
            return side1 == side2 ? 1 : 0;
        }
    }

    public static class XOR
    extends SimpleGatePart {
        public XOR(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return 10;
        }

        @Override
        int calcOutput(int input) {
            boolean side1 = (input & 2) != 0;
            boolean side2 = (input & 8) != 0;
            return side1 != side2 ? 1 : 0;
        }
    }

    public static class NAND
    extends SimpleGatePart {
        public NAND(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        protected int deadSides() {
            return 3;
        }

        @Override
        int calcOutput(int input) {
            return input == this.inputMask(this.shape()) ? 0 : 1;
        }
    }

    public static class AND
    extends SimpleGatePart {
        public AND(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        protected int deadSides() {
            return 3;
        }

        @Override
        int calcOutput(int input) {
            return input == this.inputMask(this.shape()) ? 1 : 0;
        }
    }

    public static class NOT
    extends SimpleGatePart {
        public NOT(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return ~((shape & 1) << 1 | (shape & 2) >> 1 | (shape & 4) << 1) & 0xB;
        }

        @Override
        protected int inputMask(int shape) {
            return 4;
        }

        @Override
        int feedbackMask(int shape) {
            return this.outputMask(shape);
        }

        @Override
        protected int deadSides() {
            return 3;
        }

        @Override
        int calcOutput(int input) {
            return input == 0 ? 11 : 0;
        }
    }

    public static class NOR
    extends SimpleGatePart {
        public NOR(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        int feedbackMask(int shape) {
            return 1;
        }

        @Override
        protected int deadSides() {
            return 3;
        }

        @Override
        int calcOutput(int input) {
            return input == 0 ? 1 : 0;
        }
    }

    public static class OR
    extends SimpleGatePart {
        public OR(GateType type) {
            super(type);
        }

        @Override
        protected int outputMask(int shape) {
            return 1;
        }

        @Override
        protected int inputMask(int shape) {
            return ~shape << 1 & 0xE;
        }

        @Override
        protected int deadSides() {
            return 3;
        }

        @Override
        int calcOutput(int input) {
            return input != 0 ? 1 : 0;
        }
    }
}

