/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.integration.part;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.MultiIndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.part.face.FaceMicroblockPart;
import codechicken.multipart.util.PartRayTraceResult;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.api.IMaskedBundledTile;
import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.part.IOrientableFacePart;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.part.RedstoneGatePart;
import mrtjp.projectred.lib.VecLib;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BundledGatePart
extends RedstoneGatePart
implements IBundledEmitter {
    public BundledGatePart(GateType type) {
        super(type);
    }

    @Nullable
    public byte[] getBundledSignal(int r) {
        int ir = this.toInternal(r);
        if ((this.bundledOutputMask(this.shape()) & 1 << ir) != 0) {
            return this.getBundledOutput(ir);
        }
        return null;
    }

    @Nullable
    protected byte[] getBundledInput(int r) {
        int ar = this.toAbsolute(r);
        if (this.maskConnectsCorner(ar)) {
            return this.calcCornerSignal(ar);
        }
        if (this.maskConnectsStraight(ar)) {
            return this.calcStraightSignal(ar);
        }
        if (this.maskConnectsInside(ar)) {
            return this.calcInsideSignal(ar);
        }
        return null;
    }

    @Nullable
    private byte[] calcCornerSignal(int r) {
        FaceLookup lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        return this.resolveArray(lookup);
    }

    @Nullable
    private byte[] calcStraightSignal(int r) {
        FaceLookup lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        return this.resolveArray(lookup);
    }

    @Nullable
    private byte[] calcInsideSignal(int r) {
        FaceLookup lookup = FaceLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        return this.resolveArray(lookup);
    }

    @Nullable
    protected byte[] resolveArray(FaceLookup lookup) {
        if (lookup.part instanceof IBundledEmitter) {
            return ((IBundledEmitter)lookup.part).getBundledSignal(lookup.otherRotation);
        }
        if (lookup.tile instanceof IBundledTile) {
            return ((IBundledTile)lookup.tile).getBundledSignal(Rotation.rotateSide((int)lookup.otherSide, (int)lookup.otherRotation));
        }
        if (lookup.tile != null) {
            return BundledSignalsLib.getBundledSignalViaInteraction((Level)Objects.requireNonNull(lookup.tile.m_58904_()), (BlockPos)lookup.tile.m_58899_(), (Direction)Direction.values()[Rotation.rotateSide((int)lookup.otherSide, (int)lookup.otherRotation)]);
        }
        return null;
    }

    public boolean discoverStraightOverride(int absDir) {
        FaceLookup lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)Rotation.rotationTo((int)this.getSide(), (int)absDir));
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof IMaskedBundledTile) {
            IMaskedBundledTile b = (IMaskedBundledTile)blockEntity;
            int r = Rotation.rotationTo((int)absDir, (int)this.getSide());
            return b.canConnectBundled(absDir ^ 1) && (b.getConnectionMask(absDir ^ 1) & 1 << r) != 0;
        }
        blockEntity = lookup.tile;
        if (blockEntity instanceof IBundledTile) {
            IBundledTile b = (IBundledTile)blockEntity;
            return b.canConnectBundled(absDir ^ 1);
        }
        if (BundledSignalsLib.canConnectBundledViaInteraction((Level)this.level(), (BlockPos)lookup.otherPos, (Direction)Direction.values()[absDir ^ 1])) {
            return true;
        }
        return super.discoverStraightOverride(absDir);
    }

    @Override
    public int getLightEmission() {
        return 0;
    }

    @Override
    protected boolean gateLogicCanConnectTo(IConnectable part, int r) {
        if (part instanceof IBundledEmitter) {
            return this.canConnectBundled(r);
        }
        return super.gateLogicCanConnectTo(part, r);
    }

    protected boolean canConnectBundled(int r) {
        return ((this.bundledInputMask(this.shape()) | this.bundledOutputMask(this.shape())) & 1 << r) != 0;
    }

    protected int bundledOutputMask(int shape) {
        return 0;
    }

    protected int bundledInputMask(int shape) {
        return 0;
    }

    @Nullable
    protected byte[] getBundledOutput(int r) {
        return null;
    }

    public static class SegmentDisplay
    extends BundledGatePart {
        private static final int KEY_BUNDLED_INPUT = 20;
        private short bInput0 = 0;

        public SegmentDisplay(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128376_("in", this.bInput0);
            tag.m_128379_("v2", true);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.bInput0 = tag.m_128448_("in");
            if (!tag.m_128471_("v2")) {
                this.bInput0 = (short)(this.bInput0 << 8 | this.state());
                this.setState(tag.m_128445_("col"));
            }
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeShort((int)this.bInput0);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.bInput0 = packet.readShort();
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 20: {
                    this.bInput0 = packet.readShort();
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        private void sendInputUpdate() {
            this.sendUpdate(20, p -> p.writeShort((int)this.bInput0));
        }

        @Override
        public short bInput0() {
            return this.bInput0;
        }

        @Override
        protected int bundledInputMask(int shape) {
            return 1;
        }

        @Override
        protected int getOutput(int r) {
            return 0;
        }

        @Override
        protected void gateLogicOnChange() {
            short newBIn = (short)BundledSignalsLib.packDigital((byte[])this.getBundledInput(0));
            if (this.bInput0 != newBIn) {
                this.bInput0 = newBIn;
                this.onInputChange();
                this.sendInputUpdate();
                this.scheduleTick(2);
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            this.gateLogicOnChange();
        }

        @Override
        protected void gateLogicSetup() {
            this.setState(EnumColour.RED.ordinal());
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }

        @Override
        protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
            if (held.m_41619_() || held.m_41720_() instanceof IScrewdriver) {
                return false;
            }
            EnumColour c = EnumColour.fromDyeStack((ItemStack)held);
            if (c != null && c.ordinal() != this.getState() && c != EnumColour.BLACK) {
                if (!this.level().f_46443_) {
                    this.setState(c.ordinal());
                    this.sendStateUpdate();
                }
                return true;
            }
            return false;
        }
    }

    public static class BusInputPanel
    extends BundledGatePart {
        private static final int KEY_PRESS_MASK = 20;
        private static final Cuboid6[] UNPRESSED_BOXES = VecLib.buildCubeArray((int)4, (int)4, (Cuboid6)new Cuboid6(3.0, 1.0, 3.0, 13.0, 3.0, 13.0), (Vector3)new Vector3(-0.25, 0.0, -0.25));
        private static final Cuboid6[] PRESSED_BOXES = VecLib.buildCubeArray((int)4, (int)4, (Cuboid6)new Cuboid6(3.0, 1.0, 3.0, 13.0, 2.5, 13.0), (Vector3)new Vector3(-0.25, 0.0, -0.25));
        private static final ArrayList<HashMap<Integer, MultiIndexedVoxelShape>> shapeCache = new ArrayList(24);
        private short pressMask = 0;
        private short bOut = 0;
        private final byte[] bOutUnpacked = new byte[16];

        public static MultiIndexedVoxelShape getOrCreateOutline(int orient, short pressMask) {
            while (shapeCache.size() <= orient) {
                shapeCache.add(null);
            }
            HashMap<Integer, Object> shapeMap = shapeCache.get(orient);
            if (shapeMap == null) {
                shapeMap = new HashMap();
                shapeCache.set(orient, shapeMap);
            }
            return shapeMap.computeIfAbsent(pressMask & 0xFFFF, k -> BusInputPanel.createOutline(orient, pressMask));
        }

        private static MultiIndexedVoxelShape createOutline(int orient, short pressMask) {
            Transformation t = VecLib.orientT((int)orient);
            LinkedList<IndexedVoxelShape> shapeList = new LinkedList<IndexedVoxelShape>();
            VoxelShape baseShape = VoxelShapeCache.getShape((Cuboid6)FaceMicroblockPart.aBounds[16].copy().apply(t));
            shapeList.add(new IndexedVoxelShape(baseShape, (Object)-1));
            for (int i = 0; i < 16; ++i) {
                Cuboid6 bounds = ((pressMask & 1 << i) != 0 ? PRESSED_BOXES : UNPRESSED_BOXES)[i].copy().apply(t);
                shapeList.add(new IndexedVoxelShape(VoxelShapeCache.getShape((Cuboid6)bounds), (Object)i));
            }
            return new MultiIndexedVoxelShape(ImmutableSet.copyOf(shapeList));
        }

        public BusInputPanel(GateType type) {
            super(type);
        }

        public void setbOut(int newBOut) {
            if (this.bOut != (short)newBOut) {
                this.bOut = (short)newBOut;
                BundledSignalsLib.unpackDigital((byte[])this.bOutUnpacked, (int)this.bOut);
            }
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128376_("press", this.pressMask);
            tag.m_128376_("mask", this.bOut);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.pressMask = tag.m_128448_("press");
            this.setbOut(tag.m_128448_("mask"));
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeShort((int)this.pressMask);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.pressMask = packet.readShort();
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 20: {
                    this.pressMask = packet.readShort();
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        private void sendClientUpdate() {
            this.sendUpdate(20, p -> p.writeShort((int)this.pressMask));
        }

        @Override
        public short bOutput2() {
            return this.bOut;
        }

        @Override
        public short bInput0() {
            return this.pressMask;
        }

        @Override
        public BlockPos worldPos() {
            return this.pos();
        }

        @Override
        protected int bundledOutputMask(int shape) {
            return 4;
        }

        @Override
        protected int bundledInputMask(int shape) {
            return 0;
        }

        @Override
        protected int outputMask(int shape) {
            return 0;
        }

        @Override
        protected int inputMask(int shape) {
            return 1;
        }

        @Override
        protected int getOutput(int r) {
            return (this.state() & 16 << r) != 0 ? 15 : 0;
        }

        @Override
        @Nullable
        protected byte[] getBundledOutput(int r) {
            return this.bOutUnpacked;
        }

        @Override
        protected void gateLogicOnChange() {
            short newBInput;
            short oldBInput;
            int newInput;
            boolean inputChanged = false;
            int oldInput = this.state() & 0xF;
            if (oldInput != (newInput = this.getInput(1))) {
                this.setState(this.state() & 0xF0 | newInput);
                inputChanged = true;
            }
            if ((this.state() & 1) != 0) {
                this.pressMask = 0;
            }
            if ((oldBInput = this.bOut) != (newBInput = this.pressMask)) {
                inputChanged = true;
            }
            if (inputChanged) {
                this.onInputChange();
                this.scheduleTick(2);
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            boolean outputChanged = false;
            short oldBOut = this.bOut;
            short newBOut = this.pressMask;
            if (oldBOut != newBOut) {
                this.setbOut(this.pressMask);
                outputChanged = true;
                this.sendClientUpdate();
            }
            if (outputChanged) {
                this.onOutputChange(this.bundledOutputMask(this.shape()));
            }
            this.gateLogicOnChange();
        }

        @Override
        public VoxelShape getShape(CollisionContext context) {
            return BusInputPanel.getOrCreateOutline(this.getOrientation(), this.pressMask);
        }

        @Override
        protected boolean gateLogicActivate(Player player, ItemStack held, PartRayTraceResult hit) {
            if (!held.m_41619_() && held.m_41720_() instanceof IScrewdriver) {
                return false;
            }
            if (hit.subHit > -1) {
                if (!this.level().f_46443_) {
                    this.pressMask = (short)(this.pressMask ^ 1 << hit.subHit);
                    this.gateLogicOnChange();
                }
                return true;
            }
            return false;
        }
    }

    public static class BusConverter
    extends BundledGatePart {
        private static final int KEY_CLIENT_IO = 20;
        private short bIn;
        private short bOut;
        private byte rsIn;
        private byte rsOut;
        private final byte[] bOutUnpacked = new byte[16];
        boolean forceBInUpdate;
        boolean forceBOutUpdate = false;

        public BusConverter(GateType type) {
            super(type);
        }

        private void setBOut(int newBOut) {
            if (this.bOut != (short)newBOut) {
                this.bOut = (short)newBOut;
                BundledSignalsLib.unpackDigital((byte[])this.bOutUnpacked, (int)this.bOut);
            }
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128344_("in", this.rsIn);
            tag.m_128344_("out", this.rsOut);
            tag.m_128376_("in0", this.bIn);
            tag.m_128376_("out0", this.bOut);
            tag.m_128379_("revised", true);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.rsIn = tag.m_128445_("in");
            this.rsOut = tag.m_128445_("out");
            if (tag.m_128471_("revised")) {
                this.bIn = tag.m_128448_("in0");
                this.setBOut(tag.m_128448_("out0"));
            } else {
                this.bIn = tag.m_128445_("in0");
                this.setBOut(tag.m_128445_("out0"));
                this.forceBInUpdate = true;
                this.forceBOutUpdate = true;
            }
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeShort((int)this.packClientData());
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.unpackClientData(packet.readShort());
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 20: {
                    this.unpackClientData(packet.readShort());
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        private void sendClientUpdate() {
            this.sendUpdate(20, p -> p.writeShort((int)this.packClientData()));
        }

        private short packClientData() {
            return (short)(this.rsIn | this.rsOut << 4 | BundledSignalsLib.mostSignificantBit((short)this.bIn) << 8 | BundledSignalsLib.mostSignificantBit((short)this.bOut) << 12);
        }

        private void unpackClientData(int data) {
            this.rsIn = (byte)(data & 0xF);
            this.rsOut = (byte)(data >> 4 & 0xF);
            this.bIn = (short)(1 << (data >> 8 & 0xF));
            this.setBOut(1 << (data >> 12 & 0xF));
        }

        @Override
        public int rsIO() {
            return (this.rsIn | this.rsOut) & 0xFF;
        }

        @Override
        protected int bundledOutputMask(int shape) {
            return shape == 0 ? 1 : 0;
        }

        @Override
        protected int bundledInputMask(int shape) {
            return shape == 0 ? 0 : 1;
        }

        @Override
        protected int outputMask(int shape) {
            return shape == 0 ? 10 : 14;
        }

        @Override
        protected int inputMask(int shape) {
            return shape == 0 ? 4 : 0;
        }

        @Override
        protected int getOutput(int r) {
            return this.shape() != 0 && r == 2 ? this.rsOut : ((this.state() & 16 << r) != 0 ? 15 : 0);
        }

        @Override
        @Nullable
        protected byte[] getBundledOutput(int r) {
            return this.shape() == 0 && r == 0 ? this.bOutUnpacked : null;
        }

        @Override
        protected void gateLogicOnChange() {
            boolean changed = false;
            byte oldRSIn = this.rsIn;
            this.rsIn = (byte)(this.shape() == 0 ? this.getAnalogRedstoneInput(2) : 0);
            if (oldRSIn != this.rsIn) {
                changed = true;
            }
            short oldBIn = this.bIn;
            this.bIn = (short)(this.shape() == 0 ? 0 : BundledSignalsLib.packDigital((byte[])this.getBundledInput(0)));
            if (oldBIn != this.bIn) {
                changed = true;
            }
            if (changed | this.forceBInUpdate) {
                this.forceBInUpdate = false;
                this.onInputChange();
                this.scheduleTick(2);
                this.sendClientUpdate();
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            int newOut2;
            int changeMask = 0;
            short oldBOut = this.bOut;
            this.setBOut(this.shape() == 0 ? 1 << this.rsIn : 0);
            if (oldBOut != this.bOut | this.forceBOutUpdate) {
                this.forceBOutUpdate = false;
                changeMask |= 1;
            }
            byte oldRSOut = this.rsOut;
            this.rsOut = (byte)(this.shape() == 0 ? 0 : BundledSignalsLib.mostSignificantBit((short)this.bIn));
            if (this.rsOut != oldRSOut) {
                changeMask |= 4;
            }
            int oldOut2 = this.state() >> 4;
            int n = newOut2 = (this.shape() == 0 ? (short)this.rsIn : this.bIn) != 0 ? 10 : 0;
            if (oldOut2 != newOut2) {
                this.setState(this.state() & 0xF | newOut2 << 4);
                changeMask |= 0xA;
            }
            if (changeMask != 0) {
                this.onOutputChange(changeMask);
                this.sendClientUpdate();
            }
            this.gateLogicOnChange();
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }
    }

    public static class BusRandomizer
    extends BundledGatePart {
        private static final Random RANDOM = new Random();
        private static final int KEY_OUTPUT = 20;
        private static final int KEY_MASK = 21;
        private final byte[] unpackedOut = new byte[16];
        private short output = 0;
        private short mask = (short)-1;

        public BusRandomizer(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            tag.m_128376_("in", this.mask);
            tag.m_128376_("out", this.output);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.mask = tag.m_128448_("in");
            this.output = tag.m_128448_("out");
            BundledSignalsLib.unpackDigital((byte[])this.unpackedOut, (int)this.output);
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeShort((int)this.output);
            packet.writeShort((int)this.mask);
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.output = packet.readShort();
            this.mask = packet.readShort();
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 20: {
                    this.output = packet.readShort();
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                case 21: {
                    this.mask = packet.readShort();
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        protected void sendOutUpdate() {
            this.sendUpdate(20, p -> p.writeShort((int)this.output));
        }

        protected void sendMaskUpdate() {
            this.sendUpdate(21, p -> p.writeShort((int)this.mask));
        }

        @Override
        public short bOutput0() {
            return this.output;
        }

        @Override
        public short bInput2() {
            return this.mask;
        }

        @Override
        protected int bundledOutputMask(int shape) {
            return 5;
        }

        @Override
        protected int inputMask(int shape) {
            return 10;
        }

        @Override
        protected int outputMask(int shape) {
            return 0;
        }

        @Override
        protected void gateLogicOnChange() {
            short newMask;
            int newInput;
            boolean inputChanged = false;
            int oldInput = this.state() & 0xF;
            if (oldInput != (newInput = this.getInput(10))) {
                this.setState(this.state() & 0xF0 | newInput);
                inputChanged = true;
            }
            if ((newMask = (short)BundledSignalsLib.packDigital((byte[])this.getBundledInput(2))) == 0) {
                newMask = -1;
            }
            if (this.mask != newMask) {
                this.mask = newMask;
                inputChanged = true;
                this.sendMaskUpdate();
            }
            if (inputChanged) {
                this.onInputChange();
            }
            if (newInput != 0) {
                this.scheduleTick(2);
            }
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            short oldOut = this.output;
            short s = (this.state() & 0xF) != 0 ? (this.shape() == 0 ? this.calc1BitOut() : this.calcNBitOut()) : (this.output = oldOut);
            if (oldOut != this.output) {
                BundledSignalsLib.unpackDigital((byte[])this.unpackedOut, (int)this.output);
                this.onOutputChange(1);
                this.sendOutUpdate();
            }
            this.gateLogicOnChange();
        }

        private short calc1BitOut() {
            int high = Integer.bitCount(this.mask);
            int n = RANDOM.nextInt(high);
            int v = 0;
            for (int i = 0; i < 16; ++i) {
                if ((this.mask & 1 << i) == 0 || v++ != n) continue;
                return (short)(1 << i);
            }
            return 0;
        }

        private short calcNBitOut() {
            short out = 0;
            for (int i = 0; i < 16; ++i) {
                if ((this.mask & 1 << i) == 0 || !RANDOM.nextBoolean()) continue;
                out = (short)(out | 1 << i);
            }
            return out;
        }

        @Override
        @Nullable
        protected byte[] getBundledOutput(int r) {
            return r == 0 ? this.unpackedOut : null;
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }
    }

    public static class BusTransceiver
    extends BundledGatePart {
        private static final int KEY_PACKED_IO = 20;
        @Nullable
        private byte[] input0;
        @Nullable
        private byte[] output0;
        @Nullable
        private byte[] input2;
        @Nullable
        private byte[] output2 = null;
        private int packedOutput = 0;

        public BusTransceiver(GateType type) {
            super(type);
        }

        @Override
        public void save(CompoundTag tag) {
            super.save(tag);
            BundledSignalsLib.saveSignal((CompoundTag)tag, (String)"in0", (byte[])this.input0);
            BundledSignalsLib.saveSignal((CompoundTag)tag, (String)"out0", (byte[])this.output0);
            BundledSignalsLib.saveSignal((CompoundTag)tag, (String)"in2", (byte[])this.input2);
            BundledSignalsLib.saveSignal((CompoundTag)tag, (String)"out2", (byte[])this.output2);
        }

        @Override
        public void load(CompoundTag tag) {
            super.load(tag);
            this.input0 = BundledSignalsLib.loadSignal((CompoundTag)tag, (String)"in0");
            this.output0 = BundledSignalsLib.loadSignal((CompoundTag)tag, (String)"out0");
            this.input2 = BundledSignalsLib.loadSignal((CompoundTag)tag, (String)"in2");
            this.output2 = BundledSignalsLib.loadSignal((CompoundTag)tag, (String)"out2");
        }

        @Override
        public void writeDesc(MCDataOutput packet) {
            super.writeDesc(packet);
            packet.writeInt(this.packClientData());
        }

        @Override
        public void readDesc(MCDataInput packet) {
            super.readDesc(packet);
            this.unpackClientData(packet.readInt());
        }

        @Override
        protected void read(MCDataInput packet, int key) {
            switch (key) {
                case 20: {
                    this.unpackClientData(packet.readInt());
                    if (!Configurator.staticGates) break;
                    this.tile().markRender();
                    break;
                }
                default: {
                    super.read(packet, key);
                }
            }
        }

        protected void sendClientUpdate() {
            this.sendUpdate(20, p -> p.writeInt(this.packClientData()));
        }

        private int packClientData() {
            return BundledSignalsLib.packDigital((byte[])this.output0) | BundledSignalsLib.packDigital((byte[])this.output2) << 16;
        }

        private void unpackClientData(int packed) {
            this.packedOutput = packed;
            this.output0 = BundledSignalsLib.unpackDigital((byte[])this.output0, (int)(packed & 0xFFFF));
            this.output2 = BundledSignalsLib.unpackDigital((byte[])this.output2, (int)(packed >>> 16));
        }

        @Override
        public short bOutput0() {
            return (short)(this.packedOutput & 0xFFFF);
        }

        @Override
        public short bOutput2() {
            return (short)(this.packedOutput >>> 16);
        }

        @Override
        protected int bundledOutputMask(int shape) {
            return 5;
        }

        @Override
        protected int bundledInputMask(int shape) {
            return 5;
        }

        @Override
        protected int outputMask(int shape) {
            return 0;
        }

        @Override
        protected int inputMask(int shape) {
            return 10;
        }

        @Override
        @Nullable
        protected byte[] getBundledOutput(int r) {
            return r == 0 ? this.output0 : this.output2;
        }

        protected byte[] calcBundledInput(int r) {
            return BundledSignalsLib.raiseSignal((byte[])BundledSignalsLib.copySignal((byte[])this.getBundledInput(r)), (byte[])this.getBundledOutput(r));
        }

        @Override
        protected void gateLogicOnChange() {
            byte[] newInput2;
            byte[] newInput0;
            int newInput;
            boolean inputChanged = false;
            int oldInput = this.state() & 0xF;
            if (oldInput != (newInput = this.getInput(10))) {
                this.setState(this.state() & 0xF0 | newInput);
                inputChanged = true;
            }
            if (!BundledSignalsLib.signalsEqual((byte[])this.input0, (byte[])(newInput0 = this.calcBundledInput(0)))) {
                this.input0 = newInput0;
                inputChanged = true;
            }
            if (!BundledSignalsLib.signalsEqual((byte[])this.input2, (byte[])(newInput2 = this.calcBundledInput(2)))) {
                this.input2 = newInput2;
                inputChanged = true;
            }
            if (inputChanged) {
                this.onInputChange();
            }
            if (!BundledSignalsLib.signalsEqual((byte[])this.output0, (byte[])this.calcBundledOutput(0)) || !BundledSignalsLib.signalsEqual((byte[])this.output2, (byte[])this.calcBundledOutput(2))) {
                this.scheduleTick(2);
            }
        }

        @Nullable
        protected byte[] calcBundledOutput(int r) {
            int input = this.state() & 0xF;
            if (this.shape() == 1) {
                input = IOrientableFacePart.flipMaskZ((int)input);
            }
            if (r == 0) {
                return (input & 2) != 0 ? this.input2 : null;
            }
            if (r == 2) {
                return (input & 8) != 0 ? this.input0 : null;
            }
            return null;
        }

        @Override
        protected void gateLogicOnScheduledTick() {
            this.output0 = this.calcBundledOutput(0);
            this.output2 = this.calcBundledOutput(2);
            this.gateLogicOnChange();
            this.onOutputChange(5);
            this.sendClientUpdate();
        }

        @Override
        protected boolean gateLogicCycleShape() {
            this.setShape(this.shape() == 0 ? 1 : 0);
            return true;
        }
    }
}

