/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.salju.trialstowers.Trials;
import net.salju.trialstowers.block.TrialVaultBlock;
import net.salju.trialstowers.events.TrialsManager;
import net.salju.trialstowers.init.TrialsBlockEntities;
import net.salju.trialstowers.init.TrialsSounds;

public class TrialVaultEntity
extends BlockEntity {
    private String table;
    private boolean isOminous;
    private int cd;

    public TrialVaultEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TrialsBlockEntities.VAULT.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.table != null) {
            tag.m_128359_("LootTable", this.table);
        }
        tag.m_128405_("Cooldown", this.cd);
        tag.m_128379_("Ominous", this.isOminous);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("LootTable")) {
            this.table = tag.m_128461_("LootTable");
        }
        this.cd = tag.m_128451_("Cooldown");
        this.isOminous = tag.m_128471_("Ominous");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection queen, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            if (packet.m_131708_().m_128441_("LootTable")) {
                this.table = packet.m_131708_().m_128461_("LootTable");
            }
            this.cd = packet.m_131708_().m_128451_("Cooldown");
            this.isOminous = packet.m_131708_().m_128471_("Ominous");
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        if (this.table != null) {
            tag.m_128359_("LootTable", this.table);
        }
        tag.m_128405_("Cooldown", this.cd);
        tag.m_128379_("Ominous", this.isOminous);
        return tag;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TrialVaultEntity target) {
        Block block = state.m_60734_();
        if (block instanceof TrialVaultBlock) {
            TrialVaultBlock block2 = (TrialVaultBlock)block;
            target.updateBlock();
            if (world instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)world;
                if (block2.isActive(state)) {
                    lvl.m_8767_((ParticleOptions)(target.isOminous() ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1, 0.12, 0.12, 0.12, 0.0);
                    if (block2.isEjecting(state)) {
                        if (target.getCd() == 1) {
                            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)TrialVaultBlock.EJECT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TrialVaultBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                            lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.SPAWNER_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            target.setCd(12000);
                        } else if (target.getCd() == 0) {
                            int e = Mth.m_216271_((RandomSource)world.m_213780_(), (int)4, (int)7);
                            target.setCd(20 * e);
                            lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.VAULT_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            for (int i = 0; i != e; ++i) {
                                Trials.queueServerWork(20 * i, () -> {
                                    for (ItemStack stack : TrialsManager.getLoot(target, world, target.getLootTable())) {
                                        lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.VAULT_EJECT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                                        Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)((double)pos.m_123342_() + 1.0), (double)pos.m_123343_(), (ItemStack)stack);
                                    }
                                });
                            }
                        } else {
                            target.setCd(target.getCd() - 1);
                        }
                    }
                } else {
                    lvl.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.95, (double)pos.m_123343_() + 0.5, 1, 0.12, 0.12, 0.12, 0.0);
                    if (target.getCd() != 0) {
                        target.setCd(target.getCd() - 1);
                    } else {
                        world.m_7731_(pos, (BlockState)state.m_61124_((Property)TrialVaultBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 3);
                        lvl.m_5594_(null, pos, (SoundEvent)TrialsSounds.VAULT_ACTIVATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    public int getCd() {
        return this.cd;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public String getLootTable() {
        if (this.table != null) {
            return this.table;
        }
        return this.isOminous() ? "trials:gameplay/vault_special_loot" : "trials:gameplay/vault_loot";
    }

    public void setCd(int i) {
        this.cd = i;
    }

    public void setVault(boolean check) {
        this.isOminous = check;
    }

    public void updateBlock() {
        this.m_6596_();
        this.m_58904_().m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }
}

