/*
 * Decompiled with CFR 0.152.
 */
package net.salju.trialstowers;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.salju.trialstowers.init.TrialsBanners;
import net.salju.trialstowers.init.TrialsBlockEntities;
import net.salju.trialstowers.init.TrialsBlocks;
import net.salju.trialstowers.init.TrialsEffects;
import net.salju.trialstowers.init.TrialsEnchantments;
import net.salju.trialstowers.init.TrialsItems;
import net.salju.trialstowers.init.TrialsMenus;
import net.salju.trialstowers.init.TrialsMobs;
import net.salju.trialstowers.init.TrialsPaintings;
import net.salju.trialstowers.init.TrialsPotions;
import net.salju.trialstowers.init.TrialsSherds;
import net.salju.trialstowers.init.TrialsSounds;
import net.salju.trialstowers.init.TrialsStructures;
import net.salju.trialstowers.init.TrialsTabs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="trials")
public class Trials {
    public static final Logger LOGGER = LogManager.getLogger(Trials.class);
    public static final String MODID = "trials";
    private static final String V = "1";
    public static final SimpleChannel PACKET = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("trials", "trials"), () -> "1", "1"::equals, "1"::equals);
    private static int id = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public Trials() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        TrialsStructures.REGISTRY.register(bus);
        TrialsMenus.REGISTRY.register(bus);
        TrialsSounds.REGISTRY.register(bus);
        TrialsMobs.REGISTRY.register(bus);
        TrialsBlocks.REGISTRY.register(bus);
        TrialsBlockEntities.REGISTRY.register(bus);
        TrialsItems.REGISTRY.register(bus);
        TrialsSherds.REGISTRY.register(bus);
        TrialsBanners.REGISTRY.register(bus);
        TrialsPaintings.REGISTRY.register(bus);
        TrialsEnchantments.REGISTRY.register(bus);
        TrialsEffects.REGISTRY.register(bus);
        TrialsPotions.REGISTRY.register(bus);
        TrialsTabs.REGISTRY.register(bus);
    }

    public static <T> void addNetworkMessage(Class<T> type, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> supply) {
        PACKET.registerMessage(id, type, encoder, decoder, supply);
        ++id;
    }

    public static <MSG> void sendToClientPlayer(MSG msg, ServerPlayer ply) {
        PACKET.sendTo(msg, ply.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

