/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import de.mrjulsen.crn.CRNPlatformSpecific;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;

public class AdvancedDisplaySource
extends DisplaySource {
    public static final String NBT_ADVANCED_DISPLAY = "AdvancedDisplay";
    public static final String NBT_FILTER = "Filter";
    public static final String NBT_TRAIN_NAME_WIDTH = "TrainNameWidth";
    public static final String NBT_PLATFORM_WIDTH = "PlatformWidth";
    public static final String NBT_TIME_DISPLAY_TYPE = "TimeDisplay";

    public List<MutableComponent> provideText(DisplayLinkContext context, DisplayTargetStats stats) {
        context.sourceConfig().m_128379_(NBT_ADVANCED_DISPLAY, true);
        return EMPTY;
    }

    public List<List<MutableComponent>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        context.sourceConfig().m_128379_(NBT_ADVANCED_DISPLAY, true);
        return List.of();
    }

    protected String getTranslationKey() {
        return "advanced_display";
    }

    public void populateData(DisplayLinkContext context) {
        CompoundTag conf = context.sourceConfig();
        if (!conf.m_128441_(NBT_TRAIN_NAME_WIDTH)) {
            conf.m_128405_(NBT_TRAIN_NAME_WIDTH, 16);
        }
        if (!conf.m_128441_(NBT_PLATFORM_WIDTH)) {
            conf.m_128405_(NBT_PLATFORM_WIDTH, -1);
        }
        if (!conf.m_128441_(NBT_TIME_DISPLAY_TYPE)) {
            conf.m_128405_(NBT_TIME_DISPLAY_TYPE, (int)ETimeDisplay.ABS.getId());
        }
        if (conf.m_128441_(NBT_FILTER)) {
            return;
        }
        GlobalStation station = CRNPlatformSpecific.getStationFromBlockEntity(context.getSourceBlockEntity());
        if (station == null) {
            return;
        }
        conf.m_128359_(NBT_FILTER, station.name);
    }

    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        if (isFirstLine) {
            builder.addTextInput(0, 137, (e, t) -> {
                e.m_94144_("");
                t.withTooltip((List)ImmutableList.of((Object)CreateLang.translateDirect((String)"display_source.station_summary.filter", (Object[])new Object[0]).m_130938_(s -> s.m_178520_(5476833)), (Object)CreateLang.translateDirect((String)"gui.schedule.lmb_edit", (Object[])new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC})));
            }, NBT_FILTER);
            return;
        }
    }
}

