/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.multipart.api.MultipartType;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.transmission.TransmissionAPI;
import mrtjp.projectred.transmission.data.TransmissionBlockTagsProvider;
import mrtjp.projectred.transmission.data.TransmissionItemModelProvider;
import mrtjp.projectred.transmission.data.TransmissionItemTagsProvider;
import mrtjp.projectred.transmission.data.TransmissionLanguageProvider;
import mrtjp.projectred.transmission.data.TransmissionRecipeProvider;
import mrtjp.projectred.transmission.init.TransmissionClientInit;
import mrtjp.projectred.transmission.init.TransmissionCreativeModeTabs;
import mrtjp.projectred.transmission.init.TransmissionParts;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="projectred_transmission")
public class ProjectRedTransmission {
    public static final String MOD_ID = "projectred_transmission";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred_transmission");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceLocation)MultipartType.MULTIPART_TYPES, (String)"projectred_transmission");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"projectred_transmission");

    public ProjectRedTransmission() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> TransmissionClientInit::init);
        ITEMS.register(modEventBus);
        PART_TYPES.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStartEvent);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new TransmissionItemModelProvider(output, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new TransmissionLanguageProvider(output));
        TransmissionBlockTagsProvider blockTagsProvider = new TransmissionBlockTagsProvider(output, event.getLookupProvider(), fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new TransmissionItemTagsProvider(output, event.getLookupProvider(), blockTagsProvider.m_274426_(), fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new TransmissionRecipeProvider(output));
    }

    private void onServerStartEvent(ServerAboutToStartEvent event) {
        RedstonePropagator.resetPowerFlags();
    }

    static {
        ProjectRedAPI.transmissionAPI = TransmissionAPI.INSTANCE;
        TransmissionParts.register();
        TransmissionCreativeModeTabs.register();
    }
}

