/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo.compat.jei.impl;

import com.mojang.blaze3d.platform.InputConstants;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pie.ilikepiefoo.compat.jei.builder.RecipeCategoryBuilder;

public class CustomRecipeCategory<T>
implements IRecipeCategory<T> {
    private final RecipeCategoryBuilder<T> builder;

    public CustomRecipeCategory(RecipeCategoryBuilder<T> builder) {
        this.builder = builder;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.builder.getRecipeType();
    }

    @NotNull
    public Component getTitle() {
        return this.builder.getCategoryTitle();
    }

    @Deprecated(since="15.20.0", forRemoval=true)
    @Nullable
    public IDrawable getBackground() {
        try {
            return Optional.ofNullable(this.builder.getBackgroundSupplier()).or(() -> Optional.of(() -> super.getBackground())).get().get();
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error drawing recipe category: " + this.builder.getRecipeType().getUid(), e);
            return super.getBackground();
        }
    }

    public int getWidth() {
        try {
            return Optional.ofNullable(this.builder.getWidthSupplier()).or(() -> Optional.of(() -> super.getWidth())).get().get();
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error drawing recipe category: " + this.builder.getRecipeType().getUid(), e);
            return super.getWidth();
        }
    }

    public int getHeight() {
        try {
            return Optional.ofNullable(this.builder.getHeightSupplier()).or(() -> Optional.of(() -> super.getHeight())).get().get();
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error drawing recipe category: " + this.builder.getRecipeType().getUid(), e);
            return super.getHeight();
        }
    }

    @NotNull
    public IDrawable getIcon() {
        return this.builder.getCategoryIcon();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        if (this.builder.getSetRecipeHandler() == null) {
            return;
        }
        try {
            this.builder.getSetRecipeHandler().setRecipe(builder, recipe, focuses);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error setting recipe for recipe category: " + this.builder.getRecipeType().getUid(), e);
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, T recipe, IFocusGroup focuses) {
        try {
            Optional.ofNullable(this.builder.getCreateRecipeExtrasHandler()).or(() -> Optional.of((x$0, x$1, x$2) -> super.createRecipeExtras(x$0, x$1, x$2))).get().createRecipeExtras(builder, recipe, focuses);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error creating recipe extras for category: " + this.builder.getRecipeType().getUid(), e);
        }
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        try {
            Optional.ofNullable(this.builder.getDrawHandler()).or(() -> Optional.of((x$0, x$1, x$2, x$3, x$4) -> super.draw(x$0, x$1, x$2, x$3, x$4))).ifPresent(handler -> handler.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY));
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error drawing recipe category: " + this.builder.getRecipeType().getUid(), e);
        }
        super.draw(recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
    }

    public void onDisplayedIngredientsUpdate(T recipe, List<IRecipeSlotDrawable> recipeSlots, IFocusGroup focuses) {
        try {
            Optional.ofNullable(this.builder.getDisplayedIngredientsUpdateHandler()).or(() -> Optional.of((x$0, x$1, x$2) -> super.onDisplayedIngredientsUpdate(x$0, x$1, x$2))).get().onDisplayedIngredientsUpdate(recipe, recipeSlots, focuses);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error updating displayed ingredients for recipe category: " + this.builder.getRecipeType().getUid(), e);
        }
    }

    @Deprecated(since="15.8.4", forRemoval=true)
    @NotNull
    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        try {
            return Optional.ofNullable(this.builder.getTooltipStringsHandler()).or(() -> Optional.of((x$0, x$1, x$2, x$3) -> super.getTooltipStrings(x$0, x$1, x$2, x$3))).get().getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error getting tooltip strings for recipe category: " + this.builder.getRecipeType().getUid(), e);
            return super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        try {
            Optional.ofNullable(this.builder.getTooltipHandlerOverride()).or(() -> Optional.of((x$0, x$1, x$2, x$3, x$4) -> super.getTooltip(x$0, x$1, x$2, x$3, x$4))).get().getTooltip(tooltip, recipe, recipeSlotsView, mouseX, mouseY);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error getting tooltip for recipe category: " + this.builder.getRecipeType().getUid(), e);
        }
    }

    @Deprecated(since="15.9.0", forRemoval=true)
    public boolean handleInput(T recipe, double mouseX, double mouseY, InputConstants.Key input) {
        try {
            return Optional.ofNullable(this.builder.getInputHandler()).or(() -> Optional.of((x$0, x$1, x$2, x$3) -> super.handleInput(x$0, x$1, x$2, x$3))).get().handleInput(recipe, mouseX, mouseY, input);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error handling input for recipe category: " + this.builder.getRecipeType().getUid(), e);
            return super.handleInput(recipe, mouseX, mouseY, input);
        }
    }

    public boolean isHandled(T recipe) {
        try {
            return Optional.ofNullable(this.builder.getIsRecipeHandledByCategory()).or(() -> Optional.of(x$0 -> super.isHandled(x$0))).get().isHandled(recipe);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error checking if recipe is handled by category: " + this.builder.getRecipeType().getUid(), e);
            return super.isHandled(recipe);
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(T recipe) {
        try {
            return Optional.ofNullable(this.builder.getGetRegisterName()).or(() -> Optional.of(x$0 -> super.getRegistryName(x$0))).get().getRegistryName(recipe);
        }
        catch (Throwable e) {
            ConsoleJS.CLIENT.error("Error getting registry name for recipe category: " + this.builder.getRecipeType().getUid(), e);
            return super.getRegistryName(recipe);
        }
    }
}

