/*
 * Decompiled with CFR 0.152.
 */
package pie.ilikepiefoo.compat.jei.builder;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeCategoryBuilder<T> {
    @NotNull
    private final RecipeType<T> recipeType;
    @NotNull
    private final IJeiHelpers jeiHelpers;
    @NotNull
    private Supplier<Component> title;
    @NotNull
    private Supplier<IDrawable> background;
    @NotNull
    private Supplier<IDrawable> icon;
    private Supplier<Integer> width;
    private Supplier<Integer> height;
    private SetRecipeHandler<T> setRecipeHandler;
    private CreateRecipeExtrasHandler<T> createRecipeExtrasHandler;
    private DrawHandler<T> drawHandler;
    private TooltipStringsHandler<T> tooltipStringsHandler;
    private GetTooltipHandler<T> getTooltipHandler;
    private InputHandler<T> inputHandler;
    private IsRecipeHandledByCategory<T> isRecipeHandledByCategory;
    private GetRegisterName<T> getRegisterName;
    private DisplayedIngredientsUpdateHandler<T> displayedIngredientsUpdateHandler;

    public RecipeCategoryBuilder(@NotNull RecipeType<T> recipeType, @NotNull IJeiHelpers jeiHelpers) {
        this.recipeType = recipeType;
        this.jeiHelpers = jeiHelpers;
        MutableComponent title = Component.m_237113_((String)"KubeJS Additions Custom Category");
        this.title = () -> title;
        IDrawable background = this.jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)Items.f_42682_));
        this.background = () -> background;
        IDrawable icon = this.jeiHelpers.getGuiHelper().createDrawableItemStack(new ItemStack((ItemLike)Items.f_41996_));
        this.icon = () -> icon;
        this.width = () -> ((IDrawable)background).getWidth();
        this.height = () -> ((IDrawable)background).getHeight();
    }

    @NotNull
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    @NotNull
    public Component getCategoryTitle() {
        return this.title.get();
    }

    public RecipeCategoryBuilder<T> title(@NotNull Component title) {
        this.title = () -> title;
        return this;
    }

    public RecipeCategoryBuilder<T> titleSupplier(@NotNull Supplier<Component> title) {
        this.title = title;
        return this;
    }

    @Nullable
    public IDrawable getCategoryBackground() {
        return this.background.get();
    }

    public Supplier<IDrawable> getBackgroundSupplier() {
        return this.background;
    }

    public RecipeCategoryBuilder<T> background(@Nullable IDrawable background) {
        this.background = () -> background;
        return this;
    }

    public RecipeCategoryBuilder<T> backgroundSupplier(@NotNull Supplier<IDrawable> background) {
        this.background = background;
        return this;
    }

    @NotNull
    public IDrawable getCategoryIcon() {
        return this.icon.get();
    }

    public RecipeCategoryBuilder<T> icon(@NotNull IDrawable icon) {
        this.icon = () -> icon;
        return this;
    }

    public RecipeCategoryBuilder<T> iconSupplier(@NotNull Supplier<IDrawable> icon) {
        this.icon = icon;
        return this;
    }

    public int getWidth() {
        return this.width.get();
    }

    public RecipeCategoryBuilder<T> setWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be greater than or equal to zero");
        }
        if (width == 0) {
            throw new IllegalArgumentException("width must be greater than zero");
        }
        this.width = () -> width;
        return this;
    }

    public Supplier<Integer> getWidthSupplier() {
        return this.width;
    }

    public RecipeCategoryBuilder<T> setWidthSupplier(Supplier<Integer> widthSupplier) {
        this.width = widthSupplier;
        return this;
    }

    public int getHeight() {
        return this.height.get();
    }

    public RecipeCategoryBuilder<T> setHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("height must be greater than or equal to zero");
        }
        if (height == 0) {
            throw new IllegalArgumentException("height must be greater than zero");
        }
        this.height = () -> height;
        return this;
    }

    public Supplier<Integer> getHeightSupplier() {
        return this.height;
    }

    public RecipeCategoryBuilder<T> setHeightSupplier(Supplier<Integer> heightSupplier) {
        this.height = heightSupplier;
        return this;
    }

    public SetRecipeHandler<T> getSetRecipeHandler() {
        return this.setRecipeHandler;
    }

    public RecipeCategoryBuilder<T> setDrawHandler(DrawHandler<T> drawHandler) {
        this.drawHandler = drawHandler;
        return this;
    }

    public CreateRecipeExtrasHandler<T> getCreateRecipeExtrasHandler() {
        return this.createRecipeExtrasHandler;
    }

    public TooltipStringsHandler<T> getTooltipStringsHandler() {
        return this.tooltipStringsHandler;
    }

    public DrawHandler<T> getDrawHandler() {
        return this.drawHandler;
    }

    public GetTooltipHandler<T> getTooltipHandlerOverride() {
        return this.getTooltipHandler;
    }

    public RecipeCategoryBuilder<T> setTooltipHandlerOverride(GetTooltipHandler<T> getTooltipHandler) {
        this.getTooltipHandler = getTooltipHandler;
        return this;
    }

    public DisplayedIngredientsUpdateHandler<T> getDisplayedIngredientsUpdateHandler() {
        return this.displayedIngredientsUpdateHandler;
    }

    public RecipeCategoryBuilder<T> setDisplayedIngredientsUpdateHandler(DisplayedIngredientsUpdateHandler<T> displayedIngredientsUpdateHandler) {
        this.displayedIngredientsUpdateHandler = displayedIngredientsUpdateHandler;
        return this;
    }

    public RecipeCategoryBuilder<T> registryName(GetRegisterName<T> getRegisterName) {
        return this.setGetRegisterName(getRegisterName);
    }

    public InputHandler<T> getInputHandler() {
        return this.inputHandler;
    }

    public RecipeCategoryBuilder<T> setGetRegisterName(GetRegisterName<T> getRegisterName) {
        this.getRegisterName = getRegisterName;
        return this;
    }

    public IsRecipeHandledByCategory<T> getIsRecipeHandledByCategory() {
        return this.isRecipeHandledByCategory;
    }

    public RecipeCategoryBuilder<T> isRecipeHandled(IsRecipeHandledByCategory<T> isRecipeHandledByCategory) {
        return this.setIsRecipeHandledByCategory(isRecipeHandledByCategory);
    }

    public GetRegisterName<T> getGetRegisterName() {
        return this.getRegisterName;
    }

    public RecipeCategoryBuilder<T> setIsRecipeHandledByCategory(IsRecipeHandledByCategory<T> isRecipeHandledByCategory) {
        this.isRecipeHandledByCategory = isRecipeHandledByCategory;
        return this;
    }

    public RecipeCategoryBuilder<T> onInput(InputHandler<T> inputHandler) {
        return this.setInputHandler(inputHandler);
    }

    public RecipeCategoryBuilder<T> setInputHandler(InputHandler<T> inputHandler) {
        this.inputHandler = inputHandler;
        return this;
    }

    public RecipeCategoryBuilder<T> withTooltip(TooltipStringsHandler<T> tooltipStringsHandler) {
        return this.setTooltipHandler(tooltipStringsHandler);
    }

    public RecipeCategoryBuilder<T> setTooltipHandler(TooltipStringsHandler<T> tooltipStringsHandler) {
        this.tooltipStringsHandler = tooltipStringsHandler;
        return this;
    }

    public RecipeCategoryBuilder<T> handleLookup(SetRecipeHandler<T> recipeHandler) {
        return this.setSetRecipeHandler(recipeHandler);
    }

    public RecipeCategoryBuilder<T> setSetRecipeHandler(SetRecipeHandler<T> setRecipeHandler) {
        this.setRecipeHandler = setRecipeHandler;
        return this;
    }

    public RecipeCategoryBuilder<T> createRecipeExtras(CreateRecipeExtrasHandler<T> createRecipeExtrasHandler) {
        return this.setCreateRecipeExtrasHandler(createRecipeExtrasHandler);
    }

    public RecipeCategoryBuilder<T> setCreateRecipeExtrasHandler(CreateRecipeExtrasHandler<T> setRecipeExtrasHandler) {
        this.createRecipeExtrasHandler = setRecipeExtrasHandler;
        return this;
    }

    public RecipeCategoryBuilder<T> onDisplayedIngredientsUpdate(DisplayedIngredientsUpdateHandler<T> displayedIngredientsUpdateHandler) {
        this.displayedIngredientsUpdateHandler = displayedIngredientsUpdateHandler;
        return this;
    }

    @FunctionalInterface
    public static interface SetRecipeHandler<T> {
        public void setRecipe(IRecipeLayoutBuilder var1, T var2, IFocusGroup var3);
    }

    @FunctionalInterface
    public static interface DrawHandler<T> {
        public void draw(T var1, IRecipeSlotsView var2, GuiGraphics var3, double var4, double var6);
    }

    @FunctionalInterface
    public static interface CreateRecipeExtrasHandler<T> {
        public void createRecipeExtras(IRecipeExtrasBuilder var1, T var2, IFocusGroup var3);
    }

    @FunctionalInterface
    public static interface TooltipStringsHandler<T> {
        @Deprecated(since="15.8.4", forRemoval=true)
        @NotNull
        public List<Component> getTooltipStrings(T var1, IRecipeSlotsView var2, double var3, double var5);
    }

    @FunctionalInterface
    public static interface GetTooltipHandler<T> {
        public void getTooltip(ITooltipBuilder var1, T var2, IRecipeSlotsView var3, double var4, double var6);
    }

    @FunctionalInterface
    public static interface DisplayedIngredientsUpdateHandler<T> {
        public void onDisplayedIngredientsUpdate(T var1, List<IRecipeSlotDrawable> var2, IFocusGroup var3);
    }

    @FunctionalInterface
    public static interface GetRegisterName<T> {
        @Nullable
        public ResourceLocation getRegistryName(T var1);
    }

    @FunctionalInterface
    public static interface InputHandler<T> {
        public boolean handleInput(T var1, double var2, double var4, InputConstants.Key var6);
    }

    @FunctionalInterface
    public static interface IsRecipeHandledByCategory<T> {
        public boolean isHandled(T var1);
    }
}

