/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextPillar;
import team.chisel.ctm.client.texture.render.AbstractTexture;
import team.chisel.ctm.client.texture.type.TextureTypePillar;
import team.chisel.ctm.client.util.DirectionHelper;
import team.chisel.ctm.client.util.Quad;
import team.chisel.ctm.client.util.Submap;

public class TexturePillar
extends AbstractTexture<TextureTypePillar> {
    public TexturePillar(TextureTypePillar type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, ITextureContext context, int quadGoal) {
        if (context == null) {
            if (quad.m_111306_() != null && quad.m_111306_().m_122434_().m_122478_()) {
                return Lists.newArrayList((Object[])new BakedQuad[]{this.makeQuad(quad, context).transformUVs(this.sprites[0]).rebake()});
            }
            return Lists.newArrayList((Object[])new BakedQuad[]{this.makeQuad(quad, context).transformUVs(this.sprites[1], Submap.X2[0][0]).rebake()});
        }
        return Lists.newArrayList((Object[])new BakedQuad[]{this.getQuad(quad, context)});
    }

    @Override
    protected Quad makeQuad(BakedQuad bq, ITextureContext context) {
        return super.makeQuad(bq, context).derotate();
    }

    private BakedQuad getQuad(BakedQuad in, ITextureContext context) {
        boolean connected;
        Quad q = this.makeQuad(in, context);
        TextureContextPillar.ConnectionData data = ((TextureContextPillar)context).getData();
        TextureContextPillar.Connections cons = data.getConnections();
        EnumSet<Direction> realConnections = EnumSet.copyOf(data.getConnections().getConnections());
        if (cons.connectedOr(Direction.UP, Direction.DOWN)) {
            realConnections.removeIf(f -> f.m_122434_().m_122479_());
        } else if (cons.connectedOr(Direction.EAST, Direction.WEST)) {
            realConnections.removeIf(f -> f == Direction.NORTH || f == Direction.SOUTH);
            realConnections.removeIf(f -> this.blockConnectionZ((Direction)f, data));
        } else {
            realConnections.removeIf(f -> this.blockConnectionY((Direction)f, data));
        }
        cons = new TextureContextPillar.Connections(realConnections);
        int rotation = 0;
        ISubmap uvs = Submap.X2[0][0];
        if (in.m_111306_().m_122434_().m_122479_() && cons.connectedOr(Direction.UP, Direction.DOWN)) {
            uvs = this.getUVs(Direction.UP, Direction.DOWN, cons);
        } else if (cons.connectedOr(Direction.EAST, Direction.WEST)) {
            rotation = 1;
            uvs = this.getUVs(Direction.EAST, Direction.WEST, cons);
        } else if (cons.connectedOr(Direction.NORTH, Direction.SOUTH)) {
            uvs = this.getUVs(Direction.NORTH, Direction.SOUTH, cons);
            if (in.m_111306_() == Direction.DOWN) {
                rotation += 2;
            }
        }
        boolean bl = connected = !cons.getConnections().isEmpty();
        if (connected && !cons.connectedOr(Direction.UP, Direction.DOWN)) {
            if (in.m_111306_() == Direction.EAST) {
                ++rotation;
            }
            if (in.m_111306_() == Direction.NORTH) {
                rotation += 2;
            }
            if (in.m_111306_() == Direction.WEST) {
                rotation += 3;
            }
        }
        if (cons.connected(in.m_111306_().m_122424_())) {
            connected = false;
        }
        if (cons.getConnections().isEmpty() && in.m_111306_().m_122434_().m_122479_()) {
            connected = true;
        }
        q = q.rotate(rotation);
        if (connected) {
            return q.transformUVs(this.sprites[1], uvs).rebake();
        }
        return q.transformUVs(this.sprites[0]).rebake();
    }

    private ISubmap getUVs(Direction face1, Direction face2, TextureContextPillar.Connections cons) {
        ISubmap uvs = cons.connectedAnd(face1, face2) ? Submap.X2[1][0] : (cons.connected(face1) ? Submap.X2[1][1] : Submap.X2[0][1]);
        return uvs;
    }

    private boolean blockConnectionY(Direction dir, TextureContextPillar.ConnectionData data) {
        return this.blockConnection(dir, Direction.Axis.Y, data) || this.blockConnection(dir, dir.m_122427_().m_122434_(), data);
    }

    private boolean blockConnectionZ(Direction dir, TextureContextPillar.ConnectionData data) {
        return this.blockConnection(dir, Direction.Axis.Z, data);
    }

    private boolean blockConnection(Direction dir, Direction.Axis axis, TextureContextPillar.ConnectionData data) {
        Direction rot = DirectionHelper.rotateAround(dir, axis);
        return data.getConnections(dir).connectedOr(rot, rot.m_122424_());
    }
}

