/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.render.ContraptionRenderInfo;
import dev.engine_room.flywheel.api.event.ReloadLevelRendererEvent;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.createmod.catnip.data.WorldAttached;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ContraptionRenderInfoManager {
    static final WorldAttached<ContraptionRenderInfoManager> MANAGERS = new WorldAttached(ContraptionRenderInfoManager::new);
    private final Level level;
    private final Int2ObjectMap<ContraptionRenderInfo> renderInfos = new Int2ObjectOpenHashMap();
    private int removalTimer;

    private ContraptionRenderInfoManager(LevelAccessor level) {
        this.level = (Level)level;
    }

    public static void tickFor(Level level) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        ((ContraptionRenderInfoManager)MANAGERS.get((LevelAccessor)level)).tick();
    }

    public static void resetAll() {
        MANAGERS.empty(ContraptionRenderInfoManager::delete);
    }

    @SubscribeEvent
    public static void onReloadLevelRenderer(ReloadLevelRendererEvent event) {
        ContraptionRenderInfoManager.resetAll();
    }

    ContraptionRenderInfo getRenderInfo(Contraption contraption) {
        int entityId = contraption.entity.m_19879_();
        ContraptionRenderInfo renderInfo = (ContraptionRenderInfo)this.renderInfos.get(entityId);
        if (renderInfo == null) {
            renderInfo = new ContraptionRenderInfo(this.level, contraption);
            this.renderInfos.put(entityId, (Object)renderInfo);
        }
        return renderInfo;
    }

    boolean invalidate(Contraption contraption) {
        int entityId = contraption.entity.m_19879_();
        ContraptionRenderInfo renderInfo = (ContraptionRenderInfo)this.renderInfos.remove(entityId);
        if (renderInfo != null) {
            renderInfo.invalidate();
            return true;
        }
        return false;
    }

    private void tick() {
        if (this.removalTimer >= 20) {
            this.renderInfos.values().removeIf(ContraptionRenderInfo::isDead);
            this.removalTimer = 0;
        }
        ++this.removalTimer;
    }

    private void delete() {
        for (ContraptionRenderInfo renderer : this.renderInfos.values()) {
            renderer.invalidate();
        }
        this.renderInfos.clear();
    }
}

