/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.containers.MinecartUnLoaderContainer;
import com.alc.moreminecarts.entities.ChunkLoaderCartEntity;
import com.alc.moreminecarts.registry.MMTileEntities;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class MinecartUnloaderTile
extends AbstractCommonLoader {
    public MinecartUnloaderTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)MMTileEntities.MINECART_UNLOADER_TILE_ENTITY.get(), pos, state);
        this.last_redstone_output = !this.redstone_output;
    }

    @Override
    public boolean getIsUnloader() {
        return true;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        this.m_6596_();
        return new MinecartUnLoaderContainer(i, inventory, this, this.dataAccess, this.m_58899_());
    }

    protected AbstractContainerMenu m_6555_(int p_213906_1_, Inventory p_213906_2_) {
        return null;
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (!this.isOnCooldown()) {
                int new_comparator_output_value;
                List<AbstractMinecart> minecarts = this.getLoadableMinecartsInRange();
                float criteria_total = 0.0f;
                for (AbstractMinecart minecart : minecarts) {
                    LazyOptional tankCapability = minecart.getCapability(ForgeCapabilities.FLUID_HANDLER);
                    LazyOptional energyCapability = minecart.getCapability(ForgeCapabilities.ENERGY);
                    if (tankCapability.isPresent()) {
                        IFluidHandler fluid_handler = (IFluidHandler)tankCapability.orElse(null);
                        criteria_total += this.doFluidUnloads(fluid_handler);
                        continue;
                    }
                    if (energyCapability.isPresent()) {
                        IEnergyStorage energy_storage = (IEnergyStorage)energyCapability.orElse(null);
                        criteria_total += this.doElectricUnloads(energy_storage);
                        continue;
                    }
                    if (!(minecart instanceof AbstractMinecartContainer) || minecart instanceof ChunkLoaderCartEntity) continue;
                    criteria_total += this.doMinecartUnloads((AbstractMinecartContainer)minecart);
                }
                criteria_total = minecarts.size() == 0 ? 0.0f : (criteria_total /= (float)minecarts.size());
                if (this.comparator_output != AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
                    criteria_total = (float)Math.floor(criteria_total);
                }
                if ((new_comparator_output_value = (int)(criteria_total * 15.0f)) != this.comparator_output_value || this.last_redstone_output != this.redstone_output) {
                    this.comparator_output_value = new_comparator_output_value;
                    this.last_redstone_output = this.redstone_output;
                    this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
                    this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
                }
                if (this.changed_flag) {
                    this.m_6596_();
                    this.changed_flag = false;
                }
            } else {
                this.decCooldown();
            }
        }
    }

    public float doFluidUnloads(IFluidHandler minecart_handler) {
        boolean changed = false;
        boolean all_empty = true;
        IFluidHandler our_fluid_handler = (IFluidHandler)this.fluid_handler.orElse(null);
        FluidStack our_fluid_stack = our_fluid_handler.getFluidInTank(0);
        float fluid_content_proportion = 0.0f;
        for (int i = 0; i < minecart_handler.getTanks(); ++i) {
            if (minecart_handler.getTankCapacity(i) > 0) {
                fluid_content_proportion += (float)minecart_handler.getFluidInTank(i).getAmount() / (float)minecart_handler.getTankCapacity(i);
            }
            boolean did_load = false;
            FluidStack take_stack = minecart_handler.getFluidInTank(i);
            if (take_stack.isEmpty() || this.leave_one_in_stack && take_stack.getAmount() == 1) continue;
            all_empty = false;
            if (our_fluid_stack.getAmount() == FLUID_CAPACITY) continue;
            if (our_fluid_handler.isFluidValid(i, take_stack)) {
                if (our_fluid_stack.isEmpty()) {
                    FluidStack new_stack = take_stack.copy();
                    int transfer_amount = Math.min(1000, new_stack.getAmount());
                    new_stack.setAmount(transfer_amount);
                    our_fluid_handler.fill(new_stack, IFluidHandler.FluidAction.EXECUTE);
                    take_stack.shrink(transfer_amount);
                    did_load = true;
                } else if (our_fluid_stack.isFluidEqual(take_stack)) {
                    int true_count = take_stack.getAmount() - (this.leave_one_in_stack ? 1 : 0);
                    int to_fill = our_fluid_handler.getTankCapacity(i) - our_fluid_stack.getAmount();
                    int transfer = Math.min(1000, Math.min(true_count, to_fill));
                    our_fluid_stack.grow(transfer);
                    minecart_handler.drain(transfer, IFluidHandler.FluidAction.EXECUTE);
                    boolean bl = did_load = transfer > 0;
                }
            }
            if (!did_load) continue;
            changed = true;
            break;
        }
        if (minecart_handler.getTanks() > 0) {
            fluid_content_proportion /= (float)minecart_handler.getTanks();
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            return all_empty ? 1.0f : 0.0f;
        }
        return fluid_content_proportion;
    }

    public float doElectricUnloads(IEnergyStorage minecart_handler) {
        boolean changed = false;
        IEnergyStorage our_handler = (IEnergyStorage)this.energy_handler.orElse(null);
        if (minecart_handler.canReceive()) {
            int true_count = minecart_handler.getEnergyStored() - (this.leave_one_in_stack ? 1 : 0);
            int to_fill = our_handler.getMaxEnergyStored() - our_handler.getEnergyStored();
            int transfer = Math.min(1000, Math.min(true_count, to_fill));
            our_handler.receiveEnergy(transfer, false);
            minecart_handler.extractEnergy(transfer, false);
            boolean bl = changed = transfer > 0;
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            return minecart_handler.getEnergyStored() <= (this.leave_one_in_stack ? 1 : 0) ? 1.0f : 0.0f;
        }
        return (float)minecart_handler.getEnergyStored() / (float)minecart_handler.getMaxEnergyStored();
    }

    public float doMinecartUnloads(AbstractMinecartContainer minecart) {
        boolean changed = false;
        boolean all_empty = true;
        block0: for (int i = 0; i < minecart.m_6643_(); ++i) {
            ItemStack stack = minecart.m_8020_(i);
            if (stack.m_41619_() || this.leave_one_in_stack && stack.m_41613_() == 1) continue;
            all_empty = false;
            for (int j = 0; j < this.m_6643_(); ++j) {
                ItemStack add_to_stack = this.m_8020_(j);
                boolean did_load = false;
                if (add_to_stack.m_41619_()) {
                    true_count = stack.m_41613_() - (this.leave_one_in_stack ? 1 : 0);
                    ItemStack new_stack = stack.m_41777_();
                    int transfer_amount = Math.min(8, true_count);
                    new_stack.m_41764_(transfer_amount);
                    this.m_6836_(j, new_stack);
                    stack.m_41774_(transfer_amount);
                    did_load = true;
                } else if (MinecartUnloaderTile.canMergeItems(add_to_stack, stack)) {
                    true_count = stack.m_41613_() - (this.leave_one_in_stack ? 1 : 0);
                    int to_fill = add_to_stack.m_41741_() - add_to_stack.m_41613_();
                    int transfer = Math.min(8, Math.min(true_count, to_fill));
                    stack.m_41774_(transfer);
                    add_to_stack.m_41769_(transfer);
                    boolean bl = did_load = transfer > 0;
                }
                if (!did_load) continue;
                changed = true;
                continue block0;
            }
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            return all_empty ? 1.0f : 0.0f;
        }
        if (minecart instanceof ChunkLoaderCartEntity && this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
            return (float)((ChunkLoaderCartEntity)minecart).getComparatorSignal() / 15.0f;
        }
        return (float)AbstractContainerMenu.m_38938_((Container)minecart) / 15.0f;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"Minecart Unloader");
    }

    public static void doTick(Level level, BlockPos pos, BlockState state, MinecartUnloaderTile ent) {
        ent.tick();
    }
}

