/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.tile_entities;

import com.alc.moreminecarts.containers.FilterUnloaderContainer;
import com.alc.moreminecarts.entities.ChunkLoaderCartEntity;
import com.alc.moreminecarts.registry.MMTileEntities;
import com.alc.moreminecarts.tile_entities.AbstractCommonLoader;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class FilterUnloaderTile
extends AbstractCommonLoader
implements WorldlyContainer {
    public static int VALID_ITEM_SLOTS = 9;
    public static final int[] VALID_TAKE_SLOTS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.NORTH});

    public FilterUnloaderTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)MMTileEntities.FILTER_UNLOADER_TILE_ENTITY.get(), pos, state);
        this.last_redstone_output = !this.redstone_output;
    }

    @Override
    public boolean getIsUnloader() {
        return true;
    }

    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        this.m_6596_();
        return new FilterUnloaderContainer(i, inventory, this, this.dataAccess, this.m_58899_());
    }

    protected AbstractContainerMenu m_6555_(int p_213906_1_, Inventory p_213906_2_) {
        return null;
    }

    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (!this.isOnCooldown()) {
                int new_comparator_output_value;
                List<AbstractMinecart> minecarts = this.getLoadableMinecartsInRange();
                float criteria_total = 0.0f;
                for (AbstractMinecart minecart : minecarts) {
                    if (!(minecart instanceof AbstractMinecartContainer) || minecart instanceof ChunkLoaderCartEntity) continue;
                    criteria_total += this.doMinecartUnloads((AbstractMinecartContainer)minecart);
                }
                criteria_total = minecarts.size() == 0 ? 0.0f : (criteria_total /= (float)minecarts.size());
                if (this.comparator_output != AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
                    criteria_total = (float)Math.floor(criteria_total);
                }
                if ((new_comparator_output_value = (int)(criteria_total * 15.0f)) != this.comparator_output_value || this.last_redstone_output != this.redstone_output) {
                    this.comparator_output_value = new_comparator_output_value;
                    this.last_redstone_output = this.redstone_output;
                    this.f_58857_.m_46717_(this.m_58899_(), this.m_58900_().m_60734_());
                    this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
                }
                if (this.changed_flag) {
                    this.m_6596_();
                    this.changed_flag = false;
                }
            } else {
                this.decCooldown();
            }
        }
    }

    public float doMinecartUnloads(AbstractMinecartContainer minecart) {
        boolean changed = false;
        boolean all_empty = true;
        block0: for (int i = 0; i < minecart.m_6643_(); ++i) {
            ItemStack unloadingStack = minecart.m_8020_(i);
            if (unloadingStack.m_41619_() || this.leave_one_in_stack && unloadingStack.m_41613_() == 1) continue;
            all_empty = false;
            for (int j = 0; j < VALID_ITEM_SLOTS; ++j) {
                ItemStack add_to_stack = this.m_8020_(j);
                if (this.filterType == FilterType.allow_per_slot) {
                    ItemStack check_stack = this.m_8020_(j + VALID_ITEM_SLOTS);
                    if (!check_stack.m_41619_() && !this.itemsMatch(check_stack, unloadingStack)) {
                        continue;
                    }
                } else {
                    boolean matchesAny = false;
                    for (int k = VALID_ITEM_SLOTS; k < VALID_ITEM_SLOTS * 2; ++k) {
                        ItemStack check_stack = this.m_8020_(k);
                        if (check_stack.m_41619_() || !this.itemsMatch(check_stack, unloadingStack)) continue;
                        matchesAny = true;
                        break;
                    }
                    if (matchesAny != (this.filterType == FilterType.allow_for_all)) continue;
                }
                boolean did_load = false;
                if (add_to_stack.m_41619_()) {
                    true_count = unloadingStack.m_41613_() - (this.leave_one_in_stack ? 1 : 0);
                    ItemStack new_stack = unloadingStack.m_41777_();
                    int transfer_amount = Math.min(8, true_count);
                    new_stack.m_41764_(transfer_amount);
                    this.m_6836_(j, new_stack);
                    unloadingStack.m_41774_(transfer_amount);
                    did_load = true;
                } else if (FilterUnloaderTile.canMergeItems(add_to_stack, unloadingStack)) {
                    true_count = unloadingStack.m_41613_() - (this.leave_one_in_stack ? 1 : 0);
                    int to_fill = add_to_stack.m_41741_() - add_to_stack.m_41613_();
                    int transfer = Math.min(8, Math.min(true_count, to_fill));
                    unloadingStack.m_41774_(transfer);
                    add_to_stack.m_41769_(transfer);
                    boolean bl = did_load = transfer > 0;
                }
                if (!did_load) continue;
                changed = true;
                continue block0;
            }
        }
        if (changed) {
            this.resetCooldown();
            this.changed_flag = true;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.done_loading) {
            return changed ? 0.0f : 1.0f;
        }
        if (this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_full) {
            return all_empty ? 1.0f : 0.0f;
        }
        if (minecart instanceof ChunkLoaderCartEntity && this.comparator_output == AbstractCommonLoader.ComparatorOutputType.cart_fullness) {
            return (float)((ChunkLoaderCartEntity)minecart).getComparatorSignal() / 15.0f;
        }
        return (float)AbstractContainerMenu.m_38938_((Container)minecart) / 15.0f;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"Filtered Unloader");
    }

    public static void doTick(Level level, BlockPos pos, BlockState state, FilterUnloaderTile ent) {
        ent.tick();
    }

    @Override
    public boolean m_7155_(int slot, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return false;
    }

    @Override
    public int[] m_7071_(Direction p_58363_) {
        return VALID_TAKE_SLOTS;
    }

    @Override
    public int getSlotCount() {
        return 18;
    }

    public boolean itemsMatch(ItemStack a, ItemStack b) {
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    @Override
    public boolean m_7157_(int p_58392_, ItemStack p_58393_, Direction p_58394_) {
        return p_58392_ < VALID_ITEM_SLOTS;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers[0].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.NORTH});
    }

    public static enum FilterType {
        allow_per_slot,
        allow_for_all,
        disallow_for_all;


        public int toInt() {
            switch (this) {
                case allow_per_slot: {
                    return 0;
                }
                case allow_for_all: {
                    return 1;
                }
                case disallow_for_all: {
                    return 2;
                }
            }
            return 3;
        }

        public static FilterType next(FilterType in) {
            switch (in) {
                case allow_per_slot: {
                    return allow_for_all;
                }
                case allow_for_all: {
                    return disallow_for_all;
                }
                case disallow_for_all: {
                    return allow_per_slot;
                }
            }
            return allow_per_slot;
        }

        public static FilterType fromInt(int n) {
            if (n == 0) {
                return allow_per_slot;
            }
            if (n == 1) {
                return allow_for_all;
            }
            return disallow_for_all;
        }
    }
}

