/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.entities;

import com.alc.moreminecarts.blocks.OrbStasisBlock;
import com.alc.moreminecarts.registry.MMBlocks;
import com.alc.moreminecarts.registry.MMItems;
import com.alc.moreminecarts.tile_entities.OrbStasisTile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class OrbStasisCart
extends AbstractMinecart {
    private static final EntityDataAccessor<Boolean> HAS_ORB = SynchedEntityData.m_135353_(OrbStasisCart.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    public UUID owner_uuid;

    public OrbStasisCart(EntityType<?> type, Level world) {
        super(type, world);
    }

    public OrbStasisCart(EntityType<?> type, Level worldIn, double x, double y, double z) {
        super(type, worldIn, x, y, z);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public Item m_213728_() {
        return (Item)MMItems.MINECART_WITH_STASIS_ITEM.get();
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.attemptTeleport();
    }

    public void m_6025_(int p_96095_1_, int p_96095_2_, int p_96095_3_, boolean p_96095_4_) {
        if (p_96095_4_) {
            this.attemptTeleport();
        }
    }

    public InteractionResult m_6096_(Player playerEntity, InteractionHand hand) {
        InteractionResult ret = super.m_6096_(playerEntity, hand);
        if (ret.m_19077_()) {
            return ret;
        }
        if (this.getHasOrb()) {
            return InteractionResult.PASS;
        }
        ItemStack item_used = playerEntity.m_21120_(hand);
        if (item_used.m_41720_() == Items.f_42584_) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (this.owner_uuid == null) {
                this.addPearl(playerEntity);
                if (!playerEntity.m_7500_()) {
                    item_used.m_41774_(1);
                }
            }
        }
        return InteractionResult.PASS;
    }

    protected void addPearl(Player player) {
        this.owner_uuid = player.m_36316_().getId();
        this.setHasOrb(true);
    }

    protected void attemptTeleport() {
        if (this.m_9236_().f_46443_ || this.owner_uuid == null) {
            return;
        }
        Player entity = this.m_9236_().m_46003_(this.owner_uuid);
        if (entity instanceof ServerPlayer) {
            EntityTeleportEvent.ChorusFruit event;
            ServerPlayer player = (ServerPlayer)entity;
            if (player.f_8906_.f_9742_.m_129536_() && player.m_9236_() == this.m_9236_() && !player.m_5803_() && !MinecraftForge.EVENT_BUS.post((Event)(event = new EntityTeleportEvent.ChorusFruit((LivingEntity)player, this.m_20185_() + 0.5, this.m_20186_() + 1.0, this.m_20189_() + 0.5)))) {
                if (this.m_9236_().f_46441_.m_188501_() < 0.05f && this.m_9236_().m_46469_().m_46207_(GameRules.f_46134_)) {
                    Endermite endermiteentity = (Endermite)EntityType.f_20567_.m_20615_(this.m_9236_());
                    endermiteentity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                    this.m_9236_().m_7967_((Entity)endermiteentity);
                }
                if (entity.m_20159_()) {
                    entity.m_8127_();
                }
                entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                entity.f_19789_ = 0.0f;
                entity.m_6469_(this.m_9236_().m_269111_().m_268989_(), 5.0f);
            }
        }
        this.owner_uuid = null;
        this.setHasOrb(false);
    }

    public BlockState m_6390_() {
        BlockState blockState = this.m_9236_().m_8055_(this.m_20183_());
        boolean is_activated = blockState.m_60713_(Blocks.f_50285_) && (Boolean)blockState.m_61143_((Property)PoweredRailBlock.f_55215_) != false;
        return (BlockState)((BlockState)((Block)MMBlocks.PEARL_STASIS_CHAMBER.get()).m_49966_().m_61124_((Property)OrbStasisBlock.CONTAINS_PEARL, (Comparable)Boolean.valueOf(this.getHasOrb()))).m_61124_((Property)OrbStasisBlock.POWERED, (Comparable)Boolean.valueOf(is_activated));
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.owner_uuid != null) {
            compound.m_128362_(OrbStasisTile.PLAYER_UUID_PROPERTY, this.owner_uuid);
        }
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_(OrbStasisTile.PLAYER_UUID_PROPERTY)) {
            this.owner_uuid = compound.m_128342_(OrbStasisTile.PLAYER_UUID_PROPERTY);
        }
        this.setHasOrb(this.owner_uuid != null);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_ORB, (Object)false);
    }

    protected boolean getHasOrb() {
        return (Boolean)this.f_19804_.m_135370_(HAS_ORB);
    }

    protected void setHasOrb(boolean powered) {
        this.f_19804_.m_135381_(HAS_ORB, (Object)powered);
    }
}

