/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.rei;

import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.integration.rei.MBDRecipeTypeDisplayCategory;
import com.lowdragmc.mbd2.integration.rei.MBDRecipeTypeFuelDisplayCategory;
import com.lowdragmc.mbd2.integration.rei.MultiblockInfoDisplayCategory;
import javax.annotation.ParametersAreNonnullByDefault;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.forge.REIPluginClient;
import net.minecraft.MethodsReturnNonnullByDefault;

@REIPluginClient
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MBDREIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new MultiblockInfoDisplayCategory());
        MBD2.LOGGER.info("REI register categories");
        for (MBDRecipeType recipeType : MBDRegistries.RECIPE_TYPES) {
            if (!recipeType.isXEIVisible()) continue;
            registry.add((DisplayCategory)new MBDRecipeTypeDisplayCategory(recipeType));
            if (!recipeType.isRequireFuelForWorking()) continue;
            registry.add((DisplayCategory)new MBDRecipeTypeFuelDisplayCategory(recipeType));
        }
        MBDRecipeTypeDisplayCategory.registerWorkStations(registry);
        MBDRecipeTypeFuelDisplayCategory.registerWorkStations(registry);
        MultiblockInfoDisplayCategory.registerWorkStations(registry);
    }

    public void registerDisplays(DisplayRegistry registry) {
        MBD2.LOGGER.info("REI register displays");
        MBDRecipeTypeDisplayCategory.registerDisplays(registry);
        MBDRecipeTypeFuelDisplayCategory.registerDisplays(registry);
        MultiblockInfoDisplayCategory.registerDisplays(registry);
    }
}

