/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft;

import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerDouble;
import com.lowdragmc.mbd2.common.gui.recipe.CornerNumberWidget;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class PNCHeatRecipeCapability
extends RecipeCapability<Double> {
    public static final PNCHeatRecipeCapability CAP = new PNCHeatRecipeCapability();
    public static final ResourceTexture HUD_BACKGROUND = new ResourceTexture("mbd2:textures/gui/heat_background.png");
    public static final ResourceTexture HUD_BAR = new ResourceTexture("mbd2:textures/gui/heat_hud.png");

    protected PNCHeatRecipeCapability() {
        super("pneumatic_heat", SerializerDouble.INSTANCE);
    }

    @Override
    public Double createDefaultContent() {
        return 10.0;
    }

    @Override
    public Widget createPreviewWidget(Double content) {
        WidgetGroup previewGroup = new WidgetGroup(0, 0, 18, 18);
        previewGroup.addWidget((Widget)new ImageWidget(1, 1, 16, 16, (IGuiTexture)new ItemStackTexture(new Item[]{(Item)ModItems.HEAT_FRAME.get()})));
        previewGroup.addWidget((Widget)new CornerNumberWidget(0, 0, 18, 18).setValue(content.longValue()));
        return previewGroup;
    }

    @Override
    public Widget createXEITemplate() {
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 10, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)HUD_BAR.copy()));
        energyBar.setBackground(new IGuiTexture[]{HUD_BACKGROUND});
        energyBar.setOverlay((IGuiTexture)new TextTexture("0 heat"));
        return energyBar;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof ProgressWidget) {
            ProgressWidget energyBar = (ProgressWidget)widget;
            Double energy = (Double)this.of(content.content);
            IGuiTexture iGuiTexture = energyBar.getOverlay();
            if (iGuiTexture instanceof TextTexture) {
                TextTexture textTexture = (TextTexture)iGuiTexture;
                if (content.perTick) {
                    textTexture.updateText(energy + " heat/t");
                } else {
                    textTexture.updateText(energy + " heat");
                }
            }
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<Double> supplier, Consumer<Double> onUpdate) {
        Configurator[] configuratorArray = new Configurator[1];
        configuratorArray[0] = new NumberConfigurator("recipe.capability.pneumatic_heat.heat", supplier::get, number -> onUpdate.accept(number.doubleValue()), (Number)1, true).setRange((Number)1, (Number)Double.MAX_VALUE);
        father.addConfigurators(configuratorArray);
    }

    @Override
    public Component getLeftErrorInfo(List<Double> left) {
        return Component.m_237113_((String)(left.stream().mapToDouble(Double::doubleValue).sum() + " heat"));
    }
}

