/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.heat;

import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.integration.mekanism.MEKTemperatureCondition;
import com.lowdragmc.mbd2.integration.mekanism.MekanismHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.mekanism.trait.heat.CopiableHeatContainer;
import com.lowdragmc.mbd2.integration.mekanism.trait.heat.HeatContainerList;
import com.lowdragmc.mbd2.integration.mekanism.trait.heat.HeatContainerWrapper;
import com.lowdragmc.mbd2.integration.mekanism.trait.heat.MekHeatCapabilityTraitDefinition;
import java.util.List;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.Nullable;

public class MekHeatCapabilityTrait
extends SimpleCapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MekHeatCapabilityTrait.class);
    @Persisted
    @DescSynced
    public final CopiableHeatContainer container;
    private final HeatRecipeHandler recipeHandler = new HeatRecipeHandler();
    private final HeatHandlerCap heatHandlerCap = new HeatHandlerCap();
    private final CachedAmbientTemperature ambientTemperature = new CachedAmbientTemperature(() -> this.getMachine().getLevel(), () -> this.getMachine().getPos());

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public MekHeatCapabilityTrait(MBDMachine machine, MekHeatCapabilityTraitDefinition definition) {
        super(machine, definition);
        this.container = this.createStorages();
        this.container.setOnContentsChanged(this::notifyListeners);
    }

    @Override
    public MekHeatCapabilityTraitDefinition getDefinition() {
        return (MekHeatCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        this.container.handleHeat(this.container.capacity * 300.0);
    }

    protected CopiableHeatContainer createStorages() {
        return new CopiableHeatContainer(this.getDefinition().getCapacity(), this.getDefinition().getInverseConduction());
    }

    protected double getTotalInverseConductionCoefficient() {
        int heatCapacitorCount = this.container.getHeatCapacitorCount();
        if (heatCapacitorCount == 0) {
            return 1.0;
        }
        if (heatCapacitorCount == 1) {
            return this.container.getInverseConduction(0);
        }
        double sum = 0.0;
        double totalCapacity = this.container.getTotalHeatCapacity();
        for (int capacitor = 0; capacitor < heatCapacitorCount; ++capacitor) {
            sum += this.container.getInverseConduction(capacitor) * (this.container.getHeatCapacity(capacitor) / totalCapacity);
        }
        return sum;
    }

    @Override
    public void serverTick() {
        ToggleAutoIO autoIO;
        super.serverTick();
        if (this.getDefinition().isSimulateEnvironment()) {
            double heatCapacity = this.container.getTotalHeatCapacity();
            double invConduction = 10000.0 + this.getTotalInverseConductionCoefficient();
            double tempToTransfer = (this.container.getTotalTemperature() - 300.0) / invConduction;
            this.container.handleHeat(-tempToTransfer * heatCapacity);
        }
        if ((autoIO = this.getDefinition().getAutoIO()).isEnable() && this.getMachine().getOffsetTimer() % (long)autoIO.getInterval() == 0L) {
            Direction front = this.getMachine().getFrontFacing().orElse(Direction.NORTH);
            for (Direction side : EnumUtils.DIRECTIONS) {
                BlockEntity adj;
                IHeatHandler sink;
                IO io = autoIO.getIO(front, side);
                if (!io.support(IO.OUT) || (sink = (IHeatHandler)CapabilityUtils.getCapability((ICapabilityProvider)(adj = WorldUtils.getTileEntity((BlockGetter)this.getMachine().getLevel(), (BlockPos)this.getMachine().getPos().m_121945_(side))), (Capability)Capabilities.HEAT_HANDLER, (Direction)side.m_122424_()).resolve().orElse(null)) == null) continue;
                double heatCapacity = this.container.getTotalHeatCapacity();
                double invConduction = sink.getTotalInverseConduction() + this.getTotalInverseConductionCoefficient();
                double tempToTransfer = (this.container.getTotalTemperature() - this.ambientTemperature.getTemperature(side)) / invConduction;
                double heatToTransfer = tempToTransfer * heatCapacity;
                this.container.handleHeat(-heatToTransfer);
                sink.handleHeat(heatToTransfer);
            }
        }
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.recipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.heatHandlerCap);
    }

    public CopiableHeatContainer getContainer() {
        return this.container;
    }

    public HeatRecipeHandler getRecipeHandler() {
        return this.recipeHandler;
    }

    public HeatHandlerCap getHeatHandlerCap() {
        return this.heatHandlerCap;
    }

    public CachedAmbientTemperature getAmbientTemperature() {
        return this.ambientTemperature;
    }

    public class HeatRecipeHandler
    extends RecipeHandlerTrait<Double> {
        protected HeatRecipeHandler() {
            super(MekHeatCapabilityTrait.this, MekanismHeatRecipeCapability.CAP);
        }

        @Override
        public List<Double> handleRecipeInner(IO io, MBDRecipe recipe, List<Double> left, @Nullable String slotName, boolean simulate) {
            if (!this.compatibleWith(io)) {
                return left;
            }
            double required = left.stream().reduce(0.0, Double::sum);
            CopiableHeatContainer capability = simulate ? MekHeatCapabilityTrait.this.container.copy() : MekHeatCapabilityTrait.this.container;
            for (RecipeCondition condition : recipe.conditions) {
                if (!(condition instanceof MEKTemperatureCondition)) continue;
                MEKTemperatureCondition heatCondition = (MEKTemperatureCondition)condition;
                double temp = capability.getTemperature(0);
                if (!(heatCondition.getMinTemperature() > temp) && !(heatCondition.getMaxTemperature() < temp)) continue;
                return left;
            }
            if (io == IO.IN) {
                capability.handleHeat(-required);
            } else if (io == IO.OUT) {
                capability.handleHeat(required);
            }
            return null;
        }
    }

    public class HeatHandlerCap
    implements ICapabilityProviderTrait<IHeatHandler> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return MekHeatCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<IHeatHandler> getCapability() {
            return Capabilities.HEAT_HANDLER;
        }

        @Override
        public IHeatHandler getCapContent(IO capbilityIO) {
            return new HeatContainerWrapper(MekHeatCapabilityTrait.this.container, capbilityIO);
        }

        @Override
        public IHeatHandler mergeContents(List<IHeatHandler> contents) {
            return new HeatContainerList(contents.toArray(new IHeatHandler[0]));
        }
    }
}

