/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.chemical;

import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalStorage;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class ChemicalStorageWrapper<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IChemicalHandler<CHEMICAL, STACK> {
    private final STACK emptyStack;
    private final ChemicalStorage<CHEMICAL, STACK>[] storages;
    private final IO io;

    public ChemicalStorageWrapper(STACK emptyStack, ChemicalStorage<CHEMICAL, STACK>[] storages, IO io) {
        this.emptyStack = emptyStack;
        this.storages = storages;
        this.io = io;
    }

    public int getTanks() {
        return this.storages.length;
    }

    public STACK getChemicalInTank(int tank) {
        return (STACK)this.storages[tank].getStack();
    }

    public void setChemicalInTank(int tank, STACK stack) {
        this.storages[tank].setStack((ChemicalStack)stack);
    }

    public long getTankCapacity(int tank) {
        return this.storages[tank].getCapacity();
    }

    public boolean isValid(int tank, STACK stack) {
        return this.storages[tank].isValid((ChemicalStack)stack);
    }

    public STACK insertChemical(int tank, STACK stack, Action action) {
        if (this.io == IO.IN || this.io == IO.BOTH) {
            return (STACK)this.storages[tank].insertChemical((ChemicalStack)stack, action);
        }
        return stack;
    }

    public STACK extractChemical(int tank, long amount, Action action) {
        if (this.io == IO.OUT || this.io == IO.BOTH) {
            return (STACK)this.storages[tank].extractChemical(amount, action);
        }
        return this.emptyStack;
    }

    @NotNull
    public STACK getEmptyStack() {
        return this.emptyStack;
    }

    public static class Slurry
    extends ChemicalStorageWrapper<mekanism.api.chemical.slurry.Slurry, SlurryStack>
    implements ISlurryHandler {
        public Slurry(ChemicalStorage<mekanism.api.chemical.slurry.Slurry, SlurryStack>[] storages, IO io) {
            super(SlurryStack.EMPTY, storages, io);
        }
    }

    public static class Pigment
    extends ChemicalStorageWrapper<mekanism.api.chemical.pigment.Pigment, PigmentStack>
    implements IPigmentHandler {
        public Pigment(ChemicalStorage<mekanism.api.chemical.pigment.Pigment, PigmentStack>[] storages, IO io) {
            super(PigmentStack.EMPTY, storages, io);
        }
    }

    public static class Infuse
    extends ChemicalStorageWrapper<InfuseType, InfusionStack>
    implements IInfusionHandler {
        public Infuse(ChemicalStorage<InfuseType, InfusionStack>[] storages, IO io) {
            super(InfusionStack.EMPTY, storages, io);
        }
    }

    public static class Gas
    extends ChemicalStorageWrapper<mekanism.api.chemical.gas.Gas, GasStack>
    implements IGasHandler {
        public Gas(ChemicalStorage<mekanism.api.chemical.gas.Gas, GasStack>[] storages, IO io) {
            super(GasStack.EMPTY, storages, io);
        }
    }
}

