/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.api.recipe.content.IContentSerializer;
import com.lowdragmc.mbd2.integration.mekanism.ChemicalTankWidget;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.registration.impl.GasRegistryObject;
import mekanism.common.registration.impl.InfuseTypeRegistryObject;
import mekanism.common.registries.MekanismGases;
import mekanism.common.registries.MekanismInfuseTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public class MekanismChemicalRecipeCapability<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends RecipeCapability<STACK> {
    public static final MekanismChemicalRecipeCapability<Gas, GasStack> CAP_GAS = new MekanismChemicalRecipeCapability<Gas, GasStack>("mek_gas", MekanismAPI.EMPTY_GAS, () -> ((GasRegistryObject)MekanismGases.HYDROGEN).getChemical(), MekanismAPI::gasRegistry, GasStack::new, ChemicalTankBuilder.GAS, GasStack::readFromPacket, ChemicalTankWidget.Gas::new);
    public static final MekanismChemicalRecipeCapability<InfuseType, InfusionStack> CAP_INFUSE = new MekanismChemicalRecipeCapability<InfuseType, InfusionStack>("mek_infuse", MekanismAPI.EMPTY_INFUSE_TYPE, () -> ((InfuseTypeRegistryObject)MekanismInfuseTypes.DIAMOND).getChemical(), MekanismAPI::infuseTypeRegistry, InfusionStack::new, ChemicalTankBuilder.INFUSION, InfusionStack::readFromPacket, ChemicalTankWidget.Infuse::new);
    public static final MekanismChemicalRecipeCapability<Pigment, PigmentStack> CAP_PIGMENT = new MekanismChemicalRecipeCapability<Pigment, PigmentStack>("mek_pigment", MekanismAPI.EMPTY_PIGMENT, null, MekanismAPI::pigmentRegistry, PigmentStack::new, ChemicalTankBuilder.PIGMENT, PigmentStack::readFromPacket, ChemicalTankWidget.Pigment::new);
    public static final MekanismChemicalRecipeCapability<Slurry, SlurryStack> CAP_SLURRY = new MekanismChemicalRecipeCapability<Slurry, SlurryStack>("mek_slurry", MekanismAPI.EMPTY_SLURRY, null, MekanismAPI::slurryRegistry, SlurryStack::new, ChemicalTankBuilder.SLURRY, SlurryStack::readFromPacket, ChemicalTankWidget.Slurry::new);
    public final CHEMICAL empty;
    @Nullable
    public final Supplier<CHEMICAL> defaultChemical;
    public final Supplier<IForgeRegistry<CHEMICAL>> registry;
    public final BiFunction<CHEMICAL, Long, STACK> createStack;
    public final ChemicalTankBuilder<CHEMICAL, STACK, ? extends IChemicalTank<CHEMICAL, STACK>> tankBuilder;
    public final Supplier<ChemicalTankWidget<CHEMICAL, STACK>> createTankWidget;

    protected MekanismChemicalRecipeCapability(String name, CHEMICAL empty, @Nullable Supplier<CHEMICAL> defaultChemical, Supplier<IForgeRegistry<CHEMICAL>> registry, BiFunction<CHEMICAL, Long, STACK> createStack, ChemicalTankBuilder<CHEMICAL, STACK, ? extends IChemicalTank<CHEMICAL, STACK>> tankBuilder, Function<FriendlyByteBuf, STACK> readFromBuffer, Supplier<ChemicalTankWidget<CHEMICAL, STACK>> createTankWidget) {
        super(name, new ChemicalStackIContentSerializer<CHEMICAL, STACK>(readFromBuffer, empty, registry, createStack));
        this.empty = empty;
        this.defaultChemical = defaultChemical;
        this.registry = registry;
        this.createStack = createStack;
        this.tankBuilder = tankBuilder;
        this.createTankWidget = createTankWidget;
    }

    public CHEMICAL createDefaultChemical() {
        return (CHEMICAL)(this.defaultChemical == null ? (Chemical)this.registry.get().getValues().stream().findAny().orElse(this.empty) : (Chemical)this.defaultChemical.get());
    }

    @Override
    public STACK createDefaultContent() {
        return (STACK)((ChemicalStack)this.createStack.apply(this.createDefaultChemical(), 1000L));
    }

    @Override
    public Widget createPreviewWidget(STACK content) {
        WidgetGroup previewGroup = new WidgetGroup(0, 0, 18, 18);
        ChemicalTankWidget<CHEMICAL, STACK> tankWidget = this.createTankWidget.get();
        ChemicalStack ingredient = (ChemicalStack)this.of(content);
        IChemicalTank iChemicalTank = this.tankBuilder.create(ingredient.getAmount(), null);
        if (iChemicalTank instanceof IChemicalHandler) {
            IChemicalHandler handler = (IChemicalHandler)iChemicalTank;
            handler.insertChemical(ingredient, Action.EXECUTE);
            tankWidget.setChemicalTank(handler, 0);
        }
        previewGroup.addWidget(tankWidget);
        return previewGroup;
    }

    @Override
    public Widget createXEITemplate() {
        ChemicalTankWidget<CHEMICAL, STACK> tankWidget = this.createTankWidget.get();
        tankWidget.initTemplate();
        tankWidget.setSize(new Size(20, 58));
        tankWidget.setOverlay((IGuiTexture)new ResourceTexture("mbd2:textures/gui/fluid_tank_overlay.png"));
        tankWidget.setShowAmount(false);
        return tankWidget;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof ChemicalTankWidget) {
            ChemicalTankWidget tankWidget = (ChemicalTankWidget)widget;
            ChemicalStack ingredient = (ChemicalStack)this.of(content.content);
            IChemicalTank iChemicalTank = this.tankBuilder.create(ingredient.getAmount(), null);
            if (iChemicalTank instanceof IChemicalHandler) {
                IChemicalHandler handler = (IChemicalHandler)iChemicalTank;
                handler.insertChemical(ingredient, Action.EXECUTE);
                tankWidget.setChemicalTank(handler, 0);
            }
            if (tankWidget.getOverlay() == null || tankWidget.getOverlay() == IGuiTexture.EMPTY) {
                tankWidget.setOverlay(content.createOverlay());
            } else {
                GuiTextureGroup groupTexture = new GuiTextureGroup(new IGuiTexture[]{tankWidget.getOverlay(), content.createOverlay()});
                tankWidget.setOverlay((IGuiTexture)groupTexture);
            }
            tankWidget.setIngredientIO(ingredientIO);
            tankWidget.setAllowClickDrained(false);
            tankWidget.setAllowClickFilled(false);
            tankWidget.setXEIChance(content.chance);
        }
    }

    @Override
    public Component getLeftErrorInfo(List<STACK> left) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < left.size(); ++i) {
            ChemicalStack stack = (ChemicalStack)left.get(i);
            result.m_130946_(stack.getAmount() + "x ");
            result.m_7220_(stack.getTextComponent());
            if (i >= left.size() - 1) continue;
            result.m_130946_(", ");
        }
        return result;
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<STACK> supplier, Consumer<STACK> onUpdate) {
        father.addConfigurators(new Configurator[]{new SearchComponentConfigurator("recipe.capability.mek_chemical.type", () -> ((ChemicalStack)supplier.get()).getType(), value -> onUpdate.accept((ChemicalStack)this.createStack.apply(value, Math.max(1L, ((ChemicalStack)supplier.get()).getAmount()))), this.empty, true, (word, find) -> {
            String lowerCase = word.toLowerCase();
            if ("empty".contains(lowerCase)) {
                find.accept(this.empty);
                return;
            }
            String[] words = lowerCase.split(" ");
            block0: for (Map.Entry entry : this.registry.get().getEntries()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                Chemical chemical = (Chemical)entry.getValue();
                for (String s : words) {
                    if (!key.toString().toLowerCase().contains(s) && !LocalizationUtils.format((String)chemical.getTranslationKey(), (Object[])new Object[0]).toLowerCase().contains(s)) continue;
                    find.accept(chemical);
                    continue block0;
                }
            }
        }, value -> {
            if (value.isEmptyType()) {
                return "empty";
            }
            ResourceLocation key = this.registry.get().getKey(value);
            return key == null ? "empty" : key.toString();
        })});
        father.addConfigurators(new Configurator[]{new NumberConfigurator("recipe.capability.mek_chemical.amount", () -> ((ChemicalStack)supplier.get()).getAmount(), number -> onUpdate.accept((ChemicalStack)this.createStack.apply(((ChemicalStack)supplier.get()).getType(), number.longValue())), (Number)1, true).setRange((Number)1, (Number)Long.MAX_VALUE)});
    }

    private record ChemicalStackIContentSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>(Function<FriendlyByteBuf, STACK> readFromBuffer, CHEMICAL empty, Supplier<IForgeRegistry<CHEMICAL>> registry, BiFunction<CHEMICAL, Long, STACK> createStack) implements IContentSerializer<STACK>
    {
        @Override
        public void toNetwork(FriendlyByteBuf buf, STACK content) {
            content.writeToPacket(buf);
        }

        @Override
        public STACK fromNetwork(FriendlyByteBuf buf) {
            return (STACK)((ChemicalStack)this.readFromBuffer.apply(buf));
        }

        @Override
        public STACK fromJson(JsonElement json) {
            ResourceLocation type = new ResourceLocation(json.getAsJsonObject().get("type").getAsString());
            long amount = json.getAsJsonObject().get("amount").getAsLong();
            Chemical chemical = ChemicalUtils.readChemicalFromRegistry((ResourceLocation)type, this.empty, this.registry.get());
            return (STACK)((ChemicalStack)this.createStack.apply(chemical, amount));
        }

        @Override
        public JsonElement toJson(STACK content) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("type", content.getType().getRegistryName().toString());
            jsonObj.addProperty("amount", (Number)content.getAmount());
            return jsonObj;
        }

        @Override
        public STACK of(Object o) {
            ChemicalStack chemicalStack;
            if (o instanceof ChemicalStack && ChemicalType.getTypeFor((Chemical)(chemicalStack = (ChemicalStack)o).getType()) == ChemicalType.getTypeFor(this.empty)) {
                return (STACK)chemicalStack;
            }
            if (o instanceof CharSequence) {
                String str = o.toString();
                int x = str.indexOf(120);
                if (x > 0 && x < str.length() - 2 && str.charAt(x + 1) == ' ') {
                    try {
                        Chemical chemical = (Chemical)this.registry.get().getValue(new ResourceLocation(str.substring(x + 2)));
                        long amount = Long.parseLong(str.substring(0, x));
                        return (STACK)((ChemicalStack)this.createStack.apply(chemical, amount));
                    }
                    catch (Exception ignore) {
                        throw new IllegalStateException("Invalid chemical input: " + str);
                    }
                }
                return (STACK)((ChemicalStack)this.createStack.apply((Chemical)this.registry.get().getValue(new ResourceLocation(str)), 1L));
            }
            return (STACK)this.empty.getStack(0L);
        }

        @Override
        public STACK copyInner(STACK content) {
            return (STACK)content.copy();
        }

        @Override
        public STACK copyWithModifier(STACK content, ContentModifier modifier) {
            ChemicalStack copy = content.copy();
            copy.setAmount(modifier.apply(copy.getAmount()).longValue());
            return (STACK)copy;
        }

        @Override
        public STACK deepCopyInner(STACK content) {
            return (STACK)content.copy();
        }
    }
}

