/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism;

import com.google.common.collect.Table;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandler;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.integration.mekanism.MekanismHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.mekanism.trait.heat.MekHeatCapabilityTrait;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public class MEKTemperatureCondition
extends RecipeCondition {
    public static final MEKTemperatureCondition INSTANCE = new MEKTemperatureCondition();
    @Configurable(name="config.recipe.condition.temperature.min")
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    private double minTemperature;
    @Configurable(name="config.recipe.condition.temperature.max")
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    private double maxTemperature;

    public MEKTemperatureCondition(double minTemperature, double maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
    }

    @Override
    public String getType() {
        return "mekanism_heat";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.mekanism_heat.tooltip", (Object[])new Object[]{this.minTemperature, this.maxTemperature});
    }

    @Override
    public IGuiTexture getIcon() {
        return new ResourceTexture("mbd2:textures/gui/thermometer.png");
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> proxy = recipeLogic.machine.getRecipeCapabilitiesProxy();
        ArrayList toCheck = new ArrayList();
        if (recipe.inputs.containsKey(MekanismHeatRecipeCapability.CAP) && proxy.contains((Object)IO.IN, (Object)MekanismHeatRecipeCapability.CAP)) {
            List inputs = (List)proxy.get((Object)IO.IN, (Object)MekanismHeatRecipeCapability.CAP);
            toCheck.addAll(inputs);
        }
        if (recipe.outputs.containsKey(MekanismHeatRecipeCapability.CAP) && proxy.contains((Object)IO.OUT, (Object)MekanismHeatRecipeCapability.CAP)) {
            List outputs = (List)proxy.get((Object)IO.OUT, (Object)MekanismHeatRecipeCapability.CAP);
            toCheck.addAll(outputs);
        }
        if (proxy.contains((Object)IO.BOTH, (Object)MekanismHeatRecipeCapability.CAP)) {
            toCheck.addAll((Collection)proxy.get((Object)IO.BOTH, (Object)MekanismHeatRecipeCapability.CAP));
        }
        for (IRecipeHandler handler : toCheck) {
            if (!(handler instanceof MekHeatCapabilityTrait.HeatRecipeHandler)) continue;
            MekHeatCapabilityTrait.HeatRecipeHandler heatRecipeHandler = (MekHeatCapabilityTrait.HeatRecipeHandler)handler;
            double temp = ((MekHeatCapabilityTrait)heatRecipeHandler.trait).getContainer().getTemperature(0);
            if (!(temp >= this.minTemperature) || !(temp <= this.maxTemperature)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("minTemperature", (Number)this.minTemperature);
        config.addProperty("maxTemperature", (Number)this.maxTemperature);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.minTemperature = GsonHelper.m_144742_((JsonObject)config, (String)"minTemperature", (double)0.0);
        this.maxTemperature = GsonHelper.m_144742_((JsonObject)config, (String)"maxTemperature", (double)1.0);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.minTemperature = buf.readDouble();
        this.maxTemperature = buf.readDouble();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeDouble(this.minTemperature);
        buf.writeDouble(this.maxTemperature);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128347_("minTemperature", this.minTemperature);
        tag.m_128347_("maxTemperature", this.maxTemperature);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.minTemperature = tag.m_128459_("minTemperature");
        this.maxTemperature = tag.m_128459_("maxTemperature");
        return this;
    }

    public double getMinTemperature() {
        return this.minTemperature;
    }

    public double getMaxTemperature() {
        return this.maxTemperature;
    }

    public MEKTemperatureCondition() {
    }
}

