/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.kubejs.recipe;

import com.google.gson.JsonElement;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeSerializer;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.ingredient.EntityIngredient;
import com.lowdragmc.mbd2.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.mbd2.api.recipe.ingredient.SizedIngredient;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.capability.recipe.EntityRecipeCapability;
import com.lowdragmc.mbd2.common.capability.recipe.FluidRecipeCapability;
import com.lowdragmc.mbd2.common.capability.recipe.ForgeEnergyRecipeCapability;
import com.lowdragmc.mbd2.common.capability.recipe.ItemDurabilityRecipeCapability;
import com.lowdragmc.mbd2.common.capability.recipe.ItemRecipeCapability;
import com.lowdragmc.mbd2.common.recipe.BiomeCondition;
import com.lowdragmc.mbd2.common.recipe.BlockCondition;
import com.lowdragmc.mbd2.common.recipe.DayTimeCondition;
import com.lowdragmc.mbd2.common.recipe.DimensionCondition;
import com.lowdragmc.mbd2.common.recipe.LightCondition;
import com.lowdragmc.mbd2.common.recipe.MachineLevelCondition;
import com.lowdragmc.mbd2.common.recipe.MachineNBTCondition;
import com.lowdragmc.mbd2.common.recipe.PositionYCondition;
import com.lowdragmc.mbd2.common.recipe.RainingCondition;
import com.lowdragmc.mbd2.common.recipe.RedstoneSignalCondition;
import com.lowdragmc.mbd2.common.recipe.ThunderCondition;
import com.lowdragmc.mbd2.integration.botania.BotaniaManaRecipeCapability;
import com.lowdragmc.mbd2.integration.create.CreateRPMRecipeCapability;
import com.lowdragmc.mbd2.integration.create.CreateRotationCondition;
import com.lowdragmc.mbd2.integration.create.CreateStressRecipeCapability;
import com.lowdragmc.mbd2.integration.embers.EmbersEmberRecipeCapability;
import com.lowdragmc.mbd2.integration.gtm.GTMEnergyRecipeCapability;
import com.lowdragmc.mbd2.integration.mekanism.MEKTemperatureCondition;
import com.lowdragmc.mbd2.integration.mekanism.MekanismChemicalRecipeCapability;
import com.lowdragmc.mbd2.integration.mekanism.MekanismHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.naturesaura.NaturesAuraRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCPressureAirRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PressureAir;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat.PNCTemperatureCondition;
import dev.latvian.mods.kubejs.fluid.FluidLike;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.fluid.OutputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public interface MBDRecipeSchema {
    public static final RecipeSchema SCHEMA = new RecipeSchema(MBDRecipeJS.class, MBDRecipeJS::new, new RecipeKey[0]);

    public static class MBDRecipeJS
    extends RecipeJS {
        public final Map<RecipeCapability<?>, List<Content>> inputs = new LinkedHashMap();
        public final Map<RecipeCapability<?>, List<Content>> outputs = new LinkedHashMap();
        public final List<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
        public CompoundTag data = new CompoundTag();
        public int duration = 100;
        public int priority;
        public boolean isFuel;
        public boolean perTick;
        public String slotName;
        public String uiName;
        public float chance = 1.0f;
        public float tierChanceBoost = 0.0f;
        @Nullable
        private final MBDRecipeType recipeType;

        public MBDRecipeJS() {
            this(null);
        }

        public MBDRecipeJS(@Nullable MBDRecipeType recipeType) {
            this.recipeType = recipeType;
        }

        public MBDRecipeJS duration(int duration) {
            this.duration = duration;
            this.save();
            return this;
        }

        public MBDRecipeJS priority(int priority) {
            this.priority = priority;
            this.save();
            return this;
        }

        public MBDRecipeJS isFuel(boolean fuel) {
            this.isFuel = fuel;
            this.save();
            return this;
        }

        public MBDRecipeJS addData(String key, Tag data) {
            this.data.m_128365_(key, data);
            this.save();
            return this;
        }

        public MBDRecipeJS addDataString(String key, String data) {
            this.data.m_128359_(key, data);
            this.save();
            return this;
        }

        public MBDRecipeJS addDataNumber(String key, double number) {
            this.data.m_128347_(key, number);
            this.save();
            return this;
        }

        public MBDRecipeJS addDataBoolean(String key, boolean bool) {
            this.data.m_128379_(key, bool);
            this.save();
            return this;
        }

        public MBDRecipeJS perTick(boolean perTick) {
            this.perTick = perTick;
            return this;
        }

        public MBDRecipeJS perTick(RecipeBuilder builder) {
            boolean lastPerTick = this.perTick;
            this.perTick = true;
            builder.accept(this);
            this.perTick = lastPerTick;
            return this;
        }

        public MBDRecipeJS chance(float chance, RecipeBuilder builder) {
            float lastChance = this.chance;
            this.chance = chance;
            builder.accept(this);
            this.chance = lastChance;
            return this;
        }

        public MBDRecipeJS tierChanceBoost(float tierChanceBoost, RecipeBuilder builder) {
            float lastTierChanceBoost = this.tierChanceBoost;
            this.tierChanceBoost = tierChanceBoost;
            builder.accept(this);
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public MBDRecipeJS slotName(String slotName, RecipeBuilder builder) {
            String lastSlotName = this.slotName;
            this.slotName = slotName;
            builder.accept(this);
            this.slotName = lastSlotName;
            return this;
        }

        public MBDRecipeJS uiName(String uiName, RecipeBuilder builder) {
            String lastUiName = this.uiName;
            this.uiName = uiName;
            builder.accept(this);
            this.uiName = lastUiName;
            return this;
        }

        public MBDRecipeJS inputs(RecipeCapability<?> capability, Object ... obj) {
            this.inputs.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).filter(Objects::nonNull).map(capability::of).map(o -> new Content(o, this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
            this.save();
            return this;
        }

        public MBDRecipeJS outputs(RecipeCapability<?> capability, Object ... obj) {
            this.outputs.computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).filter(Objects::nonNull).map(capability::of).map(o -> new Content(o, this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
            this.save();
            return this;
        }

        public MBDRecipeJS removeInputs(RecipeCapability<?> capability) {
            this.inputs.remove(capability);
            this.save();
            return this;
        }

        public MBDRecipeJS removeOutputs(RecipeCapability<?> capability) {
            this.outputs.remove(capability);
            this.save();
            return this;
        }

        public MBDRecipeJS inputItems(InputItem ... items) {
            return this.inputs(ItemRecipeCapability.CAP, Arrays.stream(items).map(item -> SizedIngredient.create(item.ingredient, item.count)).toArray());
        }

        public MBDRecipeJS outputItems(InputItem ... items) {
            return this.outputs(ItemRecipeCapability.CAP, Arrays.stream(items).map(item -> SizedIngredient.create(item.ingredient, item.count)).toArray());
        }

        public MBDRecipeJS inputItemsDurability(InputItem ... items) {
            return this.inputs(ItemDurabilityRecipeCapability.CAP, Arrays.stream(items).map(item -> SizedIngredient.create(item.ingredient, item.count)).toArray());
        }

        public MBDRecipeJS outputItemsDurability(InputItem ... items) {
            return this.outputs(ItemDurabilityRecipeCapability.CAP, Arrays.stream(items).map(item -> SizedIngredient.create(item.ingredient, item.count)).toArray());
        }

        public MBDRecipeJS inputFluids(FluidIngredientJS ... fluids) {
            return this.inputs(FluidRecipeCapability.CAP, Arrays.stream(fluids).map(FluidIngredientJS::ingredient).toArray());
        }

        public MBDRecipeJS outputFluids(FluidIngredientJS ... fluids) {
            return this.outputs(FluidRecipeCapability.CAP, Arrays.stream(fluids).map(FluidIngredientJS::ingredient).toArray());
        }

        public MBDRecipeJS outputEntities(EntityIngredientJS ... entities) {
            return this.outputs(EntityRecipeCapability.CAP, Arrays.stream(entities).map(EntityIngredientJS::ingredient).toArray());
        }

        public MBDRecipeJS inputEntities(EntityIngredientJS ... entities) {
            return this.inputs(EntityRecipeCapability.CAP, Arrays.stream(entities).map(EntityIngredientJS::ingredient).toArray());
        }

        public MBDRecipeJS inputFE(int energy) {
            return this.inputs(ForgeEnergyRecipeCapability.CAP, energy);
        }

        public MBDRecipeJS outputFE(int energy) {
            return this.outputs(ForgeEnergyRecipeCapability.CAP, energy);
        }

        public MBDRecipeJS inputMana(int mana) {
            if (!MBD2.isBotaniaLoaded()) {
                throw new IllegalStateException("Try to add a mana ingredient while the botania is not loaded!");
            }
            return this.inputs(BotaniaManaRecipeCapability.CAP, mana);
        }

        public MBDRecipeJS outputMana(int mana) {
            if (!MBD2.isBotaniaLoaded()) {
                throw new IllegalStateException("Try to add a mana ingredient while the botania is not loaded!");
            }
            return this.outputs(BotaniaManaRecipeCapability.CAP, mana);
        }

        public MBDRecipeJS inputAura(int aura) {
            if (!MBD2.isNaturesAuraLoaded()) {
                throw new IllegalStateException("Try to add a aura ingredient while the nature's aura is not loaded!");
            }
            return this.inputs(NaturesAuraRecipeCapability.CAP, aura);
        }

        public MBDRecipeJS outputAura(int aura) {
            if (!MBD2.isNaturesAuraLoaded()) {
                throw new IllegalStateException("Try to add a aura ingredient while the nature's aura is not loaded!");
            }
            return this.outputs(NaturesAuraRecipeCapability.CAP, aura);
        }

        public MBDRecipeJS inputEmber(double ember) {
            if (!MBD2.isEmbersLoaded()) {
                throw new IllegalStateException("Try to add a ember ingredient while the embers is not loaded!");
            }
            return this.inputs(EmbersEmberRecipeCapability.CAP, ember);
        }

        public MBDRecipeJS outputEmber(double ember) {
            if (!MBD2.isEmbersLoaded()) {
                throw new IllegalStateException("Try to add a ember ingredient while the embers is not loaded!");
            }
            return this.outputs(EmbersEmberRecipeCapability.CAP, ember);
        }

        public MBDRecipeJS inputPNCPressure(float pressure) {
            if (!MBD2.isPneumaticCraftLoaded()) {
                throw new IllegalStateException("Try to add a pressure ingredient while the pneumatic craft is not loaded!");
            }
            return this.inputs(PNCPressureAirRecipeCapability.CAP, new PressureAir(false, pressure));
        }

        public MBDRecipeJS outputPNCPressure(float pressure) {
            if (!MBD2.isPneumaticCraftLoaded()) {
                throw new IllegalStateException("Try to add a pressure ingredient while the pneumatic craft is not loaded!");
            }
            return this.outputs(PNCPressureAirRecipeCapability.CAP, new PressureAir(false, pressure));
        }

        public MBDRecipeJS inputPNCAir(int air) {
            if (!MBD2.isPneumaticCraftLoaded()) {
                throw new IllegalStateException("Try to add a air ingredient while the pneumatic craft is not loaded!");
            }
            return this.inputs(PNCPressureAirRecipeCapability.CAP, new PressureAir(true, air));
        }

        public MBDRecipeJS outputPNCAir(int air) {
            if (!MBD2.isPneumaticCraftLoaded()) {
                throw new IllegalStateException("Try to add a air ingredient while the pneumatic craft is not loaded!");
            }
            return this.outputs(PNCPressureAirRecipeCapability.CAP, new PressureAir(true, air));
        }

        public MBDRecipeJS inputPNCHeat(double heat) {
            if (!MBD2.isPneumaticCraftLoaded()) {
                throw new IllegalStateException("Try to add a heat ingredient while the pneumatic craft is not loaded!");
            }
            return this.inputs(PNCHeatRecipeCapability.CAP, heat);
        }

        public MBDRecipeJS outputPNCHeat(double heat) {
            if (!MBD2.isPneumaticCraftLoaded()) {
                throw new IllegalStateException("Try to add a heat ingredient while the pneumatic craft is not loaded!");
            }
            return this.outputs(PNCHeatRecipeCapability.CAP, heat);
        }

        public MBDRecipeJS inputHeat(double heat) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a heat ingredient while the mekanism is not loaded!");
            }
            return this.inputs(MekanismHeatRecipeCapability.CAP, heat);
        }

        public MBDRecipeJS outputHeat(double heat) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a heat ingredient while the mekanism is not loaded!");
            }
            return this.outputs(MekanismHeatRecipeCapability.CAP, heat);
        }

        public MBDRecipeJS inputEU(long eu) {
            if (!MBD2.isGTMLoaded()) {
                throw new IllegalStateException("Try to add a eu ingredient while the gtceu is not loaded!");
            }
            return this.inputs(GTMEnergyRecipeCapability.CAP, eu);
        }

        public MBDRecipeJS outputEU(long eu) {
            if (!MBD2.isGTMLoaded()) {
                throw new IllegalStateException("Try to add a eu ingredient while the gtceu is not loaded!");
            }
            return this.outputs(GTMEnergyRecipeCapability.CAP, eu);
        }

        public MBDRecipeJS inputStress(float stress) {
            if (!MBD2.isCreateLoaded()) {
                throw new IllegalStateException("Try to add a stress ingredient while the create is not loaded!");
            }
            return this.inputs(CreateStressRecipeCapability.CAP, Float.valueOf(stress));
        }

        public MBDRecipeJS outputStress(float stress) {
            if (!MBD2.isCreateLoaded()) {
                throw new IllegalStateException("Try to add a stress ingredient while the create is not loaded!");
            }
            return this.outputs(CreateStressRecipeCapability.CAP, Float.valueOf(stress));
        }

        public MBDRecipeJS inputRPM(float stress) {
            if (!MBD2.isCreateLoaded()) {
                throw new IllegalStateException("Try to add a rpm ingredient while the create is not loaded!");
            }
            return this.inputs(CreateRPMRecipeCapability.CAP, Float.valueOf(stress));
        }

        public MBDRecipeJS outputRPM(float stress) {
            if (!MBD2.isCreateLoaded()) {
                throw new IllegalStateException("Try to add a rpm ingredient while the create is not loaded!");
            }
            return this.outputs(CreateRPMRecipeCapability.CAP, Float.valueOf(stress));
        }

        public MBDRecipeJS inputGases(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a gas ingredient while the mekanism is not loaded!");
            }
            return this.inputs(MekanismChemicalRecipeCapability.CAP_GAS, stack);
        }

        public MBDRecipeJS outputGases(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a gas ingredient while the mekanism is not loaded!");
            }
            return this.outputs(MekanismChemicalRecipeCapability.CAP_GAS, stack);
        }

        public MBDRecipeJS inputSlurries(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a slurry ingredient while the mekanism is not loaded!");
            }
            return this.inputs(MekanismChemicalRecipeCapability.CAP_SLURRY, stack);
        }

        public MBDRecipeJS outputSlurries(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a slurry ingredient while the mekanism is not loaded!");
            }
            return this.outputs(MekanismChemicalRecipeCapability.CAP_SLURRY, stack);
        }

        public MBDRecipeJS inputInfusions(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a infuse type ingredient while the mekanism is not loaded!");
            }
            return this.inputs(MekanismChemicalRecipeCapability.CAP_INFUSE, stack);
        }

        public MBDRecipeJS outputInfusions(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a infuse type ingredient while the mekanism is not loaded!");
            }
            return this.outputs(MekanismChemicalRecipeCapability.CAP_INFUSE, stack);
        }

        public MBDRecipeJS inputPigments(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a pigment ingredient while the mekanism is not loaded!");
            }
            return this.inputs(MekanismChemicalRecipeCapability.CAP_PIGMENT, stack);
        }

        public MBDRecipeJS outputPigments(String ... stack) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a pigment ingredient while the mekanism is not loaded!");
            }
            return this.outputs(MekanismChemicalRecipeCapability.CAP_PIGMENT, stack);
        }

        public MBDRecipeJS addCondition(RecipeCondition condition) {
            this.conditions.add(condition);
            this.save();
            return this;
        }

        public MBDRecipeJS dimension(ResourceLocation dimension) {
            this.addCondition(new DimensionCondition(dimension));
            return this;
        }

        public MBDRecipeJS biome(ResourceLocation biome) {
            this.addCondition(new BiomeCondition(biome));
            return this;
        }

        public MBDRecipeJS machineLevel(int level) {
            this.addCondition(new MachineLevelCondition(level));
            return this;
        }

        public MBDRecipeJS positionY(int min, int max) {
            this.addCondition(new PositionYCondition(min, max));
            return this;
        }

        public MBDRecipeJS raining(int min, int max) {
            this.addCondition(new RainingCondition(min, max));
            return this;
        }

        public MBDRecipeJS thundering(int min, int max) {
            this.addCondition(new ThunderCondition(min, max));
            return this;
        }

        public MBDRecipeJS blocksInStructure(int min, int max, Block ... blocks) {
            this.addCondition(new BlockCondition(min, max, blocks));
            return this;
        }

        public MBDRecipeJS machineData(CompoundTag data, boolean onlyCheckCustomData) {
            this.addCondition(new MachineNBTCondition(data, onlyCheckCustomData));
            return this;
        }

        @Deprecated(forRemoval=true, since="1.21.0")
        public MBDRecipeJS dayLight(boolean isDay) {
            this.addCondition(new DayTimeCondition(isDay));
            return this;
        }

        public MBDRecipeJS dayTime(boolean isDay) {
            this.addCondition(new DayTimeCondition(isDay));
            return this;
        }

        public MBDRecipeJS light(int minSkyLight, int maxSkyLight, int minBlockLight, int maxBlockLight, boolean canSeeSky) {
            this.addCondition(new LightCondition(minSkyLight, maxSkyLight, minBlockLight, maxBlockLight, canSeeSky));
            return this;
        }

        public MBDRecipeJS redstoneSignal(int minSignal, int maxSignal) {
            this.addCondition(new RedstoneSignalCondition(minSignal, maxSignal));
            return this;
        }

        public MBDRecipeJS rotationCondition(float minRPM, float maxRPM, float minStress, float maxStress) {
            if (!MBD2.isCreateLoaded()) {
                throw new IllegalStateException("Try to add a rotation condition while the create is not loaded!");
            }
            this.addCondition(new CreateRotationCondition(minRPM, maxRPM, minStress, maxStress));
            return this;
        }

        public MBDRecipeJS mekTemperatureCondition(double minTemperature, double maxTemperature) {
            if (!MBD2.isMekanismLoaded()) {
                throw new IllegalStateException("Try to add a heat condition while the mekanism is not loaded!");
            }
            this.addCondition(new MEKTemperatureCondition(minTemperature, maxTemperature));
            return this;
        }

        public MBDRecipeJS pncTemperatureCondition(float minTemperature, float maxTemperature) {
            if (!MBD2.isPneumaticCraftLoaded()) {
                throw new IllegalStateException("Try to add a temperature condition while the pneumatic is not loaded!");
            }
            this.addCondition(new PNCTemperatureCondition(minTemperature, maxTemperature));
            return this;
        }

        private MBDRecipeType getRecipeType() {
            if (this.recipeType == null) {
                MBDRecipeType recipeType = (MBDRecipeType)MBDRegistries.RECIPE_TYPES.get(this.type.schemaType.id);
                if (recipeType == null) {
                    throw new IllegalStateException("MBD Recipe type " + String.valueOf(this.type.schemaType.id) + " not found!");
                }
                return recipeType;
            }
            return this.recipeType;
        }

        public void deserialize(boolean merge) {
            super.deserialize(merge);
            MBDRecipe mbdRecipe = MBDRecipeSerializer.SERIALIZER.fromJson(this.getOrCreateId(), this.json);
            this.inputs.clear();
            this.outputs.clear();
            this.conditions.clear();
            this.inputs.putAll(mbdRecipe.inputs);
            this.outputs.putAll(mbdRecipe.outputs);
            this.conditions.addAll(mbdRecipe.conditions);
            this.data = mbdRecipe.data;
            this.duration = mbdRecipe.duration;
            this.priority = mbdRecipe.priority;
            this.isFuel = mbdRecipe.isFuel;
        }

        public void serialize() {
            this.json = MBDRecipeSerializer.SERIALIZER.toJson(new MBDRecipe(this.getRecipeType(), this.getOrCreateId(), this.inputs, this.outputs, this.conditions, this.data, this.duration, this.isFuel, this.priority));
        }

        public MBDRecipe buildMBDRecipe() {
            return new MBDRecipe(this.getRecipeType(), this.getOrCreateId(), this.inputs, this.outputs, this.conditions, this.data, this.duration, this.isFuel, this.priority);
        }

        public Map<RecipeCapability<?>, List<Content>> inputs() {
            return this.inputs;
        }

        public Map<RecipeCapability<?>, List<Content>> outputs() {
            return this.outputs;
        }

        public List<RecipeCondition> conditions() {
            return this.conditions;
        }

        public CompoundTag data() {
            return this.data;
        }

        public int duration() {
            return this.duration;
        }

        public int priority() {
            return this.priority;
        }

        public boolean isFuel() {
            return this.isFuel;
        }

        public boolean perTick() {
            return this.perTick;
        }

        public String slotName() {
            return this.slotName;
        }

        public String uiName() {
            return this.uiName;
        }

        public float chance() {
            return this.chance;
        }

        public float tierChanceBoost() {
            return this.tierChanceBoost;
        }

        @Nullable
        public MBDRecipeType recipeType() {
            return this.recipeType;
        }

        public MBDRecipeJS slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public MBDRecipeJS uiName(String uiName) {
            this.uiName = uiName;
            return this;
        }

        public MBDRecipeJS chance(float chance) {
            this.chance = chance;
            return this;
        }

        public MBDRecipeJS tierChanceBoost(float tierChanceBoost) {
            this.tierChanceBoost = tierChanceBoost;
            return this;
        }

        @FunctionalInterface
        public static interface RecipeBuilder
        extends Consumer<MBDRecipeJS> {
        }
    }

    public record FluidIngredientJS(FluidIngredient ingredient) implements InputFluid,
    OutputFluid
    {
        public long kjs$getAmount() {
            return this.ingredient.getAmount();
        }

        public FluidIngredientJS kjs$copy(long amount) {
            FluidIngredient ingredient1 = this.ingredient.copy();
            ingredient1.setAmount(amount);
            return new FluidIngredientJS(ingredient1);
        }

        public boolean matches(FluidLike other) {
            if (other instanceof FluidStackJS) {
                FluidStackJS fluidStack = (FluidStackJS)other;
                return this.ingredient.test(FluidStack.create((Fluid)fluidStack.getFluid(), (long)fluidStack.getAmount(), (CompoundTag)fluidStack.getNbt()));
            }
            return other.matches((FluidLike)this);
        }

        public static FluidIngredientJS of(Object o) {
            if (o instanceof FluidIngredientJS) {
                FluidIngredientJS ingredientJS = (FluidIngredientJS)o;
                return ingredientJS;
            }
            if (o instanceof FluidIngredient) {
                FluidIngredient ingredient = (FluidIngredient)o;
                return new FluidIngredientJS(ingredient);
            }
            if (o instanceof JsonElement) {
                JsonElement json = (JsonElement)o;
                return new FluidIngredientJS(FluidIngredient.fromJson(json));
            }
            if (o instanceof FluidStackJS) {
                FluidStackJS fluidStackJS = (FluidStackJS)o;
                return new FluidIngredientJS(FluidIngredient.of(FluidStack.create((Fluid)fluidStackJS.getFluid(), (long)fluidStackJS.getAmount(), (CompoundTag)fluidStackJS.getNbt())));
            }
            List list = ListJS.of((Object)o);
            if (list != null && !list.isEmpty()) {
                ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
                for (Object object : list) {
                    FluidStackJS stackJS = FluidStackJS.of(object);
                    stacks.add(FluidStack.create((Fluid)stackJS.getFluid(), (long)stackJS.getAmount(), (CompoundTag)stackJS.getNbt()));
                }
                return new FluidIngredientJS(FluidIngredient.of((FluidStack[])stacks.toArray(FluidStack[]::new)));
            }
            FluidStackJS stackJS = FluidStackJS.of((Object)o);
            return new FluidIngredientJS(FluidIngredient.of(FluidStack.create((Fluid)stackJS.getFluid(), (long)stackJS.getAmount(), (CompoundTag)stackJS.getNbt())));
        }
    }

    public record EntityIngredientJS(@Nullable EntityIngredient ingredient) {
        public static EntityIngredientJS of(Object object) {
            String str;
            int x;
            if (object instanceof EntityIngredientJS) {
                EntityIngredientJS entityIngredientJS = (EntityIngredientJS)object;
                return entityIngredientJS;
            }
            if (object instanceof EntityIngredient) {
                EntityIngredient entityIngredient = (EntityIngredient)object;
                return new EntityIngredientJS(entityIngredient);
            }
            if (object instanceof JsonElement) {
                JsonElement json = (JsonElement)object;
                return new EntityIngredientJS(EntityIngredient.fromJson(json));
            }
            if (object instanceof EntityType) {
                EntityType entityType = (EntityType)object;
                return new EntityIngredientJS(EntityIngredient.of(1, entityType));
            }
            if (object instanceof CharSequence && (x = (str = object.toString()).indexOf(120)) > 0 && x < str.length() - 2 && str.charAt(x + 1) == ' ') {
                try {
                    EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(str.substring(x + 2)));
                    int amount = Integer.parseInt(str.substring(0, x));
                    return new EntityIngredientJS(EntityIngredient.of(amount, entityType));
                }
                catch (Exception ignore) {
                    throw new IllegalStateException("Invalid chemical input: " + str);
                }
            }
            return new EntityIngredientJS(null);
        }
    }
}

