/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.jei;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.integration.jei.MBDRecipeTypeCategory;
import com.lowdragmc.mbd2.integration.jei.MBDRecipeTypeFuelCategory;
import com.lowdragmc.mbd2.integration.jei.MultiblockInfoCategory;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class MBDJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return MBD2.id("jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        MBD2.LOGGER.info("JEI register categories");
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockInfoCategory(jeiHelpers)});
        for (MBDRecipeType recipeType : MBDRegistries.RECIPE_TYPES) {
            if (!recipeType.isXEIVisible()) continue;
            registry.addRecipeCategories(new IRecipeCategory[]{new MBDRecipeTypeCategory(jeiHelpers, recipeType)});
            if (!recipeType.isRequireFuelForWorking()) continue;
            registry.addRecipeCategories(new IRecipeCategory[]{new MBDRecipeTypeFuelCategory(jeiHelpers, recipeType)});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        MBD2.LOGGER.info("JEI register catalysts");
        MultiblockInfoCategory.registerRecipeCatalysts(registration);
        MBDRecipeTypeCategory.registerRecipeCatalysts(registration);
        MBDRecipeTypeFuelCategory.registerRecipeCatalysts(registration);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        MBD2.LOGGER.info("JEI register recipes");
        MultiblockInfoCategory.registerRecipes(registration);
        MBDRecipeTypeCategory.registerRecipes(registration);
        MBDRecipeTypeFuelCategory.registerRecipes(registration);
    }
}

