/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.botania.trait;

import com.lowdragmc.mbd2.api.capability.recipe.IO;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ManaPool;

public class ManaPoolWrapper
implements ManaPool {
    private final ManaPool manaPool;
    private final IO io;

    public ManaPoolWrapper(ManaPool receiver, IO io) {
        this.manaPool = receiver;
        this.io = io;
    }

    public Level getManaReceiverLevel() {
        return this.manaPool.getManaReceiverLevel();
    }

    public BlockPos getManaReceiverPos() {
        return this.manaPool.getManaReceiverPos();
    }

    public int getCurrentMana() {
        return this.manaPool.getCurrentMana();
    }

    public boolean isFull() {
        return this.manaPool.isFull();
    }

    public void receiveMana(int mana) {
        if (mana > 0 && (this.io == IO.IN || this.io == IO.BOTH)) {
            this.manaPool.receiveMana(mana);
        } else if (mana < 0 && (this.io == IO.OUT || this.io == IO.BOTH)) {
            this.manaPool.receiveMana(mana);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return this.manaPool.canReceiveManaFromBursts() && (this.io == IO.IN || this.io == IO.BOTH);
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public int getMaxMana() {
        return this.manaPool.getMaxMana();
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }
}

