/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.botania.trait;

import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.FancyRendererSettings;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.integration.botania.trait.BotaniaManaCapabilityTrait;
import com.lowdragmc.mbd2.integration.botania.trait.BotaniaManaCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.botania.trait.CopiableManaPool;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BotaniaManaFancyRendererSettings
extends FancyRendererSettings {
    private final BotaniaManaCapabilityTraitDefinition definition;
    @Configurable(name="config.definition.trait.fancy_renderer.percent_height", tips={"config.definition.trait.fancy_renderer.percent_height.tooltip"})
    private boolean percentHeight = false;

    public BotaniaManaFancyRendererSettings(BotaniaManaCapabilityTraitDefinition definition) {
        this.definition = definition;
    }

    @Override
    public IRenderer createFancyRenderer() {
        return new Renderer();
    }

    public boolean isPercentHeight() {
        return this.percentHeight;
    }

    public void setPercentHeight(boolean percentHeight) {
        this.percentHeight = percentHeight;
    }

    private class Renderer
    implements IRenderer {
        private Renderer() {
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean hasTESR(BlockEntity blockEntity) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
            MBDMachine machine;
            ITrait iTrait;
            Object t;
            Optional optional = blockEntity.getCapability(MBDCapabilities.CAPABILITY_MACHINE).resolve();
            if (optional.isPresent() && (t = optional.get()) instanceof MBDMachine && (iTrait = (machine = (MBDMachine)t).getTraitByDefinition(BotaniaManaFancyRendererSettings.this.definition)) instanceof BotaniaManaCapabilityTrait) {
                BotaniaManaCapabilityTrait trait = (BotaniaManaCapabilityTrait)iTrait;
                CopiableManaPool storage = trait.storage;
                if (storage.getCurrentMana() == 0 || storage.getMaxMana() == 0) {
                    return;
                }
                int mana = storage.getCurrentMana();
                int maxMana = storage.getMaxMana();
                float manaLevel = (float)mana * 1.0f / (float)maxMana;
                poseStack.m_85836_();
                if (BotaniaManaFancyRendererSettings.this.rotateOrientation) {
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    poseStack.m_252781_(ModelFactory.getQuaternion((Direction)machine.getFrontFacing().orElse(Direction.NORTH)));
                    poseStack.m_85837_(-0.5, -0.5, -0.5);
                }
                poseStack.m_252880_(((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).position.x, ((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).position.y, ((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).position.z);
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(new Quaternionf().rotateXYZ((float)Math.toRadians(((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).rotation.x), (float)Math.toRadians(((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).rotation.y), (float)Math.toRadians(((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).rotation.z)));
                poseStack.m_85841_(((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).scale.x, ((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).scale.y, ((BotaniaManaFancyRendererSettings)BotaniaManaFancyRendererSettings.this).scale.z);
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                RenderSystem.defaultBlendFunc();
                RenderSystem.enableBlend();
                TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(ResourceLocationHelper.prefix((String)"block/mana_water"));
                VertexConsumer buffer = bufferSource.m_6299_(RenderHelper.MANA_POOL_WATER);
                Renderer.renderCubeFace(poseStack, buffer, 0.0f, 0.0f, 0.0f, 1.0f, BotaniaManaFancyRendererSettings.this.percentHeight ? manaLevel : 1.0f, 1.0f, -1, combinedLight, texture.m_118409_(), texture.m_118411_(), texture.m_118410_(), texture.m_118412_());
                poseStack.m_85849_();
            }
        }

        public static void renderCubeFace(PoseStack poseStack, VertexConsumer buffer, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color, int combinedLight, float u0, float v0, float u1, float v1) {
            Matrix4f mat = poseStack.m_85850_().m_252922_();
            buffer.m_252986_(mat, minX, minY, minZ).m_193479_(color).m_7421_(u0, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, minY, maxZ).m_193479_(color).m_7421_(u1, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, maxY, maxZ).m_193479_(color).m_7421_(u1, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, maxY, minZ).m_193479_(color).m_7421_(u0, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, minY, minZ).m_193479_(color).m_7421_(u0, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, minZ).m_193479_(color).m_7421_(u1, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_193479_(color).m_7421_(u1, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, minY, maxZ).m_193479_(color).m_7421_(u0, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, minY, minZ).m_193479_(color).m_7421_(u0, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, minY, minZ).m_193479_(color).m_7421_(u1, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, minY, maxZ).m_193479_(color).m_7421_(u1, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, minY, maxZ).m_193479_(color).m_7421_(u0, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, maxY, minZ).m_193479_(color).m_7421_(u0, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, maxY, maxZ).m_193479_(color).m_7421_(u1, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_193479_(color).m_7421_(u1, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, minZ).m_193479_(color).m_7421_(u0, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, minY, minZ).m_193479_(color).m_7421_(u0, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, maxY, minZ).m_193479_(color).m_7421_(u1, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, minZ).m_193479_(color).m_7421_(u1, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, minY, minZ).m_193479_(color).m_7421_(u0, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, minY, maxZ).m_193479_(color).m_7421_(u0, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, minY, maxZ).m_193479_(color).m_7421_(u1, v1).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, maxX, maxY, maxZ).m_193479_(color).m_7421_(u1, v0).m_85969_(combinedLight).m_5752_();
            buffer.m_252986_(mat, minX, maxY, maxZ).m_193479_(color).m_7421_(u0, v0).m_85969_(combinedLight).m_5752_();
        }
    }
}

