/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="mbd2", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigHolder {
    public static ConfigHolder INSTANCE;
    private static final ForgeConfigSpec.Builder BUILDER;
    private static final ForgeConfigSpec.BooleanValue ASYNC_RECIPE_SEARCHING;
    private static final ForgeConfigSpec.BooleanValue USE_VBO;
    private static final ForgeConfigSpec.IntValue MULTIBLOCK_PREVIEW_DURATION;
    private static final ForgeConfigSpec.IntValue MULTIBLOCK_PATTERN_ERROR_DURATION;
    public static final ForgeConfigSpec SPEC;
    public static boolean asyncRecipeSearching;
    public static boolean useVBO;
    public static int multiblockPreviewDuration;
    public static int multiblockPatternErrorPosDuration;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        asyncRecipeSearching = (Boolean)ASYNC_RECIPE_SEARCHING.get();
        useVBO = (Boolean)USE_VBO.get();
        multiblockPreviewDuration = (Integer)MULTIBLOCK_PREVIEW_DURATION.get();
        multiblockPatternErrorPosDuration = (Integer)MULTIBLOCK_PATTERN_ERROR_DURATION.get();
    }

    static {
        BUILDER = new ForgeConfigSpec.Builder();
        ASYNC_RECIPE_SEARCHING = BUILDER.comment("Whether search for recipes asynchronously.").define("asyncRecipeSearching", true);
        USE_VBO = BUILDER.comment("Whether use vbo for preview page rendering.").define("useVBO", true);
        MULTIBLOCK_PREVIEW_DURATION = BUILDER.comment("Duration of the multiblock in-world preview (s)").defineInRange("multiblockPreviewDuration", 10, 1, 999);
        MULTIBLOCK_PATTERN_ERROR_DURATION = BUILDER.comment("Duration of the multiblock in-world pattern error position (s)").defineInRange("multiblockPatternErrorPosDuration", 10, 1, 999);
        SPEC = BUILDER.build();
    }
}

