/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.item;

import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.FancyRendererSettings;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.item.ItemSlotCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.item.ItemSlotCapabilityTraitDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

public class ItemFancyRendererSettings
extends FancyRendererSettings {
    private final ItemSlotCapabilityTraitDefinition definition;
    @Configurable(name="config.definition.trait.fancy_renderer.spin", tips={"config.definition.trait.fancy_renderer.spin.tooltip"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    private float spin = 0.0f;
    @Configurable(name="config.definition.trait.fancy_renderer.render_stack", tips={"config.definition.trait.fancy_renderer.render_stack.tooltip"})
    private boolean renderStack = true;

    public ItemFancyRendererSettings(ItemSlotCapabilityTraitDefinition definition) {
        this.definition = definition;
    }

    @Override
    public IRenderer createFancyRenderer() {
        return new Renderer();
    }

    public float getSpin() {
        return this.spin;
    }

    public void setSpin(float spin) {
        this.spin = spin;
    }

    public boolean isRenderStack() {
        return this.renderStack;
    }

    public void setRenderStack(boolean renderStack) {
        this.renderStack = renderStack;
    }

    private class Renderer
    implements IRenderer {
        private static final RandomSource RANDOM = RandomSource.m_216327_();

        private Renderer() {
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean hasTESR(BlockEntity blockEntity) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
            MBDMachine machine;
            ITrait iTrait;
            Object t;
            Optional optional = blockEntity.getCapability(MBDCapabilities.CAPABILITY_MACHINE).resolve();
            if (optional.isPresent() && (t = optional.get()) instanceof MBDMachine && (iTrait = (machine = (MBDMachine)t).getTraitByDefinition(ItemFancyRendererSettings.this.definition)) instanceof ItemSlotCapabilityTrait) {
                ItemSlotCapabilityTrait trait = (ItemSlotCapabilityTrait)iTrait;
                ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
                float tick = (float)blockEntity.m_58904_().m_46467_() + partialTicks;
                for (int i = 0; i < trait.storage.getSlots(); ++i) {
                    ItemStack itemStack = trait.storage.getStackInSlot(i);
                    if (itemStack.m_41619_()) continue;
                    BakedModel bakedmodel = itemRenderer.m_174264_(itemStack, (Level)Minecraft.m_91087_().f_91073_, null, Item.m_41393_((Item)itemStack.m_41720_()) + itemStack.m_41773_());
                    boolean isGui3d = bakedmodel.m_7539_();
                    int renderAmount = ItemFancyRendererSettings.this.renderStack ? this.getRenderAmount(itemStack) : 1;
                    RANDOM.m_188584_(itemStack.m_41619_() ? 187L : (long)(Item.m_41393_((Item)itemStack.m_41720_()) + itemStack.m_41773_()));
                    poseStack.m_85836_();
                    if (ItemFancyRendererSettings.this.rotateOrientation) {
                        poseStack.m_85837_(0.5, 0.5, 0.5);
                        poseStack.m_252781_(ModelFactory.getQuaternion((Direction)machine.getFrontFacing().orElse(Direction.NORTH)));
                        poseStack.m_85837_(-0.5, -0.5, -0.5);
                    }
                    poseStack.m_252880_(((ItemFancyRendererSettings)ItemFancyRendererSettings.this).position.x, ((ItemFancyRendererSettings)ItemFancyRendererSettings.this).position.y, ((ItemFancyRendererSettings)ItemFancyRendererSettings.this).position.z);
                    if (ItemFancyRendererSettings.this.spin != 0.0f) {
                        poseStack.m_252781_(new Quaternionf().rotateAxis(ItemFancyRendererSettings.this.spin * tick * ((float)Math.PI * 2) / 80.0f, 0.0f, 1.0f, 0.0f));
                    }
                    poseStack.m_252781_(new Quaternionf().rotateXYZ((float)Math.toRadians(((ItemFancyRendererSettings)ItemFancyRendererSettings.this).rotation.x), (float)Math.toRadians(((ItemFancyRendererSettings)ItemFancyRendererSettings.this).rotation.y), (float)Math.toRadians(((ItemFancyRendererSettings)ItemFancyRendererSettings.this).rotation.z)));
                    poseStack.m_85841_(((ItemFancyRendererSettings)ItemFancyRendererSettings.this).scale.x, ((ItemFancyRendererSettings)ItemFancyRendererSettings.this).scale.y, ((ItemFancyRendererSettings)ItemFancyRendererSettings.this).scale.z);
                    for (int j = 0; j < renderAmount; ++j) {
                        poseStack.m_85836_();
                        if (isGui3d) {
                            float rx = 0.0f;
                            float ry = 0.0f;
                            float rz = 0.0f;
                            if (renderAmount > 1) {
                                rx = (RANDOM.m_188501_() * 2.0f - 1.0f) * 0.06f;
                                ry = (RANDOM.m_188501_() * 2.0f - 1.0f) * 0.06f;
                                rz = (RANDOM.m_188501_() * 2.0f - 1.0f) * 0.06f;
                            }
                            poseStack.m_252880_(rx, ry, rz);
                        } else {
                            float offset = (float)j / 10.0f - (float)(renderAmount - 1) / 20.0f;
                            poseStack.m_252880_(offset, offset, offset);
                        }
                        itemRenderer.m_115143_(itemStack, ItemDisplayContext.FIXED, false, poseStack, bufferSource, combinedLight, combinedOverlay, bakedmodel);
                        poseStack.m_85849_();
                    }
                    poseStack.m_85849_();
                }
            }
        }

        private int getRenderAmount(ItemStack stack) {
            int i = 1;
            if (stack.m_41613_() > 16) {
                i = 3;
            } else if (stack.m_41613_() > 1) {
                i = 2;
            }
            return i;
        }
    }
}

