/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.forgeenergy;

import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.FancyRendererSettings;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.forgeenergy.CopiableEnergyStorage;
import com.lowdragmc.mbd2.common.trait.forgeenergy.ForgeEnergyCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.forgeenergy.ForgeEnergyCapabilityTraitDefinition;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Optional;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

public class ForgeEnergyFancyRendererSettings
extends FancyRendererSettings {
    private final ForgeEnergyCapabilityTraitDefinition definition;
    @Configurable(name="config.definition.trait.fancy_renderer.color", tips={"config.definition.trait.fancy_renderer.color.tooltip"})
    @NumberColor
    private int color = -1431699439;
    @Configurable(name="config.definition.trait.fancy_renderer.percent_height", tips={"config.definition.trait.fancy_renderer.percent_height.tooltip"})
    private boolean percentHeight = false;

    public ForgeEnergyFancyRendererSettings(ForgeEnergyCapabilityTraitDefinition definition) {
        this.definition = definition;
    }

    @Override
    public IRenderer createFancyRenderer() {
        return new Renderer();
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public boolean isPercentHeight() {
        return this.percentHeight;
    }

    public void setPercentHeight(boolean percentHeight) {
        this.percentHeight = percentHeight;
    }

    private class Renderer
    implements IRenderer {
        private Renderer() {
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean hasTESR(BlockEntity blockEntity) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
            MBDMachine machine;
            ITrait iTrait;
            Object t;
            Optional optional = blockEntity.getCapability(MBDCapabilities.CAPABILITY_MACHINE).resolve();
            if (optional.isPresent() && (t = optional.get()) instanceof MBDMachine && (iTrait = (machine = (MBDMachine)t).getTraitByDefinition(ForgeEnergyFancyRendererSettings.this.definition)) instanceof ForgeEnergyCapabilityTrait) {
                ForgeEnergyCapabilityTrait trait = (ForgeEnergyCapabilityTrait)iTrait;
                CopiableEnergyStorage storage = trait.storage;
                if (storage.getEnergyStored() == 0 || storage.getMaxEnergyStored() == 0) {
                    return;
                }
                poseStack.m_85836_();
                if (ForgeEnergyFancyRendererSettings.this.rotateOrientation) {
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    poseStack.m_252781_(ModelFactory.getQuaternion((Direction)machine.getFrontFacing().orElse(Direction.NORTH)));
                    poseStack.m_85837_(-0.5, -0.5, -0.5);
                }
                poseStack.m_252880_(((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).position.x, ((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).position.y, ((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).position.z);
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(new Quaternionf().rotateXYZ((float)Math.toRadians(((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).rotation.x), (float)Math.toRadians(((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).rotation.y), (float)Math.toRadians(((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).rotation.z)));
                poseStack.m_85841_(((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).scale.x, ((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).scale.y, ((ForgeEnergyFancyRendererSettings)ForgeEnergyFancyRendererSettings.this).scale.z);
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                RenderSystem.enableBlend();
                RenderSystem.enableDepthTest();
                RenderSystem.blendFunc((int)770, (int)771);
                Tesselator tessellator = Tesselator.m_85913_();
                BufferBuilder buffer = tessellator.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172811_);
                buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
                RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)(ForgeEnergyFancyRendererSettings.this.percentHeight ? (float)storage.getEnergyStored() * 1.0f / (float)storage.getMaxEnergyStored() : 1.0f), (float)1.0f, (float)ColorUtils.red((int)ForgeEnergyFancyRendererSettings.this.color), (float)ColorUtils.green((int)ForgeEnergyFancyRendererSettings.this.color), (float)ColorUtils.blue((int)ForgeEnergyFancyRendererSettings.this.color), (float)ColorUtils.alpha((int)ForgeEnergyFancyRendererSettings.this.color), (boolean)true);
                tessellator.m_85914_();
                poseStack.m_85849_();
            }
        }
    }
}

