/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.fluid;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineTraitPanel;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoWorldIO;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.common.trait.fluid.FluidFancyRendererSettings;
import com.lowdragmc.mbd2.common.trait.fluid.FluidFilterSettings;
import com.lowdragmc.mbd2.common.trait.fluid.FluidTankCapabilityTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="fluid_tank", group="trait", priority=-100)
public class FluidTankCapabilityTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.fluid_tank.tank_size", tips={"config.definition.trait.fluid_tank.tank_size.tooltip"})
    @NumberRange(range={1.0, 2.147483647E9})
    private int tankSize = 1;
    @Configurable(name="config.definition.trait.fluid_tank.capacity")
    @NumberRange(range={1.0, 2.147483647E9})
    private int capacity = 1000;
    @Configurable(name="config.definition.trait.fluid_tank.allow_same_fluids", tips={"config.definition.trait.fluid_tank.allow_same_fluids.tooltip"})
    private boolean allowSameFluids = true;
    @Configurable(name="config.definition.trait.fluid_tank.filter", subConfigurable=true, tips={"config.definition.trait.fluid_tank.filter.tooltip"})
    private final FluidFilterSettings fluidFilterSettings = new FluidFilterSettings();
    @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.fluid_tank.auto_io.tooltip"})
    private final ToggleAutoIO autoIO = new ToggleAutoIO();
    @Configurable(name="config.definition.trait.auto_world_io.input", subConfigurable=true, tips={"config.definition.trait.auto_world_io.input.tooltip"})
    private final AutoWorldIO autoInput = new AutoWorldIO().setSpeed(1);
    @Configurable(name="config.definition.trait.auto_world_io.output", subConfigurable=true, tips={"config.definition.trait.auto_world_io.output.tooltip"})
    private final AutoWorldIO autoOutput = new AutoWorldIO().setSpeed(1);
    @Configurable(name="config.definition.trait.fluid_tank.fancy_renderer", subConfigurable=true, tips={"config.definition.trait.fluid_tank.fancy_renderer.tooltip.0", "config.definition.trait.fluid_tank.fancy_renderer.tooltip.1"})
    private final FluidFancyRendererSettings fancyRendererSettings = new FluidFancyRendererSettings(this);

    @Override
    public SimpleCapabilityTrait createTrait(MBDMachine machine) {
        return new FluidTankCapabilityTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{Items.f_42447_});
    }

    @Override
    public IRenderer getBESRenderer(IMachine machine) {
        return this.fancyRendererSettings.getFancyRenderer(machine);
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        for (int i = 0; i < this.tankSize; ++i) {
            TankWidget tankWidget = new TankWidget();
            tankWidget.initTemplate();
            tankWidget.setSelfPosition(new Position(10 + i * 20, 10));
            tankWidget.setSize(new Size(20, 58));
            tankWidget.setOverlay((IGuiTexture)new ResourceTexture("mbd2:textures/gui/fluid_tank_overlay.png"));
            tankWidget.setId(prefix + "_" + i);
            tankWidget.setShowAmount(false);
            ui.addWidget((Widget)tankWidget);
        }
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof FluidTankCapabilityTrait) {
            FluidTankCapabilityTrait fluidTankTrait = (FluidTankCapabilityTrait)trait;
            String prefix = this.uiPrefixName();
            IO guiIO = this.getGuiIO();
            IngredientIO ingredientIO = guiIO == IO.IN ? IngredientIO.INPUT : (guiIO == IO.OUT ? IngredientIO.OUTPUT : (guiIO == IO.BOTH ? IngredientIO.BOTH : IngredientIO.RENDER_ONLY));
            WidgetUtils.widgetByIdForEach(group, "^%s_[0-9]+$".formatted(prefix), TankWidget.class, tankWidget -> {
                int index = WidgetUtils.widgetIdIndex((Widget)tankWidget);
                if (index >= 0 && index < fluidTankTrait.storages.length) {
                    tankWidget.setFluidTank((IFluidStorage)fluidTankTrait.storages[index]);
                    tankWidget.setIngredientIO(ingredientIO);
                    tankWidget.setAllowClickDrained(guiIO.support(IO.IN));
                    tankWidget.setAllowClickFilled(guiIO.support(IO.OUT));
                }
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderAfterWorldInTraitPanel(MachineTraitPanel panel) {
        int color;
        super.renderAfterWorldInTraitPanel(panel);
        if (!this.autoInput.enable && !this.autoOutput.enable) {
            return;
        }
        PoseStack poseStack = new PoseStack();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFunc((int)770, (int)771);
        poseStack.m_85836_();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172757_);
        buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        RenderSystem.lineWidth((float)5.0f);
        if (this.autoOutput.enable) {
            color = -1153792;
            RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)this.autoOutput.range.f_82288_), (float)((float)this.autoOutput.range.f_82289_), (float)((float)this.autoOutput.range.f_82290_), (float)((float)this.autoOutput.range.f_82291_), (float)((float)this.autoOutput.range.f_82292_), (float)((float)this.autoOutput.range.f_82293_), (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        }
        if (this.autoInput.enable) {
            color = -15619346;
            RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)this.autoInput.range.f_82288_), (float)((float)this.autoInput.range.f_82289_), (float)((float)this.autoInput.range.f_82290_), (float)((float)this.autoInput.range.f_82291_), (float)((float)this.autoInput.range.f_82292_), (float)((float)this.autoInput.range.f_82293_), (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        }
        tessellator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    public int getTankSize() {
        return this.tankSize;
    }

    public void setTankSize(int tankSize) {
        this.tankSize = tankSize;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public boolean isAllowSameFluids() {
        return this.allowSameFluids;
    }

    public void setAllowSameFluids(boolean allowSameFluids) {
        this.allowSameFluids = allowSameFluids;
    }

    public FluidFilterSettings getFluidFilterSettings() {
        return this.fluidFilterSettings;
    }

    public ToggleAutoIO getAutoIO() {
        return this.autoIO;
    }

    public AutoWorldIO getAutoInput() {
        return this.autoInput;
    }

    public AutoWorldIO getAutoOutput() {
        return this.autoOutput;
    }
}

