/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.fluid;

import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidHandlerWrapper
implements IFluidHandler {
    private final FluidStorage[] storages;
    private final IO io;
    private final boolean allowSameFluids;

    public FluidHandlerWrapper(FluidStorage[] storages, IO io, boolean allowSameFluids) {
        this.storages = storages;
        this.io = io;
        this.allowSameFluids = allowSameFluids;
    }

    private boolean canCapInput() {
        return this.io == IO.IN || this.io == IO.BOTH;
    }

    private boolean canCapOutput() {
        return this.io == IO.OUT || this.io == IO.BOTH;
    }

    public int getTanks() {
        return this.storages.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return FluidHelperImpl.toFluidStack((com.lowdragmc.lowdraglib.side.fluid.FluidStack)this.storages[tank].getFluid());
    }

    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.storages[tank].setFluid(FluidHelperImpl.toFluidStack((FluidStack)fluidStack));
    }

    public int getTankCapacity(int tank) {
        return (int)this.storages[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.storages[tank].isFluidValid(FluidHelperImpl.toFluidStack((FluidStack)stack));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.canCapInput()) {
            return (int)this.fillInternal(FluidHelperImpl.toFluidStack((FluidStack)resource), action.simulate());
        }
        return 0;
    }

    public long fillInternal(com.lowdragmc.lowdraglib.side.fluid.FluidStack resource, boolean simulate) {
        if (resource.isEmpty()) {
            return 0L;
        }
        com.lowdragmc.lowdraglib.side.fluid.FluidStack copied = resource.copy();
        FluidStorage existingStorage = null;
        if (!this.allowSameFluids) {
            for (FluidStorage storage : this.storages) {
                if (storage.getFluid().isEmpty() || !storage.getFluid().isFluidEqual(resource)) continue;
                existingStorage = storage;
                break;
            }
        }
        if (existingStorage == null) {
            for (FluidStorage storage : this.storages) {
                long filled = storage.fill(copied.copy(), simulate);
                if (filled > 0L) {
                    copied.shrink(filled);
                    if (!this.allowSameFluids) break;
                }
                if (!copied.isEmpty()) {
                    continue;
                }
                break;
            }
        } else {
            copied.shrink(existingStorage.fill(copied.copy(), simulate));
        }
        return resource.getAmount() - copied.getAmount();
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.canCapOutput()) {
            return FluidHelperImpl.toFluidStack((com.lowdragmc.lowdraglib.side.fluid.FluidStack)this.drainInternal(FluidHelperImpl.toFluidStack((FluidStack)resource), action.simulate()));
        }
        return FluidStack.EMPTY;
    }

    public com.lowdragmc.lowdraglib.side.fluid.FluidStack drainInternal(com.lowdragmc.lowdraglib.side.fluid.FluidStack resource, boolean simulate) {
        if (!resource.isEmpty()) {
            com.lowdragmc.lowdraglib.side.fluid.FluidStack copied = resource.copy();
            for (FluidStorage transfer : this.storages) {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack candidate = copied.copy();
                copied.shrink(transfer.drain(candidate, simulate).getAmount());
                if (copied.isEmpty()) break;
            }
            copied.setAmount(resource.getAmount() - copied.getAmount());
            return copied;
        }
        return com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty();
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.canCapOutput()) {
            return FluidHelperImpl.toFluidStack((com.lowdragmc.lowdraglib.side.fluid.FluidStack)this.drainInternal(maxDrain, action.simulate()));
        }
        return FluidStack.EMPTY;
    }

    public com.lowdragmc.lowdraglib.side.fluid.FluidStack drainInternal(long maxDrain, boolean simulate) {
        if (maxDrain == 0L) {
            return com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty();
        }
        com.lowdragmc.lowdraglib.side.fluid.FluidStack totalDrained = null;
        for (FluidStorage storage : this.storages) {
            if (totalDrained == null || totalDrained.isEmpty()) {
                totalDrained = storage.drain(maxDrain, simulate);
                if (totalDrained.isEmpty()) {
                    totalDrained = null;
                } else {
                    maxDrain -= totalDrained.getAmount();
                }
            } else {
                com.lowdragmc.lowdraglib.side.fluid.FluidStack copy = totalDrained.copy();
                copy.setAmount(maxDrain);
                com.lowdragmc.lowdraglib.side.fluid.FluidStack drain = storage.drain(copy, simulate);
                totalDrained.grow(drain.getAmount());
                maxDrain -= drain.getAmount();
            }
            if (maxDrain <= 0L) break;
        }
        return totalDrained == null ? com.lowdragmc.lowdraglib.side.fluid.FluidStack.empty() : totalDrained;
    }
}

