/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.DummyWorld;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.joml.Vector3f;

public abstract class FancyRendererSettings
implements IToggleConfigurable {
    @Persisted
    private boolean enable;
    @Configurable(name="config.definition.trait.filter.whitelist")
    protected boolean isWhiteList;
    @Configurable(name="config.definition.trait.fancy_renderer.filters", collapse=false, tips={"config.definition.trait.fancy_renderer.filters.tooltip"})
    protected List<String> filters = new ArrayList<String>();
    @Configurable(name="config.definition.trait.fancy_renderer.position", tips={"config.definition.trait.fancy_renderer.position.tooltip"})
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    protected Vector3f position = new Vector3f(0.0f, 0.0f, 0.0f);
    @Configurable(name="config.definition.trait.fancy_renderer.rotation", tips={"config.definition.trait.fancy_renderer.rotation.tooltip"})
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    protected Vector3f rotation = new Vector3f(0.0f, 0.0f, 0.0f);
    @Configurable(name="config.definition.trait.fancy_renderer.scale", tips={"config.definition.trait.fancy_renderer.scale.tooltip"})
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    protected Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
    @Configurable(name="config.definition.trait.fancy_renderer.rotate_orientation", tips={"config.definition.trait.fancy_renderer.rotate_orientation.tooltip"})
    protected boolean rotateOrientation = true;
    private Set<String> filterSet;
    private IRenderer renderer;

    public IRenderer getFancyRenderer(IMachine machine) {
        if (!this.enable) {
            return IRenderer.EMPTY;
        }
        if (this.filterSet == null) {
            this.filterSet = new HashSet<String>(this.filters);
        }
        if (!(machine.getLevel() instanceof DummyWorld)) {
            String state = ((MBDMachine)machine).getMachineStateName();
            if (this.isWhiteList ? !this.filterSet.contains(state) : this.filterSet.contains(state)) {
                return IRenderer.EMPTY;
            }
        }
        if (this.renderer == null) {
            this.renderer = this.createFancyRenderer();
        }
        return this.renderer;
    }

    public void clearCache() {
        this.renderer = null;
    }

    public abstract IRenderer createFancyRenderer();

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position = position;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public void setRotation(Vector3f rotation) {
        this.rotation = rotation;
    }

    public Vector3f getScale() {
        return this.scale;
    }

    public void setScale(Vector3f scale) {
        this.scale = scale;
    }

    public boolean isRotateOrientation() {
        return this.rotateOrientation;
    }

    public void setRotateOrientation(boolean rotateOrientation) {
        this.rotateOrientation = rotateOrientation;
    }
}

