/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class LightCondition
extends RecipeCondition {
    public static final LightCondition INSTANCE = new LightCondition();
    @Configurable(name="config.recipe.condition.light.min_sky_light")
    @NumberRange(range={0.0, 15.0})
    private int minSkyLight = 0;
    @Configurable(name="config.recipe.condition.light.max_sky_light")
    @NumberRange(range={0.0, 15.0})
    private int maxSkyLight = 15;
    @Configurable(name="config.recipe.condition.light.min_block_light")
    @NumberRange(range={0.0, 15.0})
    private int minBlockLight = 0;
    @Configurable(name="config.recipe.condition.light.max_block_light")
    @NumberRange(range={0.0, 15.0})
    private int maxBlockLight = 15;
    @Configurable(name="config.recipe.condition.light.can_see_sky", tips={"config.recipe.condition.light.can_see_sky.tooltip"})
    private boolean canSeeSky;

    public LightCondition(int minSkyLight, int maxSkyLight, int minBlockLight, int maxBlockLight, boolean canSeeSky) {
        this.minSkyLight = minSkyLight;
        this.maxSkyLight = maxSkyLight;
        this.minBlockLight = minBlockLight;
        this.maxBlockLight = maxBlockLight;
        this.canSeeSky = canSeeSky;
    }

    @Override
    public String getType() {
        return "light";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.light.tooltip", (Object[])new Object[]{this.minSkyLight, this.maxSkyLight, this.minBlockLight, this.maxBlockLight, this.canSeeSky});
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{Items.f_42152_});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.getLevel();
        BlockPos pos = recipeLogic.getMachine().getPos();
        int blockLight = level.m_45517_(LightLayer.BLOCK, pos);
        int skyLight = level.m_45517_(LightLayer.SKY, pos);
        return blockLight >= this.minBlockLight && blockLight <= this.maxBlockLight && skyLight >= this.minSkyLight && skyLight <= this.maxSkyLight && (!this.canSeeSky || level.m_45527_(pos));
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("minSkyLight", (Number)this.minSkyLight);
        config.addProperty("maxSkyLight", (Number)this.maxSkyLight);
        config.addProperty("minBlockLight", (Number)this.minBlockLight);
        config.addProperty("maxBlockLight", (Number)this.maxBlockLight);
        config.addProperty("canSeeSky", Boolean.valueOf(this.canSeeSky));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.minSkyLight = GsonHelper.m_13824_((JsonObject)config, (String)"minSkyLight", (int)0);
        this.maxSkyLight = GsonHelper.m_13824_((JsonObject)config, (String)"maxSkyLight", (int)15);
        this.minBlockLight = GsonHelper.m_13824_((JsonObject)config, (String)"minBlockLight", (int)0);
        this.maxBlockLight = GsonHelper.m_13824_((JsonObject)config, (String)"maxBlockLight", (int)15);
        this.canSeeSky = GsonHelper.m_13855_((JsonObject)config, (String)"canSeeSky", (boolean)false);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.minSkyLight = buf.m_130242_();
        this.maxSkyLight = buf.m_130242_();
        this.minBlockLight = buf.m_130242_();
        this.maxBlockLight = buf.m_130242_();
        this.canSeeSky = buf.readBoolean();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130130_(this.minSkyLight);
        buf.m_130130_(this.maxSkyLight);
        buf.m_130130_(this.minBlockLight);
        buf.m_130130_(this.maxBlockLight);
        buf.writeBoolean(this.canSeeSky);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128405_("minSkyLight", this.minSkyLight);
        tag.m_128405_("maxSkyLight", this.maxSkyLight);
        tag.m_128405_("minBlockLight", this.minBlockLight);
        tag.m_128405_("maxBlockLight", this.maxBlockLight);
        tag.m_128379_("canSeeSky", this.canSeeSky);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.minSkyLight = tag.m_128451_("minSkyLight");
        this.maxSkyLight = tag.m_128451_("maxSkyLight");
        this.minBlockLight = tag.m_128451_("minBlockLight");
        this.maxBlockLight = tag.m_128451_("maxBlockLight");
        this.canSeeSky = tag.m_128471_("canSeeSky");
        return this;
    }

    public int getMinSkyLight() {
        return this.minSkyLight;
    }

    public int getMaxSkyLight() {
        return this.maxSkyLight;
    }

    public int getMinBlockLight() {
        return this.minBlockLight;
    }

    public int getMaxBlockLight() {
        return this.maxBlockLight;
    }

    public boolean isCanSeeSky() {
        return this.canSeeSky;
    }

    public void setMinSkyLight(int minSkyLight) {
        this.minSkyLight = minSkyLight;
    }

    public void setMaxSkyLight(int maxSkyLight) {
        this.maxSkyLight = maxSkyLight;
    }

    public void setMinBlockLight(int minBlockLight) {
        this.minBlockLight = minBlockLight;
    }

    public void setMaxBlockLight(int maxBlockLight) {
        this.maxBlockLight = maxBlockLight;
    }

    public void setCanSeeSky(boolean canSeeSky) {
        this.canSeeSky = canSeeSky;
    }

    public LightCondition() {
    }
}

